/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.me4se;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.importer.LibraryImporter;
import org.eclipse.mtj.core.importer.impl.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.core.importer.properties.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.core.model.Version;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.impl.VMInstallClasspath;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.library.api.API;
import org.eclipse.mtj.core.model.library.api.APIType;
import org.eclipse.mtj.toolkit.me4se.ME4SEDevice;
import org.eclipse.mtj.toolkit.me4se.Messages;
import org.eclipse.mtj.toolkit.me4se.internal.Activator;

public class ME4SEDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final String EMULATOR_JAR_PREFIX = "me4se";
    private static final String EMULATOR_JAR_SUFFIX = ".jar";
    private static final String PROPS_FILE = "me4se.properties";

    public IDevice[] getMatchingDevices(File file, IProgressMonitor iProgressMonitor) {
        IDevice[] iDeviceArray = null;
        try {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.startsWith(ME4SEDeviceImporter.EMULATOR_JAR_PREFIX) && string.endsWith(ME4SEDeviceImporter.EMULATOR_JAR_SUFFIX);
                }
            });
            if (fileArray.length > 0) {
                IDevice iDevice = this.createDevice(fileArray[0]);
                iDeviceArray = new IDevice[]{iDevice};
            }
        }
        catch (Exception exception) {
            MTJCorePlugin.log((int)2, (String)Messages.ME4SEDeviceImporter_importing_error, (Throwable)exception);
        }
        return iDeviceArray;
    }

    private void addDeviceLibraries(File file, Classpath classpath, LibraryImporter libraryImporter) {
        String[] stringArray;
        String string = this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.CLASSPATH.toString(), Utils.EMPTY_STRING);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("me4sejar", file.toString());
        string = ReplaceableParametersProcessor.processReplaceableValues((String)string, hashMap);
        String[] stringArray2 = stringArray = string.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            ILibrary iLibrary = libraryImporter.createLibraryFor(new File(string2));
            API aPI = iLibrary.getAPI(APIType.CONFIGURATION);
            if (aPI != null) {
                aPI.setVersion(new Version("1.1"));
            }
            if ((aPI = iLibrary.getAPI(APIType.PROFILE)) != null) {
                aPI.setVersion(new Version("2.0"));
            }
            classpath.addEntry(iLibrary);
            ++n2;
        }
    }

    private IDevice createDevice(File file) {
        ME4SEDevice mE4SEDevice = new ME4SEDevice();
        mE4SEDevice.setBundle(Activator.getDefault().getBundle().getSymbolicName());
        mE4SEDevice.setClasspath(this.getDeviceClasspath(file));
        mE4SEDevice.setDebugServer(this.isDebugServer());
        mE4SEDevice.setDescription("ME4SE Device");
        mE4SEDevice.setDeviceProperties(new Properties());
        mE4SEDevice.setGroupName("ME4SE");
        mE4SEDevice.setName("ME4SE");
        mE4SEDevice.setPreverifier(this.getPreverifier(file));
        mE4SEDevice.setProtectionDomains(new String[0]);
        mE4SEDevice.setLaunchCommandTemplate(this.getLaunchCommand());
        mE4SEDevice.setJarFile(file);
        return mE4SEDevice;
    }

    private Classpath getDeviceClasspath(File file) {
        VMInstallClasspath vMInstallClasspath = new VMInstallClasspath();
        vMInstallClasspath.setPrependVMLibraries(false);
        this.addDeviceLibraries(file, (Classpath)vMInstallClasspath, new LibraryImporter());
        return vMInstallClasspath;
    }

    protected URL getDevicePropertiesURL() {
        return Activator.getDefault().getBundle().getEntry(PROPS_FILE);
    }
}

