/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.me4se;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.LaunchEnvironment;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.core.model.device.impl.JavaEmulatorDevice;
import org.eclipse.mtj.core.model.device.launch.properties.LaunchTemplateProperties;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;

public class ME4SEDevice
extends JavaEmulatorDevice {
    private File jarFile;

    public File getJarFile() {
        return this.jarFile;
    }

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        IMidletSuiteProject iMidletSuiteProject = launchEnvironment.getMidletSuite();
        ILaunchConfiguration iLaunchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean bl = this.shouldDirectLaunchJAD(iLaunchConfiguration);
        File file = this.copyForLaunch(iMidletSuiteProject, iProgressMonitor, bl);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(LaunchTemplateProperties.EXECUTABLE.toString(), this.getJavaExecutable().toString());
        hashMap.put("me4sejar", this.jarFile.toString());
        hashMap.put(LaunchTemplateProperties.CLASSPATH.toString(), this.getProjectClasspathString(iMidletSuiteProject, file, iProgressMonitor));
        if (launchEnvironment.isDebugLaunch()) {
            hashMap.put(LaunchTemplateProperties.DEBUGPORT.toString(), new Integer(launchEnvironment.getDebugListenerPort()).toString());
        }
        String string = iLaunchConfiguration.getAttribute("mtj.launch_params", Utils.EMPTY_STRING);
        hashMap.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), string);
        if (this.shouldDirectLaunchJAD(iLaunchConfiguration)) {
            hashMap.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(iLaunchConfiguration));
        } else {
            File file2 = this.getJadForLaunch(iMidletSuiteProject, file, iProgressMonitor);
            if (file2.exists()) {
                hashMap.put(LaunchTemplateProperties.JADFILE.toString(), file2.toString());
            }
        }
        return ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, hashMap);
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.loadUsing(iPersistenceProvider);
        String string = iPersistenceProvider.loadString("jarFile");
        this.jarFile = new File(string);
    }

    public void setJarFile(File file) {
        this.jarFile = file;
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.storeUsing(iPersistenceProvider);
        iPersistenceProvider.storeString("jarFile", this.jarFile.toString());
    }

    protected String getProjectClasspathString(IMidletSuiteProject iMidletSuiteProject, File file, IProgressMonitor iProgressMonitor) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer(super.getProjectClasspathString(iMidletSuiteProject, file, iProgressMonitor));
        stringBuffer.append(File.pathSeparatorChar);
        stringBuffer.append(this.jarFile);
        return stringBuffer.toString();
    }
}

