/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.mpowerplayer;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.importer.LibraryImporter;
import org.eclipse.mtj.core.importer.impl.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.core.importer.properties.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.core.model.Version;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.library.api.API;
import org.eclipse.mtj.core.model.library.api.APIType;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.core.model.preverifier.StandardPreverifierFactory;
import org.eclipse.mtj.toolkit.mpowerplayer.Messages;
import org.eclipse.mtj.toolkit.mpowerplayer.MpowerplayerDevice;
import org.eclipse.mtj.toolkit.mpowerplayer.MpowerplayerPlugin;

public class MpowerplayerDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final String MACOSX_OS_NAME = "Mac OS X";
    private static String osName = System.getProperty("os.name");
    private static final String PLAYER_JAR_NAME = "player.jar";
    private static final String PLAYER_MACOSX_PREVERIFIER = "/osx/preverify";
    private static final String PLAYER_MAIN_CLASS = "com.mpp.player.PowerPlayerApp";
    private static final String PROPS_FILE = "mpowerplayer.properties";

    public IDevice[] getMatchingDevices(File file, IProgressMonitor iProgressMonitor) {
        IDevice[] iDeviceArray = null;
        try {
            File file2 = new File(file, PLAYER_JAR_NAME);
            if (file2.exists() && this.hasMainClassAttribute(file2, PLAYER_MAIN_CLASS)) {
                IDevice iDevice = this.createDevice(file2);
                iDeviceArray = new IDevice[]{iDevice};
            }
        }
        catch (Exception exception) {
            MTJCorePlugin.log((int)2, (String)Messages.MpowerplayerDeviceImporter_import_error, (Throwable)exception);
        }
        return iDeviceArray;
    }

    private void addMplayerDeviceLibraries(File file, Classpath classpath, LibraryImporter libraryImporter) {
        String[] stringArray;
        String string = this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.CLASSPATH.toString(), Utils.EMPTY_STRING);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mpproot", file.getParent());
        string = ReplaceableParametersProcessor.processReplaceableValues((String)string, hashMap);
        String[] stringArray2 = stringArray = string.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            ILibrary iLibrary = libraryImporter.createLibraryFor(new File(string2));
            API aPI = iLibrary.getAPI(APIType.UNKNOWN);
            if (aPI != null) {
                if (aPI.getIdentifier().equalsIgnoreCase("cldc-1.1.jar")) {
                    aPI.setIdentifier("CLDC");
                    aPI.setType(APIType.CONFIGURATION);
                    aPI.setName("Connected Limited Device Configuration");
                    aPI.setVersion(new Version("1.1"));
                } else if (aPI.getIdentifier().equalsIgnoreCase("midp-2.0.jar")) {
                    aPI.setIdentifier("MIDP");
                    aPI.setType(APIType.PROFILE);
                    aPI.setName("Mobile Information Device Profile");
                    aPI.setVersion(new Version("2.0"));
                }
            }
            classpath.addEntry(iLibrary);
            ++n2;
        }
    }

    private IDevice createDevice(File file) {
        MpowerplayerDevice mpowerplayerDevice = new MpowerplayerDevice();
        mpowerplayerDevice.setBundle(MpowerplayerPlugin.getDefault().getBundle().getSymbolicName());
        mpowerplayerDevice.setClasspath(this.getDeviceClasspath(file));
        mpowerplayerDevice.setDebugServer(this.isDebugServer());
        mpowerplayerDevice.setDescription("Mpowerplayer Device");
        mpowerplayerDevice.setDeviceProperties(new Properties());
        mpowerplayerDevice.setGroupName("Mpowerplayer");
        mpowerplayerDevice.setName("Mpowerplayer");
        mpowerplayerDevice.setPreverifier(this.getPreverifier(file));
        mpowerplayerDevice.setProtectionDomains(new String[0]);
        mpowerplayerDevice.setLaunchCommandTemplate(this.getLaunchCommand());
        mpowerplayerDevice.setMppRoot(file.getParentFile());
        return mpowerplayerDevice;
    }

    private File findEmbeddedPreverifyExtecutable(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return file.isDirectory() || string.equals("preverify");
            }
        });
        File file2 = null;
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file3 = fileArray2[n2];
            if (!file3.isDirectory()) {
                file2 = file3;
                break;
            }
            file2 = this.findEmbeddedPreverifyExtecutable(file3);
            ++n2;
        }
        return file2;
    }

    private Classpath getDeviceClasspath(File file) {
        Classpath classpath = new Classpath();
        LibraryImporter libraryImporter = new LibraryImporter();
        this.addMplayerDeviceLibraries(file, classpath, libraryImporter);
        return classpath;
    }

    protected URL getDevicePropertiesURL() {
        return MpowerplayerPlugin.getDefault().getBundle().getEntry(PROPS_FILE);
    }

    protected IPreverifier getPreverifier(File file) {
        File file2;
        File file3;
        IPreverifier iPreverifier = super.getPreverifier(file);
        if (osName.equals(MACOSX_OS_NAME) && (file3 = this.findEmbeddedPreverifyExtecutable(file2 = new File(String.valueOf(file.getParentFile().getPath()) + PLAYER_MACOSX_PREVERIFIER))) != null) {
            try {
                iPreverifier = StandardPreverifierFactory.createPreverifier((File)file3);
            }
            catch (CoreException coreException) {
                MTJCorePlugin.log((int)2, (String)Messages.MpowerplayerDeviceImporter_preverifier_import_error, (Throwable)coreException);
            }
        }
        return iPreverifier;
    }
}

