/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.uei.internal.properties;

import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.toolkit.uei.Messages;
import org.eclipse.mtj.toolkit.uei.internal.properties.UEIDeviceDefinitionProperties;

public class UEIDeviceDefinition {
    private boolean debugServer;
    private String launchTemplate;
    private Pattern matchPattern;
    private String name;
    private boolean predeployRequired;

    public UEIDeviceDefinition(String string, Properties properties) throws IllegalArgumentException, NullPointerException {
        if (string == null) {
            throw new NullPointerException(Messages.UEIDeviceDefinition_deviceName_null);
        }
        if (properties == null) {
            throw new NullPointerException(Messages.UEIDeviceDefinition_properties_null);
        }
        String string2 = properties.getProperty(UEIDeviceDefinitionProperties.MATCH_EXPRESSION.createDeviceProperty(string));
        if (string2 == null) {
            throw new IllegalArgumentException(Messages.UEIDeviceDefinition_invalid_match_expression);
        }
        Pattern pattern = Pattern.compile(string2);
        boolean bl = properties.getProperty(UEIDeviceDefinitionProperties.DEBUG_SERVER.createDeviceProperty(string), Utils.EMPTY_STRING).equalsIgnoreCase(Boolean.TRUE.toString());
        boolean bl2 = properties.getProperty(UEIDeviceDefinitionProperties.PREDEPLOY_REQUIRED.createDeviceProperty(string), Utils.EMPTY_STRING).equalsIgnoreCase(Boolean.TRUE.toString());
        String string3 = properties.getProperty(UEIDeviceDefinitionProperties.LAUNCH_TEMPLATE.createDeviceProperty(string), Utils.EMPTY_STRING);
        this.setDebugServer(bl);
        this.setName(string);
        this.setMatchPattern(pattern);
        this.setLaunchTemplate(string3);
        this.setPredeployRequired(bl2);
    }

    public String getLaunchTemplate() {
        return this.launchTemplate;
    }

    public Pattern getMatchPattern() {
        return this.matchPattern;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebugServer() {
        return this.debugServer;
    }

    public boolean isPredeployRequired() {
        return this.predeployRequired;
    }

    public void setDebugServer(boolean bl) {
        this.debugServer = bl;
    }

    public void setLaunchTemplate(String string) {
        this.launchTemplate = string;
    }

    public void setMatchPattern(Pattern pattern) {
        this.matchPattern = pattern;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPredeployRequired(boolean bl) {
        this.predeployRequired = bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.debugServer ? 1231 : 1237);
        n = 31 * n + (this.launchTemplate == null ? 0 : this.launchTemplate.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.predeployRequired ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UEIDeviceDefinition uEIDeviceDefinition = (UEIDeviceDefinition)object;
        if (this.debugServer != uEIDeviceDefinition.debugServer) {
            return false;
        }
        if (this.launchTemplate == null ? uEIDeviceDefinition.launchTemplate != null : !this.launchTemplate.equals(uEIDeviceDefinition.launchTemplate)) {
            return false;
        }
        if (this.name == null ? uEIDeviceDefinition.name != null : !this.name.equals(uEIDeviceDefinition.name)) {
            return false;
        }
        return this.predeployRequired == uEIDeviceDefinition.predeployRequired;
    }
}

