/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.uei;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.importer.IDeviceImporter;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.core.model.preverifier.StandardPreverifierFactory;
import org.eclipse.mtj.core.model.preverifier.impl.StandardPreverifier;
import org.eclipse.mtj.toolkit.uei.Messages;
import org.eclipse.mtj.toolkit.uei.UEIDevice;
import org.eclipse.mtj.toolkit.uei.UeiPlugin;
import org.eclipse.mtj.toolkit.uei.internal.DeviceDefinitionManager;
import org.eclipse.mtj.toolkit.uei.internal.UEIPropertiesReader;
import org.eclipse.mtj.toolkit.uei.internal.properties.UEIDeviceDefinition;
import org.eclipse.mtj.toolkit.uei.model.properties.DeviceSpecificProperties;
import org.eclipse.mtj.toolkit.uei.model.properties.DevicesProperties;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UEIDeviceImporter
implements IDeviceImporter {
    public static final String PROP_TOOLKIT_NAME = "org.eclipse.mtj.toolkit.name";
    private static final String UNSUPORTED_CONFIGURATION = "CDC";

    public IDevice[] getMatchingDevices(File file, IProgressMonitor iProgressMonitor) {
        IDevice[] iDeviceArray = null;
        UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_getMatchingDevices_begin, (Object)file));
        File file2 = this.getEmulatorInDirectory(file);
        if (file2 != null) {
            UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_getMatchingDevices_emulator, (Object)file2));
            try {
                Properties properties = this.getUEIEmulatorProperties(file2);
                if (this.isValidUEIProperties(properties)) {
                    UeiPlugin.debugLog(Messages.UEIDeviceImporter_getMatchingDevices_invalid_props);
                    UEIDeviceDefinition uEIDeviceDefinition = this.getDeviceDefinition(properties);
                    UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_getMatchingDevices_device_def, (Object)uEIDeviceDefinition));
                    if (uEIDeviceDefinition != null) {
                        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
                        this.addUEIDevices(arrayList, file2, uEIDeviceDefinition, properties);
                        iDeviceArray = arrayList.toArray(new IDevice[arrayList.size()]);
                    }
                }
            }
            catch (CoreException coreException) {
                MTJCorePlugin.log((int)4, (String)Messages.UEIDeviceImporter_getMatchingDevices_failed, (Throwable)coreException);
            }
            catch (IOException iOException) {
                MTJCorePlugin.log((int)4, (String)Messages.UEIDeviceImporter_getMatchingDevices_failed, (Throwable)iOException);
            }
        }
        UeiPlugin.debugLog(String.valueOf(Messages.UEIDeviceImporter_getMatchingDevices_end) + file);
        return iDeviceArray;
    }

    private void addUEIDevices(ArrayList<IDevice> arrayList, File file, UEIDeviceDefinition uEIDeviceDefinition, Properties properties) throws CoreException {
        UeiPlugin.debugLog(Messages.UEIDeviceImporter_addUEIDevices_begin);
        String string = properties.getProperty(DevicesProperties.DEVICE_LIST.toString());
        UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_addUEIDevices_devices, (Object)string));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                IDevice iDevice = this.createDevice(file, uEIDeviceDefinition, properties, string2);
                if (iDevice == null || iDevice.getConfigurationLibrary().getConfiguration().getIdentifier().equals(UNSUPORTED_CONFIGURATION)) continue;
                arrayList.add(iDevice);
            }
        }
        UeiPlugin.debugLog(Messages.UEIDeviceImporter_addUEIDevices_end);
    }

    private IDevice createDevice(File file, UEIDeviceDefinition uEIDeviceDefinition, Properties properties, String string) throws CoreException {
        UeiPlugin.debugLog(NLS.bind((String)Messages.UEIDeviceImporter_createDevice, (Object)string));
        Properties properties2 = this.filterDeviceProperties(properties, string);
        UEIDevice uEIDevice = new UEIDevice(string, properties.getProperty(PROP_TOOLKIT_NAME, "Unknown"), this.getDeviceDescription(properties2, string), properties2, uEIDeviceDefinition, file, (IPreverifier)this.getPreverifier(file));
        return uEIDevice;
    }

    private Properties filterDeviceProperties(Properties properties, String string) {
        Properties properties2 = new Properties();
        String string2 = String.valueOf(string) + ".";
        int n = string2.length();
        for (String string3 : properties.keySet()) {
            if (!string3.startsWith(string2)) continue;
            String string4 = string3.substring(n);
            String string5 = properties.getProperty(string3);
            properties2.setProperty(string4, string5);
        }
        return properties2;
    }

    private UEIDeviceDefinition getDeviceDefinition(Properties properties) throws IOException {
        UEIDeviceDefinition uEIDeviceDefinition = null;
        String string = properties.getProperty(PROP_TOOLKIT_NAME, Utils.EMPTY_STRING);
        uEIDeviceDefinition = DeviceDefinitionManager.getInstance().getDeviceDefinition(string);
        return uEIDeviceDefinition;
    }

    private String getDeviceDescription(Properties properties, String string) {
        return properties.getProperty(DeviceSpecificProperties.DESCRIPTION.toString(), string).trim();
    }

    private File getEmulatorInDirectory(File file) {
        File[] fileArray = null;
        File file2 = null;
        try {
            fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().equalsIgnoreCase("emulator.exe") || file.getName().equals("emulator");
                }
            });
        }
        catch (SecurityException securityException) {
            MTJCorePlugin.log((int)4, (String)NLS.bind((String)Messages.UEIDeviceImporter_readAccessDenied, (Object)file), (Throwable)securityException);
        }
        if (fileArray != null && fileArray.length > 0) {
            file2 = fileArray[0];
        }
        return file2;
    }

    private StandardPreverifier getPreverifier(File file) throws CoreException {
        File file2 = new File(file.getParentFile(), "preverify");
        StandardPreverifier standardPreverifier = StandardPreverifierFactory.createPreverifier((File)file2);
        return standardPreverifier;
    }

    private Properties getUEIEmulatorProperties(File file) throws CoreException {
        return UEIPropertiesReader.getInstance().getUEIProperties(file);
    }

    private boolean isValidUEIProperties(Properties properties) {
        return properties != null && properties.containsKey(DevicesProperties.DEVICE_LIST.toString());
    }
}

