/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.editors.device;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.ui.editors.device.AbstractDeviceEditorPage;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.editors.device.pages.DeviceBasicEditorPage;
import org.eclipse.mtj.ui.internal.editors.device.pages.DeviceLibrariesEditorPage;
import org.eclipse.mtj.ui.internal.editors.device.pages.DevicePropertiesEditorPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DeviceEditorDialog
extends Dialog {
    private Label errorLabel;
    private TabFolder tabFolder;
    private AbstractDeviceEditorPage[] pages;
    private IDevice device;

    public DeviceEditorDialog(IShellProvider iShellProvider) {
        super(iShellProvider);
    }

    public DeviceEditorDialog(Shell shell) {
        super(shell);
    }

    public void setDevice(IDevice iDevice) {
        this.device = iDevice;
        if (this.pages != null) {
            this.setDeviceOnPages(iDevice);
        }
    }

    private void handleException(String string, Throwable throwable) {
        MTJCorePlugin.log((int)2, (String)"Error saving device", (Throwable)throwable);
        MTJUIPlugin.displayError(this.getShell(), 2, -999, "Error saving device", string, throwable);
    }

    private void setDeviceOnPages(IDevice iDevice) {
        AbstractDeviceEditorPage[] abstractDeviceEditorPageArray = this.pages;
        int n = this.pages.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDeviceEditorPage abstractDeviceEditorPage = abstractDeviceEditorPageArray[n2];
            abstractDeviceEditorPage.setDevice(iDevice);
            ++n2;
        }
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            try {
                AbstractDeviceEditorPage[] abstractDeviceEditorPageArray = this.pages;
                int n2 = this.pages.length;
                int n3 = 0;
                while (n3 < n2) {
                    AbstractDeviceEditorPage abstractDeviceEditorPage = abstractDeviceEditorPageArray[n3];
                    abstractDeviceEditorPage.commitDeviceChanges();
                    ++n3;
                }
            }
            catch (CoreException coreException) {
                this.handleException("Error saving device", coreException);
            }
        }
        super.buttonPressed(n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.device != null) {
            shell.setText("Edit " + this.device.getName() + " Definition");
        } else {
            shell.setText("Edit Device Definition");
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(1808));
        this.errorLabel = new Label(composite2, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.tabFolder = new TabFolder(composite2, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        AbstractDeviceEditorPage[] abstractDeviceEditorPageArray = this.pages = new AbstractDeviceEditorPage[]{new DeviceBasicEditorPage((Composite)this.tabFolder, this.isJavaExecutableDevice(), 0), new DeviceLibrariesEditorPage((Composite)this.tabFolder, 0), new DevicePropertiesEditorPage((Composite)this.tabFolder, 0)};
        int n = this.pages.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDeviceEditorPage abstractDeviceEditorPage = abstractDeviceEditorPageArray[n2];
            abstractDeviceEditorPage.setDialog(this);
            TabItem tabItem = new TabItem(this.tabFolder, 0);
            tabItem.setControl((Control)abstractDeviceEditorPage);
            tabItem.setText(abstractDeviceEditorPage.getTitle());
            if (this.device != null) {
                abstractDeviceEditorPage.setDevice(this.device);
            }
            ++n2;
        }
        return composite2;
    }

    protected boolean isJavaExecutableDevice() {
        return false;
    }

    void setErrorMessage(String string) {
        this.errorLabel.setText(string == null ? "" : string);
    }

    void updateCompletionState() {
        if (this.pages != null) {
            boolean bl = true;
            int n = 0;
            while (n < this.pages.length) {
                if (!this.pages[n].isValid()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(bl);
            }
        }
    }
}

