/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.configurations;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.configuration.Configuration;
import org.eclipse.mtj.core.model.configuration.Configurations;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSetRegistry;
import org.eclipse.mtj.core.model.preprocessor.symbol.Symbol;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolSet;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolSetFactory;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MetaData;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.ui.devices.DeviceSelector;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.configurations.ConfigurationMessages;
import org.eclipse.mtj.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.ui.viewers.TableViewerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ConfigAddAndEditWizardPage
extends WizardPage {
    private static final String CONFIG_WIZARD_SETTINGS = "ConfigWizardSettings";
    public static final String NAME = "configurationAddPage";
    private IMidletSuiteProject midletSuiteProject;
    private Configurations configurations;
    private Configuration configuration;
    private SymbolSet symbolSet;
    private List<Symbol> addedSymbols;
    private List<Symbol> removedSymbols;
    private boolean inEditMode;
    private boolean needChangeConfigName = true;
    private boolean symbolSetChanged;
    private DeviceSelector deviceSelector;
    private Text configNameText;
    private TableViewer symbolsTableViewer;
    private Button addSymbolButton;
    private Button removeSymbolButton;
    private CheckboxTableViewer workSpaceSymbolSetViewer;
    private static final String PROP_SYMBOL = "symbol";
    private static final String PROP_VALUE = "value";
    private static final String[] PROPERTIES = new String[]{"symbol", "value"};

    public ConfigAddAndEditWizardPage(Configurations configurations, Configuration configuration) {
        super(NAME);
        this.configurations = configurations;
        this.init(configuration);
    }

    private void addConfigurationNameSection(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(ConfigurationMessages.ConfigurationAddWizardPage_NewConfigurationName);
        this.configNameText = new Text(composite, 2048);
        this.configNameText.setLayoutData((Object)new GridData(768));
        this.configNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (ConfigAddAndEditWizardPage.this.needChangeConfigName) {
                    ConfigAddAndEditWizardPage.this.needChangeConfigName = false;
                }
                ConfigAddAndEditWizardPage.this.validateControls();
            }
        });
    }

    private void addDeviceSelectorSection(Composite composite) {
        this.deviceSelector = new DeviceSelector();
        this.deviceSelector.createContents(composite, true, true);
        this.deviceSelector.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (ConfigAddAndEditWizardPage.this.inEditMode) {
                    ConfigAddAndEditWizardPage.this.validateControls();
                    return;
                }
                IDevice iDevice = ConfigAddAndEditWizardPage.this.deviceSelector.getSelectedDevice();
                if (iDevice == null) {
                    return;
                }
                if (ConfigAddAndEditWizardPage.this.needChangeConfigName) {
                    ConfigAddAndEditWizardPage.this.configNameText.setText(iDevice.getName());
                    ConfigAddAndEditWizardPage.this.needChangeConfigName = true;
                }
                ConfigAddAndEditWizardPage.this.symbolSet = SymbolSetFactory.createSymbolSet((IDevice)iDevice);
                ConfigAddAndEditWizardPage.this.symbolsTableViewer.setInput((Object)ConfigAddAndEditWizardPage.this.symbolSet);
                ConfigAddAndEditWizardPage.this.validateControls();
            }
        });
    }

    private void addSymbol() {
        if (this.symbolSet == null) {
            return;
        }
        String string = "NewSymbol";
        Symbol symbol = null;
        int n = 1;
        while (n < 100) {
            string = "NewSymbol" + n;
            symbol = new Symbol(string, "true");
            if (!this.symbolSet.contains((Object)symbol)) {
                this.symbolSet.add((Object)symbol);
                this.recordAddedSymbols(symbol);
                break;
            }
            ++n;
        }
        this.symbolsTableViewer.refresh();
        this.makeAddedSymbolSelected(symbol);
        this.symbolSetChanged = true;
    }

    private void addSymbolButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        this.addSymbolButton = new Button(composite2, 8);
        this.addSymbolButton.setText("Add");
        this.addSymbolButton.setLayoutData((Object)new GridData(768));
        this.addSymbolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigAddAndEditWizardPage.this.addSymbol();
            }
        });
        this.removeSymbolButton = new Button(composite2, 8);
        this.removeSymbolButton.setText("Remove");
        this.removeSymbolButton.setLayoutData((Object)new GridData(768));
        this.removeSymbolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigAddAndEditWizardPage.this.removeSymbol();
            }
        });
    }

    private void addSymbolSetSection(Composite composite) {
        Group group = new Group(composite, 4);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        group.setText(ConfigurationMessages.Symbols);
        GridData gridData2 = new GridData(1808);
        gridData2.minimumWidth = 400;
        gridData2.heightHint = 300;
        this.symbolsTableViewer = this.createSymbolSetTableViewer((Composite)group);
        this.symbolsTableViewer.getTable().setLayoutData((Object)gridData2);
        this.addSymbolButtons((Composite)group);
    }

    private void addWorkSpaceScopeSymbolSetChooseSection(Composite composite) {
        Group group = new Group(composite, 4);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        group.setText(ConfigurationMessages.WorkspaceSymbolSetViewer_GroupText);
        gridData = new GridData();
        int n = 68130;
        Table table = new Table((Composite)group, n);
        gridData = new GridData(1808);
        gridData.heightHint = 100;
        gridData.widthHint = 400;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.workSpaceSymbolSetViewer = new CheckboxTableViewer(table);
        this.workSpaceSymbolSetViewer.setContentProvider((IContentProvider)new WorkSpaceSymbolSetTableContentProvider());
        this.workSpaceSymbolSetViewer.setLabelProvider((IBaseLabelProvider)new WorkSpaceSymbolSetTableLabelProvider());
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings(CONFIG_WIZARD_SETTINGS);
        TableColumnInfo[] tableColumnInfoArray = new TableColumnInfo[]{new TableColumnInfo(ConfigurationMessages.WorkspaceSymbolSetViewer_ColumnTitle_Choose, 20.0f, null), new TableColumnInfo(ConfigurationMessages.WorkspaceSymbolSetViewer_ColumnTitle_SymbolSet, 80.0f, null)};
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, 400, tableColumnInfoArray, 1);
        tableViewerConfiguration.configure((TableViewer)this.workSpaceSymbolSetViewer);
        Button button = new Button((Composite)group, 8);
        button.setText(ConfigurationMessages.WorkspaceSymbolSetViewer_ManageButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Shell shell = selectionEvent.widget.getDisplay().getActiveShell();
                PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
                PreferenceDialog preferenceDialog = new PreferenceDialog(shell, preferenceManager);
                preferenceDialog.setSelectedNode("org.eclipse.mtj.ui.preferences.symbolDefinitionsPreferencePage");
                if (preferenceDialog.open() == 0) {
                    ConfigAddAndEditWizardPage.this.initWorkspaceSymbolSetViewer();
                }
            }
        });
    }

    public void createControl(Composite composite) {
        composite.setLayoutData((Object)new GridData(1808));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.addConfigurationNameSection(composite2);
        this.addDeviceSelectorSection(composite2);
        this.addSymbolSetSection(composite2);
        this.addWorkSpaceScopeSymbolSetChooseSection(composite2);
        this.initializeControls();
        this.setControl((Control)composite2);
    }

    private TableViewer createSymbolSetTableViewer(Composite composite) {
        int n = 68098;
        Table table = new Table(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new SymbolsTableContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new SymbolsLabelProvider());
        tableViewer.setSorter(new ViewerSorter());
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings(CONFIG_WIZARD_SETTINGS);
        int n2 = 650;
        TableColumnInfo[] tableColumnInfoArray = new TableColumnInfo[]{new TableColumnInfo("Symbol", 40.0f, null), new TableColumnInfo("Value", 60.0f, null)};
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, n2, tableColumnInfoArray, 0);
        tableViewerConfiguration.configure(tableViewer);
        tableViewer.setCellModifier((ICellModifier)new CellModifier());
        tableViewer.setColumnProperties(PROPERTIES);
        tableViewer.setCellEditors(new CellEditor[]{new SymbolNameCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ConfigAddAndEditWizardPage.this.validateControls();
            }
        });
        return tableViewer;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private int getDeviceCount() {
        int n = 0;
        DeviceRegistry deviceRegistry = DeviceRegistry.singleton;
        try {
            n = deviceRegistry.getDeviceCount();
        }
        catch (PersistenceException persistenceException) {
            MTJCorePlugin.log((int)2, (String)"Error retrieving device count", (Throwable)persistenceException);
        }
        return n;
    }

    private void init(Configuration configuration) {
        this.configuration = configuration;
        if (configuration != null) {
            this.inEditMode = true;
        }
        if (this.inEditMode) {
            this.setTitle(ConfigurationMessages.EditConfiguration);
            this.setDescription(ConfigurationMessages.ConfigAddAndEditWizardPage_EditConfigDescription);
        } else {
            this.setTitle(ConfigurationMessages.AddConfiguration);
            this.setDescription(ConfigurationMessages.ConfigAddAndEditWizardPage_AddConfigDescription);
        }
    }

    private void initializeControls() {
        if (this.configuration == null) {
            this.deviceSelector.setSelectedDevice(null);
        } else {
            this.deviceSelector.setSelectedDevice(this.configuration.getDevice());
            this.configNameText.setText(this.configuration.getName());
            this.symbolSet = this.configuration.getSymbolSet();
            this.symbolsTableViewer.setInput((Object)this.symbolSet);
        }
        this.initWorkspaceSymbolSetViewer();
        this.validateControls();
        this.setErrorMessage(null);
    }

    private void initWorkspaceSymbolSetViewer() {
        try {
            this.workSpaceSymbolSetViewer.setInput((Object)SymbolDefinitionSetRegistry.singleton.getAllSetDefinitions());
        }
        catch (PersistenceException persistenceException) {
            MTJCorePlugin.log((int)4, (Throwable)persistenceException);
            return;
        }
        if (this.configuration != null) {
            List list = this.configuration.getWorkspaceScopeSymbolSets();
            this.workSpaceSymbolSetViewer.setCheckedElements(list.toArray());
        }
    }

    private boolean isValidSymbol(String string) {
        boolean bl = false;
        Pattern pattern = Pattern.compile(".*\\s+.*");
        if (string != null) {
            Matcher matcher = pattern.matcher(string);
            bl = !matcher.matches();
        }
        return bl;
    }

    private void makeAddedSymbolSelected(Symbol symbol) {
        TableItem[] tableItemArray = this.symbolsTableViewer.getTable().getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            if (symbol.equals(tableItemArray[n].getData())) break;
            ++n;
        }
        this.symbolsTableViewer.getTable().select(n);
        this.symbolsTableViewer.getTable().forceFocus();
    }

    public void performCancel() {
        this.restoreSymbolSet();
    }

    public void performFinish() {
        String string = this.configNameText.getText().trim();
        if (this.inEditMode) {
            this.configuration.setName(string);
            this.configuration.setDevice(this.deviceSelector.getSelectedDevice());
        } else {
            this.configuration = new Configuration(string);
            this.configuration.setDevice(this.deviceSelector.getSelectedDevice());
            this.configuration.setSymbolSet(this.symbolSet);
            this.configurations.add(this.configuration);
        }
        this.setWorkspaceSymbolSets();
        if (this.symbolSetChanged) {
            this.configuration.fireSymbolSetChanged();
        }
    }

    private void recordAddedSymbols(Symbol symbol) {
        if (this.addedSymbols == null) {
            this.addedSymbols = new ArrayList<Symbol>();
        }
        this.addedSymbols.add(symbol);
    }

    private void recordRemovedSymbols(Symbol symbol) {
        if (this.removedSymbols == null) {
            this.removedSymbols = new ArrayList<Symbol>();
        }
        this.removedSymbols.add(symbol);
    }

    private void removeSymbol() {
        TableItem[] tableItemArray;
        if (this.symbolSet == null) {
            return;
        }
        Table table = this.symbolsTableViewer.getTable();
        TableItem[] tableItemArray2 = tableItemArray = table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray2[n2];
            Symbol symbol = (Symbol)tableItem.getData();
            this.symbolSet.remove((Object)symbol);
            this.recordRemovedSymbols(symbol);
            ++n2;
        }
        this.symbolsTableViewer.refresh();
        this.symbolSetChanged = true;
    }

    private void restoreSymbolSet() {
        if (!this.inEditMode) {
            return;
        }
        if (!this.symbolSetChanged) {
            return;
        }
        if (this.midletSuiteProject != null) {
            Configurations configurations = new MetaData(this.midletSuiteProject.getProject()).getConfigurations();
            Configuration configuration = (Configuration)configurations.get(configurations.indexOf((Object)this.configuration));
            this.configurations.remove((Object)this.configuration);
            this.configurations.add(configuration);
            if (this.configuration.isActive()) {
                this.configurations.switchActiveConfiguration(configuration);
            }
            return;
        }
        if (this.removedSymbols != null) {
            this.symbolSet.addAll(this.removedSymbols);
            this.removedSymbols.clear();
        }
        if (this.addedSymbols != null) {
            this.symbolSet.removeAll(this.addedSymbols);
            this.addedSymbols.clear();
        }
    }

    public void setMidletSuiteProject(IMidletSuiteProject iMidletSuiteProject) {
        this.midletSuiteProject = iMidletSuiteProject;
    }

    private void setWorkspaceSymbolSets() {
        Object[] objectArray = this.workSpaceSymbolSetViewer.getCheckedElements();
        ArrayList<SymbolDefinitionSet> arrayList = new ArrayList<SymbolDefinitionSet>();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            arrayList.add((SymbolDefinitionSet)object);
            ++n2;
        }
        this.configuration.setWorkspaceScopeSymbolSets(arrayList);
    }

    private void validateControls() {
        this.validateRemoveSymbolButton();
        boolean bl = this.validConfigName() && this.validDevice();
        this.setPageComplete(bl);
    }

    private void validateRemoveSymbolButton() {
        boolean bl = this.symbolsTableViewer.getTable().getSelection().length > 0;
        this.removeSymbolButton.setEnabled(bl);
        this.addSymbolButton.setEnabled(this.symbolSet != null);
    }

    private boolean validConfigName() {
        String string = this.configNameText.getText();
        boolean bl = !this.configurations.contains((Object)new Configuration(string));
        IStatus iStatus = ResourcesPlugin.getWorkspace().validateName(string, 1);
        boolean bl2 = !iStatus.isOK() ? false : (this.inEditMode ? (this.configuration.getName().equals(string) ? true : bl) : bl);
        if (!bl2) {
            this.setErrorMessage(ConfigurationMessages.ErrorMessage_InvalidConfigName);
        } else {
            this.setErrorMessage(null);
        }
        return bl2;
    }

    private boolean validDevice() {
        IDevice iDevice = this.deviceSelector.getSelectedDevice();
        if (this.getDeviceCount() <= 0) {
            this.setErrorMessage(ConfigurationMessages.ErrorMessage_NoDeviceAvailable);
            return false;
        }
        if (iDevice == null) {
            this.setErrorMessage(ConfigurationMessages.ErrorMessage_NoDeviceSelected);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private class CellModifier
    implements ICellModifier {
        private Symbol symbol;

        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            Symbol symbol;
            String string2 = null;
            this.symbol = symbol = (Symbol)object;
            string2 = string.equals(ConfigAddAndEditWizardPage.PROP_SYMBOL) ? symbol.getName() : symbol.getValue();
            return string2;
        }

        public void modify(Object object, String string, Object object2) {
            if (this.symbol != null) {
                if (string.equals(ConfigAddAndEditWizardPage.PROP_SYMBOL)) {
                    String string2 = (String)object2;
                    if (this.symbol.getName().equals(string2)) {
                        return;
                    }
                    if (ConfigAddAndEditWizardPage.this.isValidSymbol(string2)) {
                        ConfigAddAndEditWizardPage.this.symbolSet.remove((Object)this.symbol);
                        this.symbol.setName(string2);
                        ConfigAddAndEditWizardPage.this.symbolSet.add((Object)this.symbol);
                        ConfigAddAndEditWizardPage.this.symbolSetChanged = true;
                    }
                } else {
                    if (this.symbol.getValue().equals(object2)) {
                        return;
                    }
                    this.symbol.setValue(String.valueOf(object2));
                    ConfigAddAndEditWizardPage.this.symbolSetChanged = true;
                }
                ConfigAddAndEditWizardPage.this.symbolsTableViewer.refresh();
            }
        }
    }

    private class SymbolNameCellEditor
    extends TextCellEditor {
        public SymbolNameCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new SymbolNameCellEditorValidator());
            this.addListener(new ICellEditorListener(){

                public void applyEditorValue() {
                }

                public void cancelEditor() {
                }

                public void editorValueChanged(boolean bl, boolean bl2) {
                    if (!bl2) {
                        SymbolNameCellEditor.this.setErrorMessage(SymbolNameCellEditor.this.getErrorMessage());
                    } else {
                        SymbolNameCellEditor.this.setErrorMessage(null);
                    }
                }
            });
        }

        protected void doSetValue(Object object) {
            if (this.isValueValid()) {
                super.doSetValue(object);
            }
        }
    }

    private class SymbolNameCellEditorValidator
    implements ICellEditorValidator {
        private SymbolNameCellEditorValidator() {
        }

        public String isValid(Object object) {
            String string = (String)object;
            return ConfigAddAndEditWizardPage.this.isValidSymbol(string) ? null : "Whitespace not allowed in symbol names.";
        }
    }

    private class SymbolsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SymbolsLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            Symbol symbol = (Symbol)object;
            switch (n) {
                case 0: {
                    return symbol.getName();
                }
                case 1: {
                    return symbol.getValue();
                }
            }
            return "";
        }
    }

    private class SymbolsTableContentProvider
    implements IStructuredContentProvider {
        private SymbolsTableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            SymbolSet symbolSet = (SymbolSet)object;
            return symbolSet.toArray((Object[])new Symbol[symbolSet.size()]);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class WorkSpaceSymbolSetTableContentProvider
    implements IStructuredContentProvider {
        private WorkSpaceSymbolSetTableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return (SymbolDefinitionSet[])object;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class WorkSpaceSymbolSetTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int COL_CHECKBOX = 0;
        private static final int COL_STMBOLSET_NAME = 1;

        private WorkSpaceSymbolSetTableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            SymbolDefinitionSet symbolDefinitionSet = (SymbolDefinitionSet)object;
            switch (n) {
                case 0: {
                    return "";
                }
                case 1: {
                    return symbolDefinitionSet.getName();
                }
            }
            return "";
        }
    }
}

