/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.dialog;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SigningPasswordsDialog
extends TitleAreaDialog {
    private static final String DIALOG_TITLE = "Enter passwords";
    private static final String DIALOG_MESSAGE1 = "Enter passwords for project \"{0}\"";
    private static final String DIALOG_MESSAGE2 = "Enter passwords for project";
    private static final String KEYSTORE_PWD_LABEL = "Keystore password:";
    private static final String KEY_PWD_LABEL = "Key password:";
    private Text keystorePasswordText;
    private Text keyPasswordText;
    private String keystorePassword;
    private String keyPassword;
    private String dialogMessage;
    private Button okButton;

    public SigningPasswordsDialog(Shell shell, IProject iProject) {
        super(shell);
        try {
            IProjectDescription iProjectDescription = iProject.getDescription();
            String string = iProjectDescription.getName();
            Object[] objectArray = new String[]{string};
            this.dialogMessage = MessageFormat.format(DIALOG_MESSAGE1, objectArray);
        }
        catch (CoreException coreException) {
            this.dialogMessage = DIALOG_MESSAGE2;
        }
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeyPassword(String string) {
        this.keyPassword = string;
    }

    public void setKeystorePassword(String string) {
        this.keystorePassword = string;
    }

    private GridData buildGridData(int n, boolean bl, int n2) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = n;
        gridData.grabExcessHorizontalSpace = bl;
        gridData.horizontalSpan = n2;
        return gridData;
    }

    private void updateButtons() {
        if (this.okButton == null || this.keystorePasswordText == null || this.keyPasswordText == null) {
            return;
        }
        String string = this.keystorePasswordText.getText();
        if (string == null) {
            this.okButton.setEnabled(false);
            return;
        }
        if (string.length() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        string = this.keyPasswordText.getText();
        if (string == null) {
            this.okButton.setEnabled(false);
            return;
        }
        if (string.length() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(true);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setTitle(DIALOG_TITLE);
        this.setMessage(this.dialogMessage, 1);
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite((Composite)super.createDialogArea(composite), 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(KEYSTORE_PWD_LABEL);
        this.keystorePasswordText = new Text(composite2, 0x400804);
        this.keystorePasswordText.setLayoutData((Object)this.buildGridData(4, true, 1));
        if (this.keystorePassword != null) {
            this.keystorePasswordText.setText(this.keystorePassword);
        }
        label = new Label(composite2, 0);
        label.setText(KEY_PWD_LABEL);
        this.keyPasswordText = new Text(composite2, 0x400804);
        this.keyPasswordText.setLayoutData((Object)this.buildGridData(4, true, 1));
        if (this.keyPassword != null) {
            this.keyPasswordText.setText(this.keyPassword);
        }
        this.keystorePasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SigningPasswordsDialog.this.updateButtons();
            }
        });
        this.keyPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SigningPasswordsDialog.this.updateButtons();
            }
        });
        this.updateButtons();
        return composite2;
    }

    protected void okPressed() {
        this.keystorePassword = this.keystorePasswordText.getText();
        this.keyPassword = this.keyPasswordText.getText();
        super.okPressed();
    }
}

