/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mtj.core.library.manager.LibraryManager;
import org.eclipse.mtj.core.library.model.ILibrary;
import org.eclipse.mtj.ui.internal.actions.WorkbenchRunnableAdapter;
import org.eclipse.mtj.ui.internal.properties.PropertyPagesMessages;
import org.eclipse.mtj.ui.internal.utils.ExceptionHandler;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.mtj.ui.internal.wizards.libraries.LibrarySelectionBlock;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class LibraryPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private List<IClasspathEntry> basicCPEntries = null;
    private boolean dirty = false;
    private IClasspathEntry[] origCPEntries = null;
    private LibrarySelectionBlock selectionBlock = new LibrarySelectionBlock();

    public LibraryPropertyPage() {
        this.basicCPEntries = new ArrayList<IClasspathEntry>();
    }

    public void createControl(Composite composite) {
        this.noDefaultAndApplyButton();
        super.createControl(composite);
    }

    public String getDescription() {
        return PropertyPagesMessages.LibraryPropertyPage_description;
    }

    public boolean performOk() {
        if (this.selectionBlock != null) {
            final IJavaProject iJavaProject = JavaCore.create((IProject)this.getCurrentProject());
            final ArrayList arrayList = new ArrayList();
            arrayList.clear();
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
                    for (IClasspathEntry iClasspathEntry : LibraryPropertyPage.this.basicCPEntries) {
                        arrayList.add(iClasspathEntry);
                    }
                    for (IPath iPath : LibraryPropertyPage.this.selectionBlock.getSelectedLibrariesPathEntries()) {
                        arrayList.add(JavaCore.newContainerEntry((IPath)iPath, (boolean)true));
                    }
                    iJavaProject.setRawClasspath(null, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    iJavaProject.setRawClasspath(arrayList.toArray(new IClasspathEntry[0]), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                }
            };
            WorkbenchRunnableAdapter workbenchRunnableAdapter = new WorkbenchRunnableAdapter(iWorkspaceRunnable);
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, false, (IRunnableWithProgress)workbenchRunnableAdapter);
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle(invocationTargetException, this.getShell(), PropertyPagesMessages.LibraryPropertyPage_error_title, PropertyPagesMessages.LibraryPropertyPage_error_message);
                try {
                    iJavaProject.setRawClasspath(this.origCPEntries, null);
                }
                catch (JavaModelException javaModelException) {
                    ExceptionHandler.handle(invocationTargetException, this.getShell(), PropertyPagesMessages.LibraryPropertyPage_restore_error_title, PropertyPagesMessages.LibraryPropertyPage_restore_error_message);
                }
                this.initBlockValues();
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public void setVisible(boolean bl) {
        if (this.selectionBlock != null && !bl && this.dirty) {
            String string = PropertyPagesMessages.LibraryPropertyPage_unsavedchanges_title;
            String string2 = PropertyPagesMessages.LibraryPropertyPage_unsavedchanges_message;
            String[] stringArray = new String[]{PropertyPagesMessages.LibraryPropertyPage_unsavedchanges_button_save, PropertyPagesMessages.LibraryPropertyPage_unsavedchanges_button_discard, PropertyPagesMessages.LibraryPropertyPage_unsavedchanges_button_ignore};
            MessageDialog messageDialog = new MessageDialog(this.getShell(), string, null, string2, 3, stringArray, 0);
            int n = messageDialog.open();
            if (n == 0) {
                this.performOk();
            } else if (n == 1) {
                this.initBlockValues();
            }
        }
        super.setVisible(bl);
    }

    private IProject getCurrentProject() {
        IProject iProject = null;
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable instanceof IProject) {
            iProject = (IProject)iAdaptable;
        } else if (iAdaptable instanceof IJavaProject) {
            iProject = ((IJavaProject)iAdaptable).getProject();
        }
        return iProject;
    }

    private void initBlockValues() {
        IJavaProject iJavaProject = JavaCore.create((IProject)this.getCurrentProject());
        this.basicCPEntries.clear();
        try {
            this.origCPEntries = iJavaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        if (this.origCPEntries != null) {
            IClasspathEntry[] iClasspathEntryArray = this.origCPEntries;
            int n = this.origCPEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                try {
                    if (iClasspathEntry.getEntryKind() == 5 && iClasspathEntry.getPath().segment(0).equals("org.eclipse.mtj.core.library.MIDLET_LIBRARY")) {
                        ILibrary iLibrary = LibraryManager.getInstance().getMidletLibrary(iClasspathEntry.getPath().segment(1));
                        if (iLibrary != null) {
                            this.selectionBlock.setChecked(iLibrary, true);
                        }
                    } else {
                        this.basicCPEntries.add(iClasspathEntry);
                    }
                }
                catch (Exception exception) {
                    this.basicCPEntries.add(iClasspathEntry);
                }
                ++n2;
            }
        }
    }

    protected Control createContents(Composite composite) {
        this.selectionBlock.createControl(composite);
        LibraryAdapter libraryAdapter = new LibraryAdapter();
        this.selectionBlock.setLibrarySelectionDialogFieldListener(libraryAdapter);
        this.initBlockValues();
        return this.selectionBlock.getControl();
    }

    public class LibraryAdapter
    implements IDialogFieldListener {
        public void dialogFieldChanged(DialogField dialogField) {
            if (LibraryPropertyPage.this.isControlCreated()) {
                LibraryPropertyPage.this.dirty = true;
            }
        }
    }
}

