/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.dialogfields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedListDialogField
extends ListDialogField {
    private int fCheckAllButtonIndex = -1;
    private List<Object> fCheckedElements = new ArrayList<Object>();
    private List<Object> fGrayedElements = new ArrayList<Object>();
    private int fUncheckAllButtonIndex = -1;

    public CheckedListDialogField(IListAdapter iListAdapter, String[] stringArray, ILabelProvider iLabelProvider) {
        super(iListAdapter, stringArray, iLabelProvider);
    }

    public void checkAll(boolean bl) {
        if (bl) {
            this.fCheckedElements = this.getElements();
        } else {
            this.fCheckedElements.clear();
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setAllChecked(bl);
        }
        this.checkStateChanged();
    }

    @Override
    public void dialogFieldChanged() {
        int n = this.fCheckedElements.size() - 1;
        while (n >= 0) {
            if (!this.fElements.contains(this.fCheckedElements.get(n))) {
                this.fCheckedElements.remove(n);
            }
            --n;
        }
        super.dialogFieldChanged();
    }

    public List<Object> getCheckedElements() {
        if (this.isOkToUse(this.fTableControl)) {
            Object[] objectArray = ((CheckboxTableViewer)this.fTable).getCheckedElements();
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                arrayList.add(object);
                ++n2;
            }
            return arrayList;
        }
        return new ArrayList<Object>(this.fCheckedElements);
    }

    public int getCheckedSize() {
        return this.fCheckedElements.size();
    }

    @Override
    public Control getListControl(Composite composite) {
        Control control = super.getListControl(composite);
        if (composite != null) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(this.fCheckedElements.toArray());
            ((CheckboxTableViewer)this.fTable).setGrayedElements(this.fGrayedElements.toArray());
        }
        return control;
    }

    public boolean isChecked(Object object) {
        if (this.isOkToUse(this.fTableControl)) {
            return ((CheckboxTableViewer)this.fTable).getChecked(object);
        }
        return this.fCheckedElements.contains(object);
    }

    public boolean isGrayed(Object object) {
        if (this.isOkToUse(this.fTableControl)) {
            return ((CheckboxTableViewer)this.fTable).getGrayed(object);
        }
        return this.fGrayedElements.contains(object);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(this.fCheckedElements.toArray());
            ((CheckboxTableViewer)this.fTable).setGrayedElements(this.fGrayedElements.toArray());
        }
    }

    @Override
    public void replaceElement(Object object, Object object2) throws IllegalArgumentException {
        boolean bl = this.isChecked(object);
        super.replaceElement(object, object2);
        this.setChecked(object2, bl);
    }

    public void setCheckAllButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fCheckAllButtonIndex = n;
    }

    public void setChecked(Object object, boolean bl) {
        this.setCheckedWithoutUpdate(object, bl);
        this.checkStateChanged();
    }

    public void setCheckedElements(Collection<Object> collection) {
        this.fCheckedElements = new ArrayList<Object>(collection);
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(collection.toArray());
        }
        this.checkStateChanged();
    }

    public void setCheckedWithoutUpdate(Object object, boolean bl) {
        if (bl) {
            if (!this.fCheckedElements.contains(object)) {
                this.fCheckedElements.add(object);
            }
        } else {
            this.fCheckedElements.remove(object);
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setChecked(object, bl);
        }
    }

    public void setGrayedWithoutUpdate(Object object, boolean bl) {
        if (bl) {
            if (!this.fGrayedElements.contains(object)) {
                this.fGrayedElements.add(object);
            }
        } else {
            this.fGrayedElements.remove(object);
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setGrayed(object, bl);
        }
    }

    public void setUncheckAllButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUncheckAllButtonIndex = n;
    }

    private void checkStateChanged() {
        super.dialogFieldChanged();
    }

    private void doCheckStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        if (checkStateChangedEvent.getChecked()) {
            this.fCheckedElements.add(checkStateChangedEvent.getElement());
        } else {
            this.fCheckedElements.remove(checkStateChangedEvent.getElement());
        }
        this.checkStateChanged();
    }

    @Override
    protected TableViewer createTableViewer(Composite composite) {
        Table table = new Table(composite, 32 + this.getListStyle());
        table.setFont(composite.getFont());
        CheckboxTableViewer checkboxTableViewer = new CheckboxTableViewer(table);
        checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                CheckedListDialogField.this.doCheckStateChanged(checkStateChangedEvent);
            }
        });
        return checkboxTableViewer;
    }

    @Override
    protected boolean getManagedButtonState(ISelection iSelection, int n) {
        if (n == this.fCheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        if (n == this.fUncheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        return super.getManagedButtonState(iSelection, n);
    }

    @Override
    protected boolean managedButtonPressed(int n) {
        if (n == this.fCheckAllButtonIndex) {
            this.checkAll(true);
        } else if (n == this.fUncheckAllButtonIndex) {
            this.checkAll(false);
        } else {
            return super.managedButtonPressed(n);
        }
        return true;
    }
}

