/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preferences;

import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.core.IMTJCoreConstants;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class J2MEPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IMTJCoreConstants {
    public static final String ID = "org.eclipse.mtj.ui.preferences.J2MEPreferencePage";
    private IntegerFieldEditor dbgTimeOut;
    private IntegerFieldEditor dbgServPoll;

    public J2MEPreferencePage() {
        super(1);
        this.setPreferenceStore(MTJUIPlugin.getDefault().getCorePreferenceStore());
        this.setDescription(MTJUIStrings.getString("pref.description"));
    }

    public void createFieldEditors() {
        int n = 3;
        Composite composite = this.getFieldEditorParent();
        this.addField((FieldEditor)new StringFieldEditor("deployment_dir", "Deployment Directory:", composite));
        this.addSpacer(composite, n);
        Group group = new Group(composite, 0);
        group.setText("Antenna Settings");
        group.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = this.getColumnSpanGridData(n);
        gridData.minimumWidth = 500;
        group.setLayoutData((Object)gridData);
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(3, true));
        composite2.setLayoutData((Object)new GridData(1808));
        FileFieldEditor fileFieldEditor = new FileFieldEditor("antenna_jar", "Antenna JAR:", true, composite2);
        fileFieldEditor.setFileExtensions(new String[]{"*.jar"});
        this.addField((FieldEditor)fileFieldEditor);
        DirectoryFieldEditor directoryFieldEditor = new DirectoryFieldEditor("wtk_root", "WTK Root:", composite2);
        this.addField((FieldEditor)directoryFieldEditor);
        this.addSpacer(composite, n);
        this.dbgTimeOut = new IntegerFieldEditor("rmt_debug_delay", "Debug Server Time-out (ms):", composite);
        this.dbgTimeOut.setErrorMessage(String.valueOf(this.dbgTimeOut.getLabelText()) + " " + this.dbgTimeOut.getErrorMessage());
        this.addField((FieldEditor)this.dbgTimeOut);
        this.dbgServPoll = new IntegerFieldEditor("rmt_debug_poll_interval", "Debug Server Launch Poll Interval (ms):", composite);
        this.dbgServPoll.setErrorMessage(String.valueOf(this.dbgServPoll.getLabelText()) + " " + this.dbgServPoll.getErrorMessage());
        this.addField((FieldEditor)this.dbgServPoll);
        Label label = new Label(composite, 0);
        label.setText("Maximum duration to launch a UEI emulator with debugger in server mode.");
        label.setLayoutData((Object)this.getColumnSpanGridData(n));
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        boolean bl = this.dbgServPoll.isValid();
        boolean bl2 = this.dbgTimeOut.isValid();
        if (!bl) {
            this.setErrorMessage(this.dbgServPoll.getErrorMessage());
        } else if (!bl2) {
            this.setErrorMessage(this.dbgTimeOut.getErrorMessage());
        }
    }

    private void addSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)this.getColumnSpanGridData(n));
    }

    private GridData getColumnSpanGridData(int n) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        return gridData;
    }

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_J2MEPreferencePage");
        return super.createContents(composite);
    }
}

