/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.projects;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.utils.ExceptionHandler;
import org.eclipse.mtj.ui.internal.wizards.NewElementWizard;
import org.eclipse.mtj.ui.internal.wizards.projects.Messages;
import org.eclipse.mtj.ui.internal.wizards.projects.NewMidletProjectWizardPageLibrary;
import org.eclipse.mtj.ui.internal.wizards.projects.NewMidletProjectWizardPageOne;
import org.eclipse.mtj.ui.internal.wizards.projects.NewMidletProjectWizardPageTwo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewMidletProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private IConfigurationElement configElement;
    private NewMidletProjectWizardPageOne firstPage;
    private NewMidletProjectWizardPageLibrary libraryPage;
    private NewMidletProjectWizardPageTwo secondPage;
    private IWorkbench workbench;

    public NewMidletProjectWizard() {
        this(null, null, null);
    }

    public NewMidletProjectWizard(NewMidletProjectWizardPageOne newMidletProjectWizardPageOne, NewMidletProjectWizardPageTwo newMidletProjectWizardPageTwo, NewMidletProjectWizardPageLibrary newMidletProjectWizardPageLibrary) {
        ImageDescriptor imageDescriptor = MTJUIPlugin.getIconImageDescriptor(Messages.NewMidletProjectWizard_image_descriptor);
        this.setDefaultPageImageDescriptor(imageDescriptor);
        this.setWindowTitle(Messages.NewMidletProjectWizard_wizard_title);
        this.firstPage = newMidletProjectWizardPageOne;
        this.secondPage = newMidletProjectWizardPageTwo;
        this.libraryPage = newMidletProjectWizardPageLibrary;
    }

    public void addPages() {
        if (this.firstPage == null) {
            this.firstPage = new NewMidletProjectWizardPageOne();
        }
        this.addPage((IWizardPage)this.firstPage);
        if (this.libraryPage == null) {
            this.libraryPage = new NewMidletProjectWizardPageLibrary();
        }
        if (this.libraryPage.isPageDisplayable()) {
            this.addPage((IWizardPage)this.libraryPage);
        }
        if (this.secondPage == null) {
            this.secondPage = new NewMidletProjectWizardPageTwo(this.firstPage, this.libraryPage);
        }
        this.addPage((IWizardPage)this.secondPage);
        this.firstPage.init(this.getSelection(), this.getActivePart());
    }

    public void createControl(Composite composite) {
    }

    public IJavaElement getCreatedElement() {
        return this.secondPage.getJavaProject();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.workbench = iWorkbench;
    }

    public boolean performCancel() {
        this.secondPage.performCancel();
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean bl = super.performFinish();
        if (bl) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
            try {
                IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.secondPage.getJavaProject());
                IFile iFile = iMidletSuiteProject.getApplicationDescriptorFile();
                if (iFile != null) {
                    BasicNewResourceWizard.selectAndReveal((IResource)iFile, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
                    this.openResource(iFile);
                }
            }
            catch (Throwable throwable) {
                MTJCorePlugin.log((int)4, (String)Messages.NewMidletProjectWizard_error_open_jad_file, (Throwable)throwable.getCause());
            }
        }
        return bl;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.configElement = iConfigurationElement;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            return iWorkbenchPage.getActivePart();
        }
        return null;
    }

    protected void finishPage(IProgressMonitor iProgressMonitor) throws InterruptedException, CoreException {
        this.secondPage.performFinish(iProgressMonitor);
    }

    protected void handleFinishException(Shell shell, InvocationTargetException invocationTargetException) {
        String string = Messages.NewMidletProjectWizard_error_create_project_window_title;
        String string2 = Messages.NewMidletProjectWizard_error_create_project_window_message;
        ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
    }
}

