/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.FormEntryAdapter;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesTreeSection;
import org.eclipse.mtj.internal.ui.editors.l10n.details.L10nAbstractDetails;
import org.eclipse.mtj.ui.internal.forms.parts.FormEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;

public class L10nLocaleDetails
extends L10nAbstractDetails {
    private L10nLocale locale = null;
    private FormEntry localeNameEntry = null;

    public L10nLocaleDetails(LocalesTreeSection localesTreeSection) {
        super(localesTreeSection, "l10n-context");
    }

    public void setData(L10nLocale l10nLocale) {
        this.locale = l10nLocale;
    }

    protected L10nObject getDataObject() {
        return this.locale;
    }

    public void createFields(Composite composite) {
        this.createAnchorIdWidget(composite);
    }

    private void createAnchorIdWidget(Composite composite) {
        this.localeNameEntry = new FormEntry(composite, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocaleDetails_localeNameEntry_label, 0);
        this.localeNameEntry.getText().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected String getDetailsTitle() {
        return MTJUIMessages.L10nLocaleDetails_detailsTitle;
    }

    protected String getDetailsDescription() {
        return MTJUIMessages.L10nLocaleDetails_detailsDescription;
    }

    public void hookListeners() {
        this.createLocaleNameEntryListeners();
    }

    private void createLocaleNameEntryListeners() {
        this.localeNameEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry formEntry) {
                if (L10nLocaleDetails.this.locale != null) {
                    L10nLocaleDetails.this.locale.setLocaleName(L10nLocaleDetails.this.localeNameEntry.getValue());
                }
            }
        });
    }

    public void updateFields() {
        if (this.locale != null) {
            this.updateAnchorIdEntry(this.isEditableElement());
        }
    }

    private void updateAnchorIdEntry(boolean bl) {
        this.localeNameEntry.setValue(this.locale.getLocaleName(), true);
        this.localeNameEntry.setEditable(bl);
    }

    public void commit(boolean bl) {
        super.commit(bl);
        this.localeNameEntry.commit();
    }

    public void selectionChanged(IFormPart iFormPart, ISelection iSelection) {
        Object object = this.getFirstSelectedObject(iSelection);
        if (object != null && object instanceof L10nLocale) {
            this.setData((L10nLocale)object);
            this.updateFields();
        }
    }
}

