/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.launching;

import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.launching.StackTraceEntry;
import org.eclipse.mtj.core.internal.launching.StackTraceParser;
import org.eclipse.mtj.ui.internal.launching.MTJStackTraceMatcher;
import org.eclipse.ui.console.IPatternMatchListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJConsoleLineTracker
implements IConsoleLineTracker {
    private Map<String, StackTraceEntry> cachedTrace;
    private IJavaProject project;
    private IConsole console;

    public void init(IConsole iConsole) {
        this.cachedTrace = new Hashtable<String, StackTraceEntry>();
        this.console = iConsole;
        try {
            IProject iProject;
            ILaunchConfiguration iLaunchConfiguration = iConsole.getProcess().getLaunch().getLaunchConfiguration();
            String string = iLaunchConfiguration.getAttribute("org.eclipse.jdt.launching.PROJECT_ATTR", "");
            if (string.length() > 0 && (iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string)).isOpen() && iProject.hasNature("org.eclipse.jdt.core.javanature")) {
                this.project = JavaCore.create((IProject)iProject);
                StackTraceParser stackTraceParser = new StackTraceParser(this.project);
                MTJStackTraceMatcher mTJStackTraceMatcher = new MTJStackTraceMatcher(this, stackTraceParser);
                this.console.addPatternMatchListener((IPatternMatchListener)mTJStackTraceMatcher);
            }
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)4, (String)coreException.getMessage(), (Throwable)coreException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineAppended(IRegion iRegion) {
        block6: {
            try {
                String string = this.console.getDocument().get(iRegion.getOffset(), iRegion.getLength());
                if (!Pattern.matches("(\tat .+[(][+]\\d+[)])", string)) break block6;
                StackTraceEntry stackTraceEntry = null;
                Map<String, StackTraceEntry> map = this.cachedTrace;
                synchronized (map) {
                    stackTraceEntry = this.cachedTrace.get(string);
                    if (stackTraceEntry == null) {
                        stackTraceEntry = new StackTraceEntry(string);
                        this.cachedTrace.put(string, stackTraceEntry);
                    }
                }
                stackTraceEntry.addRegion(iRegion);
            }
            catch (BadLocationException badLocationException) {
                MTJCorePlugin.log((int)4, (String)badLocationException.getMessage(), (Throwable)badLocationException);
            }
        }
    }

    public Map<String, StackTraceEntry> getCachedTrace() {
        return this.cachedTrace;
    }

    public IConsole getConsole() {
        return this.console;
    }

    public void dispose() {
        this.console = null;
    }
}

