/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.utils;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private static ExceptionHandler instance = new ExceptionHandler();

    public static void handle(CoreException coreException, Shell shell, String string, String string2) {
        instance.perform(coreException, shell, string, string2);
    }

    public static void handle(CoreException coreException, String string, String string2) {
        ExceptionHandler.handle(coreException, MTJUIPlugin.getActiveWorkbenchShell(), string, string2);
    }

    public static void handle(InvocationTargetException invocationTargetException, Shell shell, String string, String string2) {
        instance.perform(invocationTargetException, shell, string, string2);
    }

    public static void handle(InvocationTargetException invocationTargetException, String string, String string2) {
        ExceptionHandler.handle(invocationTargetException, MTJUIPlugin.getActiveWorkbenchShell(), string, string2);
    }

    public static void log(Throwable throwable, String string) {
        MTJCorePlugin.log((int)4, (String)string, (Throwable)throwable);
    }

    private void displayMessageDialog(String string, Shell shell, String string2, String string3) {
        StringWriter stringWriter = new StringWriter();
        if (string3 != null) {
            stringWriter.write(string3);
            stringWriter.write("\n\n");
        }
        if (string == null || string.length() == 0) {
            stringWriter.write("See error log for more details.");
        } else {
            stringWriter.write(string);
        }
        MessageDialog.openError((Shell)shell, (String)string2, (String)stringWriter.toString());
    }

    protected void perform(CoreException coreException, Shell shell, String string, String string2) {
        MTJCorePlugin.log((int)4, (Throwable)coreException);
        IStatus iStatus = coreException.getStatus();
        if (iStatus != null) {
            ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
        } else {
            this.displayMessageDialog(coreException.getMessage(), shell, string, string2);
        }
    }

    protected void perform(InvocationTargetException invocationTargetException, Shell shell, String string, String string2) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof CoreException) {
            this.perform((CoreException)throwable, shell, string, string2);
        } else {
            MTJCorePlugin.log((int)4, (Throwable)invocationTargetException);
            if (invocationTargetException.getMessage() != null && invocationTargetException.getMessage().length() > 0) {
                this.displayMessageDialog(invocationTargetException.getMessage(), shell, string, string2);
            } else {
                this.displayMessageDialog(throwable.getMessage(), shell, string, string2);
            }
        }
    }
}

