/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editors.jad.form.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.internal.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.ui.internal.utils.ManifestPreferenceStore;
import org.eclipse.mtj.ui.internal.utils.MidletSelectionDialogCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JADPushRegistryEditorPage
extends AbstractJADEditorPage {
    public static final String ID = "pushregistry";
    public static final String PUSH_REGISTRY_PREFIX = "MIDlet-Push-";
    private static final String PROP_CLASS = "class";
    private static final String PROP_CONNSTR = "connection string";
    private static final String PROP_SENDER = "allowed sender";
    private static final String[] PROPERTIES = new String[]{"connection string", "class", "allowed sender"};
    private static final List<String> PROPERTY_LIST = Arrays.asList(PROPERTIES);
    private Button addButton;
    private ArrayList<PushRegEntry> pushRegEntries = new ArrayList();
    private Button removeButton;
    private int storedEntriesCount;
    private TableViewer tableViewer;

    public JADPushRegistryEditorPage() {
        super(ID, MTJUIMessages.JADPushRegistryEditorPage_title);
    }

    public JADPushRegistryEditorPage(JADFormEditor jADFormEditor, String string) {
        super(jADFormEditor, ID, string);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
        int n = this.pushRegEntries.size();
        int n2 = 0;
        while (n2 < n) {
            PushRegEntry pushRegEntry = this.pushRegEntries.get(n2);
            manifestPreferenceStore.setValue(PUSH_REGISTRY_PREFIX + (n2 + 1), pushRegEntry.toString());
            ++n2;
        }
        while (n2 < this.storedEntriesCount) {
            manifestPreferenceStore.setToDefault(PUSH_REGISTRY_PREFIX + (n2 + 1));
            ++n2;
        }
        this.storedEntriesCount = n;
        this.setDirty(false);
    }

    public void editorInputChanged() {
        this.loadPushRegistryEntries();
    }

    public String getTitle() {
        return MTJUIMessages.JADPushRegistryEditorPage_title;
    }

    public boolean isManagingProperty(String string) {
        boolean bl = string.startsWith(PUSH_REGISTRY_PREFIX);
        if (bl) {
            String string2 = string.substring(PUSH_REGISTRY_PREFIX.length());
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    private void addItem() {
        PushRegEntry pushRegEntry = new PushRegEntry(MTJUIMessages.JADPushRegistryEditorPage_new_pushReg, "", "*");
        this.pushRegEntries.add(pushRegEntry);
        this.tableViewer.refresh();
        this.setDirty(true);
    }

    private void createButtons(FormToolkit formToolkit, Composite composite) {
        Composite composite2 = formToolkit.createComposite(composite);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        composite2.setLayout((Layout)fillLayout);
        this.addButton = formToolkit.createButton(composite2, MTJUIMessages.JADPushRegistryEditorPage_add_btn_label, 8);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JADPushRegistryEditorPage.this.addItem();
            }
        });
        formToolkit.createLabel(composite2, "");
        this.removeButton = formToolkit.createButton(composite2, MTJUIMessages.JADPushRegistryEditorPage_remove_btn_label, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JADPushRegistryEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(FormToolkit formToolkit, Composite composite) {
        String[] stringArray = new String[]{MTJUIMessages.JADPushRegistryEditorPage_connection_column, MTJUIMessages.JADPushRegistryEditorPage_class_column, MTJUIMessages.JADPushRegistryEditorPage_sender_column};
        int n = 68356;
        Table table = formToolkit.createTable(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = (TableItem)selectionEvent.item;
                JADPushRegistryEditorPage.this.removeButton.setEnabled(tableItem.getParent().getSelectionCount() > 0);
            }
        });
        this.tableViewer = new TableViewer(table);
        TableLayout tableLayout = new TableLayout();
        int n2 = 100 / stringArray.length;
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray2[n4];
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(string);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(n2));
            ++n4;
        }
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.tableViewer.setColumnProperties(PROPERTIES);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new MidletCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private void loadPushRegistryEntries() {
        this.pushRegEntries.clear();
        ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
        int n = 1;
        while (n < 1000) {
            String string = PUSH_REGISTRY_PREFIX + n;
            if (!manifestPreferenceStore.contains(string)) break;
            String string2 = manifestPreferenceStore.getString(string);
            this.pushRegEntries.add(new PushRegEntry(string2));
            ++n;
        }
        this.storedEntriesCount = this.pushRegEntries.size();
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    private void removeSelectedItems() {
        int[] nArray = this.tableViewer.getTable().getSelectionIndices();
        int n = nArray.length;
        while (n > 0) {
            int n2 = nArray[n - 1];
            this.pushRegEntries.remove(n2);
            --n;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = iManagedForm.getForm().getBody();
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0);
        new Label(composite, 0);
        this.createTableViewer(formToolkit, composite);
        this.createButtons(formToolkit, composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "eclipseme.ui.help_JADPushRegistryEditorPage");
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/jad_editor/pushregistry.html";
    }

    protected String getSectionDescription() {
        return MTJUIMessages.JADPushRegistryEditorPage_sectionDescription;
    }

    protected String getSectionTitle() {
        return MTJUIMessages.JADPushRegistryEditorPage_sectionTitle;
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)iEditorInput);
        }
        this.setDirty(false);
        this.loadPushRegistryEntries();
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            String string2 = null;
            if (object instanceof PushRegEntry) {
                PushRegEntry pushRegEntry = (PushRegEntry)object;
                int n = this.getFieldIndex(string);
                if (n != -1) {
                    string2 = pushRegEntry.fields[n];
                }
            }
            return string2;
        }

        public void modify(Object object, String string, Object object2) {
            if (object instanceof TableItem) {
                Object object3 = ((TableItem)object).getData();
                String string2 = (String)object2;
                if (object3 instanceof PushRegEntry) {
                    int n = this.getFieldIndex(string);
                    PushRegEntry pushRegEntry = (PushRegEntry)object3;
                    if (n != -1) {
                        this.updateField(pushRegEntry, string, n, string2);
                    }
                }
            }
        }

        private int getFieldIndex(String string) {
            return PROPERTY_LIST.indexOf(string);
        }

        private void updateField(PushRegEntry pushRegEntry, String string, int n, String string2) {
            if (!pushRegEntry.fields[n].equals(string2)) {
                pushRegEntry.fields[n] = string2;
                JADPushRegistryEditorPage.this.setDirty(true);
                JADPushRegistryEditorPage.this.tableViewer.update((Object)pushRegEntry, new String[]{string});
            }
        }
    }

    private class MidletCellEditor
    extends DialogCellEditor {
        MidletCellEditor(Composite composite) {
            super(composite);
        }

        protected Object openDialogBox(Control control) {
            String string = null;
            try {
                IType iType;
                Object[] objectArray;
                IJavaProject iJavaProject = JADPushRegistryEditorPage.this.getJavaProject();
                SelectionDialog selectionDialog = MidletSelectionDialogCreator.createMidletSelectionDialog(control.getShell(), (IRunnableContext)JADPushRegistryEditorPage.this.getSite().getPage().getWorkbenchWindow(), iJavaProject, false, MTJUIMessages.JADPushRegistryEditorPage_choose_MIDlet);
                if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()) != null && objectArray.length > 0 && (iType = (IType)objectArray[0]) != null) {
                    string = iType.getFullyQualifiedName();
                }
            }
            catch (JavaModelException javaModelException) {
                MTJCorePlugin.log((int)4, (String)"openDialogBox", (Throwable)javaModelException);
            }
            return string;
        }
    }

    static class PushRegEntry {
        public String[] fields = new String[3];

        PushRegEntry(String string) {
            String[] stringArray = string.split(",");
            int n = 0;
            while (n < 3) {
                this.fields[n] = n > stringArray.length ? "" : stringArray[n];
                ++n;
            }
        }

        PushRegEntry(String string, String string2, String string3) {
            this.fields[0] = string;
            this.fields[1] = string2;
            this.fields[2] = string3;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.fields != null) {
                int n = 0;
                while (n < this.fields.length) {
                    if (n != 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.fields[n]);
                    ++n;
                }
            }
            return stringBuffer.toString();
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return JADPushRegistryEditorPage.this.pushRegEntries.toArray(new Object[JADPushRegistryEditorPage.this.pushRegEntries.size()]);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            return ((PushRegEntry)object).fields[n];
        }
    }
}

