/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.context;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.IBaseModel;
import org.eclipse.mtj.core.model.IModelChangeProvider;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.IModelUndoManager;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.context.IInputContextListener;
import org.eclipse.mtj.internal.ui.editor.context.InputContext;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public abstract class InputContextManager
implements IResourceChangeListener {
    private MTJFormEditor editor;
    private Hashtable<IEditorInput, Object> inputContexts;
    private ArrayList<IInputContextListener> listeners;
    private ArrayList<IFile> monitoredFiles;
    private IModelUndoManager undoManager;

    public InputContextManager(MTJFormEditor mTJFormEditor) {
        this.editor = mTJFormEditor;
        this.inputContexts = new Hashtable();
        this.listeners = new ArrayList();
        MTJUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void addInputContextListener(IInputContextListener iInputContextListener) {
        if (!this.listeners.contains(iInputContextListener)) {
            this.listeners.add(iInputContextListener);
        }
    }

    public void dispose() {
        MTJUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        Enumeration<Object> enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext inputContext = (InputContext)enumeration.nextElement();
            this.unhookUndo(inputContext);
            inputContext.dispose();
        }
        this.inputContexts.clear();
        this.undoManager = null;
    }

    public InputContext findContext(IResource iResource) {
        Enumeration<Object> enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext inputContext = (InputContext)enumeration.nextElement();
            if (!inputContext.matches(iResource)) continue;
            return inputContext;
        }
        return null;
    }

    public InputContext findContext(String string) {
        Enumeration<Object> enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext inputContext = (InputContext)enumeration.nextElement();
            if (!inputContext.getId().equals(string)) continue;
            return inputContext;
        }
        return null;
    }

    public abstract IBaseModel getAggregateModel();

    public IProject getCommonProject() {
        Enumeration<Object> enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext inputContext = (InputContext)enumeration.nextElement();
            IEditorInput iEditorInput = inputContext.getInput();
            if (!(iEditorInput instanceof IFileEditorInput)) continue;
            return ((IFileEditorInput)iEditorInput).getFile().getProject();
        }
        return null;
    }

    public InputContext getContext(IEditorInput iEditorInput) {
        return (InputContext)this.inputContexts.get(iEditorInput);
    }

    public InputContext[] getInvalidContexts() {
        ArrayList<InputContext> arrayList = new ArrayList<InputContext>();
        Enumeration<Object> enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext inputContext = (InputContext)enumeration.nextElement();
            if (inputContext.isModelCorrect()) continue;
            arrayList.add(inputContext);
        }
        return arrayList.toArray(new InputContext[arrayList.size()]);
    }

    public InputContext getPrimaryContext() {
        Enumeration<Object> enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext inputContext = (InputContext)enumeration.nextElement();
            if (!inputContext.isPrimary()) continue;
            return inputContext;
        }
        return null;
    }

    public IModelUndoManager getUndoManager() {
        return this.undoManager;
    }

    public boolean hasContext(String string) {
        return this.findContext(string) != null;
    }

    public boolean isDirty() {
        Enumeration<Object> enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext inputContext = (InputContext)enumeration.nextElement();
            if (!inputContext.mustSave()) continue;
            return true;
        }
        return false;
    }

    public void monitorFile(IFile iFile) {
        if (this.monitoredFiles == null) {
            this.monitoredFiles = new ArrayList();
        }
        this.monitoredFiles.add(iFile);
    }

    public void putContext(IEditorInput iEditorInput, InputContext inputContext) {
        this.inputContexts.put(iEditorInput, inputContext);
        this.fireContextChange(inputContext, true);
    }

    public void redo() {
        if (this.undoManager != null && this.undoManager.isRedoable()) {
            this.undoManager.redo();
        }
    }

    public void removeInputContextListener(IInputContextListener iInputContextListener) {
        this.listeners.remove(iInputContextListener);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        try {
            iResourceDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta iResourceDelta) {
                    int n = iResourceDelta.getKind();
                    IResource iResource = iResourceDelta.getResource();
                    if (iResource instanceof IFile) {
                        if (n == 1) {
                            InputContextManager.this.asyncStructureChanged((IFile)iResource, true);
                        } else if (n == 2) {
                            InputContextManager.this.asyncStructureChanged((IFile)iResource, false);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)4, (Throwable)coreException);
        }
    }

    public void save(IProgressMonitor iProgressMonitor) {
        Enumeration<Object> enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext inputContext = (InputContext)enumeration.nextElement();
            if (!inputContext.mustSave()) continue;
            inputContext.doSave(iProgressMonitor);
        }
    }

    public void saveAs(IProgressMonitor iProgressMonitor, String string) throws Exception {
        InputContext inputContext = this.findContext(string);
        if (inputContext == null) {
            throw new Exception(MTJUIMessages.InputContextManager_saveAsInputContextNull);
        }
        IEditorInput iEditorInput = this.editor.getEditorInput();
        inputContext.doSaveAs(iProgressMonitor);
        IEditorInput iEditorInput2 = inputContext.getInput();
        this.updateInputContext(iEditorInput2, iEditorInput);
    }

    public void setUndoManager(IModelUndoManager iModelUndoManager) {
        this.undoManager = iModelUndoManager;
    }

    public void undo() {
        if (this.undoManager != null && this.undoManager.isUndoable()) {
            this.undoManager.undo();
        }
    }

    private void asyncStructureChanged(final IFile iFile, final boolean bl) {
        if (this.editor == null || this.editor.getEditorSite() == null) {
            return;
        }
        Shell shell = this.editor.getEditorSite().getShell();
        Display display = shell != null ? shell.getDisplay() : Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                InputContextManager.this.structureChanged(iFile, bl);
            }
        });
    }

    private void hookUndo(InputContext inputContext) {
        if (this.undoManager == null) {
            return;
        }
        IBaseModel iBaseModel = inputContext.getModel();
        if (iBaseModel instanceof IModelChangeProvider) {
            this.undoManager.connect((IModelChangeProvider)iBaseModel);
        }
    }

    private void removeContext(IFile iFile) {
        Enumeration<Object> enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            IFileEditorInput iFileEditorInput;
            InputContext inputContext = (InputContext)enumeration.nextElement();
            IEditorInput iEditorInput = inputContext.getInput();
            if (!(iEditorInput instanceof IFileEditorInput) || !iFile.equals((Object)(iFileEditorInput = (IFileEditorInput)iEditorInput).getFile())) continue;
            this.inputContexts.remove(iEditorInput);
            this.fireContextChange(inputContext, false);
            return;
        }
    }

    private void structureChanged(IFile iFile, boolean bl) {
        if (this.monitoredFiles == null) {
            return;
        }
        int n = 0;
        while (n < this.monitoredFiles.size()) {
            IFile iFile2 = this.monitoredFiles.get(n);
            if (iFile2.equals((Object)iFile)) {
                if (bl) {
                    this.fireStructureChange(iFile, true);
                } else {
                    this.fireStructureChange(iFile, false);
                    this.removeContext(iFile);
                }
            }
            ++n;
        }
    }

    private void unhookUndo(InputContext inputContext) {
        if (this.undoManager == null) {
            return;
        }
        IBaseModel iBaseModel = inputContext.getModel();
        if (iBaseModel instanceof IModelChangeProvider) {
            this.undoManager.disconnect((IModelChangeProvider)iBaseModel);
        }
    }

    private void updateInputContext(IEditorInput iEditorInput, IEditorInput iEditorInput2) throws Exception {
        Object object = null;
        if (!this.inputContexts.containsKey(iEditorInput2)) {
            throw new Exception(MTJUIMessages.InputContextManager_updateInputContextNull);
        }
        object = this.inputContexts.remove(iEditorInput2);
        this.inputContexts.put(iEditorInput, object);
    }

    protected void fireContextChange(InputContext inputContext, boolean bl) {
        int n = 0;
        while (n < this.listeners.size()) {
            IInputContextListener iInputContextListener = this.listeners.get(n);
            if (bl) {
                iInputContextListener.contextAdded(inputContext);
            } else {
                iInputContextListener.contextRemoved(inputContext);
            }
            ++n;
        }
        if (bl) {
            this.hookUndo(inputContext);
        } else {
            this.unhookUndo(inputContext);
        }
    }

    protected void fireStructureChange(IFile iFile, boolean bl) {
        int n = 0;
        while (n < this.listeners.size()) {
            IInputContextListener iInputContextListener = this.listeners.get(n);
            if (bl) {
                iInputContextListener.monitoredFileAdded(iFile);
            } else {
                iInputContextListener.monitoredFileRemoved(iFile);
            }
            ++n;
        }
    }
}

