/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.ui.editor.IMTJDragParticipant;
import org.eclipse.mtj.internal.ui.editor.IMTJDropParticipant;
import org.eclipse.mtj.internal.ui.editor.MTJDragAdapter;
import org.eclipse.mtj.internal.ui.editor.MTJDropAdapter;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editor.MTJSection;
import org.eclipse.mtj.internal.ui.editor.ModelDataTransfer;
import org.eclipse.mtj.internal.ui.parts.StructuredViewerPart;
import org.eclipse.mtj.ui.internal.editors.FormLayoutFactory;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerSection
extends MTJSection
implements IMTJDragParticipant,
IMTJDropParticipant {
    private boolean fDoSelection;
    private MTJDragAdapter fDragAdapter;
    private MTJDropAdapter fDropAdapter;
    protected StructuredViewerPart fViewerPart;

    public StructuredViewerSection(MTJFormPage mTJFormPage, Composite composite, int n, boolean bl, String[] stringArray) {
        super(mTJFormPage, composite, n, bl);
        this.fViewerPart = this.createViewerPart(stringArray);
        this.fViewerPart.setMinimumSize(50, 50);
        FormToolkit formToolkit = mTJFormPage.getManagedForm().getToolkit();
        this.createClient(this.getSection(), formToolkit);
        this.fDoSelection = true;
    }

    public StructuredViewerSection(MTJFormPage mTJFormPage, Composite composite, int n, String[] stringArray) {
        this(mTJFormPage, composite, n, true, stringArray);
    }

    public boolean canDragCopy(Object[] objectArray) {
        return false;
    }

    public boolean canDragLink(Object[] objectArray) {
        return false;
    }

    public boolean canDragMove(Object[] objectArray) {
        return false;
    }

    public boolean canDropCopy(Object object, Object[] objectArray, int n) {
        return false;
    }

    public boolean canDropLink(Object object, Object[] objectArray, int n) {
        return false;
    }

    public boolean canDropMove(Object object, Object[] objectArray, int n) {
        return false;
    }

    public boolean canPaste(Clipboard clipboard) {
        ISelection iSelection = this.getViewerSelection();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (iStructuredSelection.size() > 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        ModelDataTransfer modelDataTransfer = ModelDataTransfer.getInstance();
        Object[] objectArray = (Object[])clipboard.getContents((Transfer)modelDataTransfer);
        if (objectArray != null && objectArray.length > 0) {
            return this.canPaste(object, objectArray);
        }
        return false;
    }

    public void doDragRemove(Object[] objectArray) {
    }

    public void doDropCopy(Object object, Object[] objectArray, int n) {
    }

    public void doDropLink(Object object, Object[] objectArray, int n) {
    }

    public void doDropMove(Object object, Object[] objectArray, int n) {
    }

    public StructuredViewerPart getStructuredViewerPart() {
        return this.fViewerPart;
    }

    public int getSupportedDNDOperations() {
        return 2;
    }

    public void setFocus() {
        this.fViewerPart.getControl().setFocus();
    }

    protected void buttonSelected(int n) {
    }

    protected boolean canPaste(Object object, Object[] objectArray) {
        return false;
    }

    protected boolean canSelect() {
        return this.fDoSelection;
    }

    protected Composite createClientContainer(Composite composite, int n, FormToolkit formToolkit) {
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, n));
        return composite2;
    }

    protected abstract StructuredViewerPart createViewerPart(String[] var1);

    protected void createViewerPartControl(Composite composite, int n, int n2, FormToolkit formToolkit) {
        this.fViewerPart.createControl(composite, n, n2, formToolkit);
        MenuManager menuManager = new MenuManager();
        IMenuListener iMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                StructuredViewerSection.this.fillContextMenu(iMenuManager);
            }
        };
        menuManager.addMenuListener(iMenuListener);
        menuManager.setRemoveAllWhenShown(true);
        Control control = this.fViewerPart.getControl();
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        if (this.isDragAndDropEnabled()) {
            this.initializeDragAndDrop();
        } else {
            this.fDragAdapter = null;
            this.fDropAdapter = null;
        }
    }

    protected void doPaste() {
        ModelDataTransfer modelDataTransfer;
        ISelection iSelection = this.getViewerSelection();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (iStructuredSelection.size() > 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        Clipboard clipboard = this.getPage().getMTJEditor().getClipboard();
        Object[] objectArray = (Object[])clipboard.getContents((Transfer)(modelDataTransfer = ModelDataTransfer.getInstance()));
        if (objectArray != null) {
            this.doPaste(object, objectArray);
        }
    }

    protected void doPaste(Object object, Object[] objectArray) {
    }

    protected void doSelect(boolean bl) {
        this.fDoSelection = bl;
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
    }

    protected int getArrayIndex(Object[] objectArray, Object object) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n].equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected Object[] getDragSourceObjects() {
        if (!this.isDragAndDropEnabled()) {
            return null;
        }
        if (this.fDragAdapter == null) {
            return null;
        }
        return this.fDragAdapter.getSourceObjects();
    }

    protected Transfer[] getDragTransfers() {
        return new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()};
    }

    protected Transfer[] getDropTransfers() {
        return this.getDragTransfers();
    }

    protected int getNewSelectionIndex(int n, int n2) {
        if (n == n2 - 1) {
            return n - 1;
        }
        return n + 1;
    }

    protected ISelection getViewerSelection() {
        return this.fViewerPart.getViewer().getSelection();
    }

    protected void initializeDragAndDrop() {
        if (!this.isEditable()) {
            return;
        }
        if (this.fViewerPart == null) {
            return;
        }
        StructuredViewer structuredViewer = this.fViewerPart.getViewer();
        if (structuredViewer == null) {
            return;
        }
        this.fDragAdapter = new MTJDragAdapter(this);
        this.fDropAdapter = new MTJDropAdapter((Viewer)structuredViewer, this, this.fDragAdapter);
        int n = this.getSupportedDNDOperations();
        structuredViewer.addDragSupport(n, this.getDragTransfers(), (DragSourceListener)this.fDragAdapter);
        int n2 = n | 0x10;
        structuredViewer.addDropSupport(n2, this.getDropTransfers(), (DropTargetListener)this.fDropAdapter);
    }

    protected boolean isDragAndDropEnabled() {
        return false;
    }
}

