/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.console;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.mtj.core.console.BuildConsoleProxy;
import org.eclipse.mtj.core.console.IBuildConsoleProxy;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class BuilderConsole
extends IOConsole
implements IBuildConsoleProxy {
    private static final String CONSOLE_TYPE = "MTJBuildConsole";
    private IConsoleColorProvider colorProvider = new ConsoleColorProvider();
    private Map<String, Color> colors;
    private Map<String, PrintWriter> writers;

    public BuilderConsole() {
        super(MTJUIMessages.BuilderConsole_name, CONSOLE_TYPE, null, true);
        BuildConsoleProxy.instance.setProxy((IBuildConsoleProxy)this);
        this.writers = new HashMap<String, PrintWriter>(3);
        this.colors = new HashMap<String, Color>(3);
        this.colors.put("error", this.colorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM"));
        this.colors.put("output", this.colorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM"));
        this.colors.put("trace", new Color((Device)Display.getDefault(), 0, 128, 128));
    }

    public PrintWriter getConsoleWriter(String string) {
        PrintWriter printWriter = this.writers.get(string);
        if (printWriter == null) {
            final Color color = this.getColor(string);
            final IOConsoleOutputStream iOConsoleOutputStream = this.newOutputStream();
            printWriter = new PrintWriter((OutputStream)iOConsoleOutputStream);
            this.writers.put(string, printWriter);
            if (color != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        iOConsoleOutputStream.setColor(color);
                    }
                });
            }
        }
        return printWriter;
    }

    private Color getColor(String string) {
        return this.colors.get(string);
    }
}

