/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editors.jad.form.pages;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.internal.editors.jad.form.pages.MidletType;
import org.eclipse.mtj.ui.internal.forms.parts.FormEntry;
import org.eclipse.mtj.ui.internal.forms.parts.IFormEntryListener;
import org.eclipse.mtj.ui.internal.utils.ImageSelectionDialogCreator;
import org.eclipse.mtj.ui.internal.utils.MidletSelectionDialogCreator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MidletTypeDetailsPage
implements IDetailsPage {
    private FormEntry classEntry;
    private FormEntry iconEntry;
    private MidletType input;
    private IJavaProject javaProject;
    private IManagedForm mform;
    private FormEntry nameEntry;

    public MidletTypeDetailsPage(IJavaProject iJavaProject) {
        this.javaProject = iJavaProject;
    }

    public void commit(boolean bl) {
    }

    public void createContents(Composite composite) {
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.topMargin = 5;
        tableWrapLayout.leftMargin = 5;
        tableWrapLayout.rightMargin = 2;
        tableWrapLayout.bottomMargin = 2;
        composite.setLayout((Layout)tableWrapLayout);
        FormToolkit formToolkit = this.mform.getToolkit();
        Section section = formToolkit.createSection(composite, 384);
        section.marginWidth = 10;
        section.setText(MTJUIMessages.MidletTypeDetailsPage_midlet_details_section_title);
        section.setDescription(MTJUIMessages.MidletTypeDetailsPage_midlet_details_section_description);
        TableWrapData tableWrapData = new TableWrapData(128, 16);
        tableWrapData.grabHorizontal = true;
        section.setLayoutData((Object)tableWrapData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = formToolkit.getBorderStyle() == 2048 ? 0 : 2;
        gridLayout.marginWidth = gridLayout.marginHeight;
        gridLayout.numColumns = 3;
        Composite composite2 = formToolkit.createComposite((Composite)section);
        this.createSpacer(composite2, formToolkit, 3);
        composite2.setLayout((Layout)gridLayout);
        this.createNameEntry(composite2, formToolkit, new MIDletsFormEntryAdapter());
        this.createIconEntry(composite2, formToolkit, new MIDletsFormEntryAdapter());
        this.createClassEntry(composite2, formToolkit, new MIDletsFormEntryAdapter());
        formToolkit.paintBordersFor(composite2);
        section.setClient((Control)composite2);
    }

    public void dispose() {
    }

    public void initialize(IManagedForm iManagedForm) {
        this.mform = iManagedForm;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.update();
    }

    public void selectionChanged(IFormPart iFormPart, ISelection iSelection) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        this.input = iStructuredSelection.size() == 1 ? (MidletType)iStructuredSelection.getFirstElement() : null;
        this.update();
    }

    public void setFocus() {
        this.nameEntry.getText().setFocus();
    }

    public boolean setFormInput(Object object) {
        return false;
    }

    private void createClassEntry(Composite composite, FormToolkit formToolkit, IFormEntryListener iFormEntryListener) {
        this.classEntry = new FormEntry(composite, formToolkit, MTJUIMessages.MidletTypeDetailsPage_midlet_class_label_text, MTJUIMessages.MidletTypeDetailsPage_brose_btn_label_text, false);
        this.classEntry.setFormEntryListener(iFormEntryListener);
        this.classEntry.setEditable(true);
    }

    private void createIconEntry(Composite composite, FormToolkit formToolkit, IFormEntryListener iFormEntryListener) {
        this.iconEntry = new FormEntry(composite, formToolkit, MTJUIMessages.MidletTypeDetailsPage_midlet_icon_label_text, MTJUIMessages.MidletTypeDetailsPage_brose_btn_label_text, false);
        this.iconEntry.setFormEntryListener(iFormEntryListener);
        this.iconEntry.setEditable(true);
    }

    private void createNameEntry(Composite composite, FormToolkit formToolkit, IFormEntryListener iFormEntryListener) {
        this.nameEntry = new FormEntry(composite, formToolkit, MTJUIMessages.MidletTypeDetailsPage_midlet_name_label_text, 4);
        this.nameEntry.setFormEntryListener(iFormEntryListener);
        this.nameEntry.setEditable(true);
    }

    private void createSpacer(Composite composite, FormToolkit formToolkit, int n) {
        Label label = formToolkit.createLabel(composite, "");
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    private void update() {
        this.nameEntry.setValue(this.input != null && this.input.getMidletName() != null ? this.input.getMidletName() : "", true);
        this.iconEntry.setValue(this.input != null && this.input.getIcon() != null ? this.input.getIcon() : "", true);
        this.classEntry.setValue(this.input != null && this.input.getClassName() != null ? this.input.getClassName() : "", true);
    }

    class MIDletsFormEntryAdapter
    implements IFormEntryListener {
        MIDletsFormEntryAdapter() {
        }

        public void browseButtonSelected(FormEntry formEntry) {
            if (formEntry == MidletTypeDetailsPage.this.classEntry) {
                try {
                    IType iType;
                    Object[] objectArray;
                    SelectionDialog selectionDialog = MidletSelectionDialogCreator.createMidletSelectionDialog(formEntry.getButton().getShell(), null, MidletTypeDetailsPage.this.javaProject, false);
                    if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()) != null && objectArray.length > 0 && (iType = (IType)objectArray[0]) != null) {
                        String string = iType.getFullyQualifiedName();
                        MidletTypeDetailsPage.this.classEntry.setValue(string);
                        MidletTypeDetailsPage.this.input.setClassName(string);
                    }
                }
                catch (JavaModelException javaModelException) {
                    MTJCorePlugin.log((int)4, (String)MTJUIMessages.MidletTypeDetailsPage_erro_browseButtonSelected_midlet, (Throwable)javaModelException);
                }
            } else if (formEntry == MidletTypeDetailsPage.this.iconEntry) {
                try {
                    IResource iResource;
                    Object[] objectArray;
                    SelectionDialog selectionDialog = ImageSelectionDialogCreator.createImageSelectionDialog(formEntry.getButton().getShell(), MidletTypeDetailsPage.this.javaProject);
                    if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()) != null && objectArray.length > 0 && (iResource = (IResource)objectArray[0]) != null) {
                        IClasspathEntry[] iClasspathEntryArray;
                        String string = "/";
                        IPath iPath = iResource.getProjectRelativePath();
                        IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = MidletTypeDetailsPage.this.javaProject.getJavaProject().getResolvedClasspath(true);
                        int n = iClasspathEntryArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPath iPath2;
                            IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
                            if (iClasspathEntry.getContentKind() == 1 && (iPath2 = iClasspathEntry.getPath().removeFirstSegments(1)).isPrefixOf(iPath)) {
                                iPath = iPath.removeFirstSegments(1);
                                break;
                            }
                            ++n2;
                        }
                        string = String.valueOf(string) + iPath.toString();
                        MidletTypeDetailsPage.this.iconEntry.setValue(string);
                        MidletTypeDetailsPage.this.input.setIcon(string);
                    }
                }
                catch (Throwable throwable) {
                    MTJCorePlugin.log((int)4, (String)MTJUIMessages.MidletTypeDetailsPage_error_browseButtonSelected_image, (Throwable)throwable);
                }
            }
        }

        public void focusGained(FormEntry formEntry) {
        }

        public void linkActivated(HyperlinkEvent hyperlinkEvent) {
        }

        public void linkEntered(HyperlinkEvent hyperlinkEvent) {
        }

        public void linkExited(HyperlinkEvent hyperlinkEvent) {
        }

        public void selectionChanged(FormEntry formEntry) {
        }

        public void textDirty(FormEntry formEntry) {
            this.textValueChanged(formEntry);
        }

        public void textValueChanged(FormEntry formEntry) {
            if (formEntry == MidletTypeDetailsPage.this.classEntry) {
                MidletTypeDetailsPage.this.input.setClassName(formEntry.getValue());
            } else if (formEntry == MidletTypeDetailsPage.this.iconEntry) {
                MidletTypeDetailsPage.this.input.setIcon(formEntry.getValue());
            } else if (formEntry == MidletTypeDetailsPage.this.nameEntry) {
                MidletTypeDetailsPage.this.input.setName(formEntry.getValue(), true);
                MidletTypeDetailsPage.this.input.setMidletName(formEntry.getValue());
            }
        }
    }
}

