/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.mtj.internal.core.text.IReconcilingParticipant;

public class ReconcilingStrategy
implements IReconcilingStrategy {
    private IDocument fDocument;
    private ArrayList<IReconcilingParticipant> fParticipants = new ArrayList();

    public void addParticipant(IReconcilingParticipant iReconcilingParticipant) {
        this.fParticipants.add(iReconcilingParticipant);
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion iRegion) {
        if (this.fDocument != null) {
            this.notifyParticipants();
        }
    }

    public void reconcile(IRegion iRegion) {
        if (this.fDocument != null) {
            this.notifyParticipants();
        }
    }

    public void removeParticipant(IReconcilingParticipant iReconcilingParticipant) {
        this.fParticipants.remove(iReconcilingParticipant);
    }

    public void setDocument(IDocument iDocument) {
        this.fDocument = iDocument;
    }

    private synchronized void notifyParticipants() {
        int n = 0;
        while (n < this.fParticipants.size()) {
            this.fParticipants.get(n).reconciled(this.fDocument);
            ++n;
        }
    }
}

