/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class MtjPerspectiveFactory
implements IPerspectiveFactory {
    private IPageLayout layout;

    public void createInitialLayout(IPageLayout iPageLayout) {
        this.layout = iPageLayout;
        this.addViews();
        this.addActionSets();
        this.addNewWizardShortcuts();
        this.addPerspectiveShortcuts();
        this.addViewShortcuts();
    }

    private void addPerspectiveShortcuts() {
        this.layout.addPerspectiveShortcut("org.eclipse.jdt.ui.JavaPerspective");
        this.layout.addPerspectiveShortcut("org.eclipse.debug.ui.DebugPerspective");
    }

    private void addViews() {
        IFolderLayout iFolderLayout = this.layout.createFolder("topLeft", 1, 0.25f, this.layout.getEditorArea());
        iFolderLayout.addView("org.eclipse.jdt.ui.PackageExplorer");
        iFolderLayout.addView("org.eclipse.ui.views.ResourceNavigator");
        iFolderLayout.addView("org.eclipse.jdt.ui.TypeHierarchy");
        IFolderLayout iFolderLayout2 = this.layout.createFolder("bottomRight", 4, 0.75f, this.layout.getEditorArea());
        iFolderLayout2.addView("org.eclipse.ui.views.ProblemView");
        iFolderLayout2.addView("org.eclipse.jdt.ui.JavadocView");
        iFolderLayout2.addView("org.eclipse.ui.views.TaskList");
        this.layout.addView("org.eclipse.ui.views.ContentOutline", 2, 0.75f, this.layout.getEditorArea());
    }

    private void addActionSets() {
        this.layout.addActionSet("org.eclipse.debug.ui.launchActionSet");
        this.layout.addActionSet("org.eclipse.jdt.ui.JavaActionSet");
        this.layout.addActionSet("org.eclipse.jdt.ui.JavaElementCreationActionSet");
        this.layout.addActionSet("org.eclipse.ui.NavigateActionSet");
    }

    private void addNewWizardShortcuts() {
        this.layout.addNewWizardShortcut("org.eclipse.mtj.ui.wizards.NewJ2MEProjectWizard");
        this.layout.addNewWizardShortcut("org.eclipse.mtj.ui.wizards.NewMidletWizard");
        this.layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewPackageCreationWizard");
        this.layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewClassCreationWizard");
        this.layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewInterfaceCreationWizard");
        this.layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewSourceFolderCreationWizard");
        this.layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewSnippetFileCreationWizard");
        this.layout.addNewWizardShortcut("org.eclipse.jdt.ui.wizards.NewJavaWorkingSetWizard");
        this.layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        this.layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
        this.layout.addNewWizardShortcut("org.eclipse.ui.editors.wizards.UntitledTextFileWizard");
        this.layout.addNewWizardShortcut("org.eclipse.mtj.j2meunit.wizards.NewJ2METestCaseWizard");
        this.layout.addNewWizardShortcut("org.eclipse.mtj.j2meunit.internal.ui.wizards.NewJ2METestSuiteCreationWizard");
    }

    private void addViewShortcuts() {
        this.layout.addShowViewShortcut("org.eclipse.pde.runtime.LogView");
        this.layout.addShowViewShortcut("org.eclipse.jdt.ui.PackageExplorer");
        this.layout.addShowViewShortcut("org.eclipse.jdt.ui.TypeHierarchy");
        this.layout.addShowViewShortcut("org.eclipse.jdt.ui.SourceView");
        this.layout.addShowViewShortcut("org.eclipse.jdt.ui.JavadocView");
        this.layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
        this.layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        this.layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        this.layout.addShowViewShortcut("org.eclipse.ui.views.ResourceNavigator");
        this.layout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        this.layout.addShowViewShortcut("org.eclipse.ui.views.ProgressView");
    }
}

