/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editors.jad.form.pages;

import java.util.ArrayList;
import org.eclipse.mtj.ui.editors.models.IModel;
import org.eclipse.mtj.ui.editors.models.IModelListener;
import org.eclipse.mtj.ui.internal.forms.blocks.NamedObject;

public class MidletsModel
implements IModel {
    private ArrayList<IModelListener> modelListeners = new ArrayList();
    private ArrayList<NamedObject> objects = new ArrayList();

    public MidletsModel(NamedObject[] namedObjectArray) {
        this.initialize(namedObjectArray);
    }

    public void add(NamedObject[] namedObjectArray, boolean bl) {
        NamedObject[] namedObjectArray2 = namedObjectArray;
        int n = namedObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            NamedObject namedObject = namedObjectArray2[n2];
            this.objects.add(namedObject);
            namedObject.setModel(this);
            ++n2;
        }
        if (bl) {
            this.fireModelChanged(namedObjectArray, "__added", "");
        }
    }

    public void reorder(NamedObject namedObject, Direction direction) {
        int n = 0;
        while (n < this.objects.size()) {
            NamedObject namedObject2 = this.objects.get(n);
            if (namedObject2 == namedObject) {
                if (direction == Direction.DOWN && n == this.objects.size() - 1 || direction == Direction.UP && n == 0) {
                    return;
                }
                this.objects.remove(n);
                this.objects.add(n += direction.getValue(), namedObject);
                this.fireModelChanged(new Object[]{namedObject}, "__added", "");
                break;
            }
            ++n;
        }
    }

    public void addModelListener(IModelListener iModelListener) {
        if (!this.modelListeners.contains(iModelListener)) {
            this.modelListeners.add(iModelListener);
        }
    }

    public void clear() {
        this.objects.clear();
    }

    public void fireModelChanged(Object[] objectArray, String string, String string2) {
        int n = 0;
        while (n < this.modelListeners.size()) {
            this.modelListeners.get(n).modelChanged(objectArray, string, string2);
            ++n;
        }
    }

    public Object[] getContents() {
        return this.objects.toArray();
    }

    public void remove(NamedObject[] namedObjectArray, boolean bl) {
        NamedObject[] namedObjectArray2 = namedObjectArray;
        int n = namedObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            NamedObject namedObject = namedObjectArray2[n2];
            this.objects.remove(namedObject);
            namedObject.setModel(null);
            ++n2;
        }
        if (bl) {
            this.fireModelChanged(namedObjectArray, "__removed", "");
        }
    }

    public void removeModelListener(IModelListener iModelListener) {
        this.modelListeners.remove(iModelListener);
    }

    private void initialize(NamedObject[] namedObjectArray) {
        if (namedObjectArray != null) {
            this.add(namedObjectArray, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP(-1),
        DOWN(1);

        int value;

        private Direction(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

