/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.viewers;

import java.util.Comparator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.ui.viewers.TableColumnInfo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewerConfiguration {
    private static final String SORT_COLUMN = "sortColumn";
    private static final String SORT_DIRECTION = "sortDirection";
    private IDialogSettings dialogSettings;
    private TableColumnInfo[] columnInfo;
    private int defaultSortColumn;
    private int defaultTableWidth;
    private String[] columnWidthKeys;
    private Image downArrow;
    private Image upArrow;

    public TableViewerConfiguration(IDialogSettings iDialogSettings, int n, TableColumnInfo[] tableColumnInfoArray, int n2) {
        this.dialogSettings = iDialogSettings;
        this.columnInfo = tableColumnInfoArray;
        this.defaultSortColumn = n2;
        this.defaultTableWidth = n;
        this.columnWidthKeys = new String[tableColumnInfoArray.length];
        int n3 = 0;
        while (n3 < tableColumnInfoArray.length) {
            TableColumnInfo tableColumnInfo = tableColumnInfoArray[n3];
            this.columnWidthKeys[n3] = "columnWidth_" + tableColumnInfo.getName();
            ++n3;
        }
        this.downArrow = MTJUIPluginImages.DESC_DOWN_ARROW_OBJ.createImage();
        this.upArrow = MTJUIPluginImages.DESC_UP_ARROW_OBJ.createImage();
    }

    public void configure(TableViewer tableViewer) {
        TableViewerInfoSorter tableViewerInfoSorter = new TableViewerInfoSorter();
        tableViewerInfoSorter.setComparator(this.getComparator(tableViewer));
        tableViewer.setSorter((ViewerSorter)tableViewerInfoSorter);
        Table table = tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        int n = 0;
        while (n < this.columnInfo.length) {
            TableColumnInfo tableColumnInfo = this.columnInfo[n];
            TableColumn tableColumn = new TableColumn(table, tableColumnInfo.getAlignment());
            tableColumn.setText(tableColumnInfo.getName());
            int n2 = this.getColumnWidth(n);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(n2));
            TableColumnListener tableColumnListener = new TableColumnListener(tableViewer, n);
            tableColumn.addControlListener((ControlListener)tableColumnListener);
            tableColumn.addSelectionListener((SelectionListener)tableColumnListener);
            ++n;
        }
        this.updateSortImages(tableViewer);
    }

    public TableColumnInfo[] getColumnInfo() {
        return this.columnInfo;
    }

    private int getColumnWidth(int n) {
        int n2 = 0;
        String string = this.columnWidthKeys[n];
        if (this.dialogSettings.get(string) != null) {
            n2 = this.dialogSettings.getInt(string);
        } else {
            float f = this.columnInfo[n].getDefaultWidthPercent() / 100.0f;
            n2 = (int)((float)this.defaultTableWidth * f);
        }
        return n2;
    }

    private Comparator<Object> getComparator(TableViewer tableViewer) {
        TableColumnInfo tableColumnInfo = this.columnInfo[this.getSortColumn()];
        Comparator<Object> comparator = tableColumnInfo.getComparator();
        if (comparator == null) {
            comparator = new LabelProviderComparator(tableViewer, this.getSortColumn());
        }
        if (!this.getSortDirectionAscending()) {
            comparator = new ReversingComparator(comparator);
        }
        return comparator;
    }

    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    public int getSortColumn() {
        return this.dialogSettings.get(SORT_COLUMN) != null ? this.dialogSettings.getInt(SORT_COLUMN) : this.defaultSortColumn;
    }

    public boolean getSortDirectionAscending() {
        return this.dialogSettings.get(SORT_DIRECTION) != null ? this.dialogSettings.getBoolean(SORT_DIRECTION) : true;
    }

    public void setColumnInfo(TableColumnInfo[] tableColumnInfoArray) {
        this.columnInfo = tableColumnInfoArray;
    }

    private void setColumnWidth(int n, int n2) {
        String string = this.columnWidthKeys[n];
        this.dialogSettings.put(string, n2);
    }

    public void setDialogSettings(IDialogSettings iDialogSettings) {
        this.dialogSettings = iDialogSettings;
    }

    public void setSortColumn(int n) {
        this.dialogSettings.put(SORT_COLUMN, n);
    }

    public void setSortDirectionAscending(boolean bl) {
        this.dialogSettings.put(SORT_DIRECTION, bl);
    }

    private void updateSortImages(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        TableColumn[] tableColumnArray = table.getColumns();
        int n = 0;
        while (n < tableColumnArray.length) {
            Image image = null;
            if (n == this.getSortColumn()) {
                image = this.getSortDirectionAscending() ? this.downArrow : this.upArrow;
            }
            tableColumnArray[n].setImage(image);
            ++n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelProviderComparator
    implements Comparator<Object> {
        private TableViewer tableViewer;
        private int columnIndex;

        LabelProviderComparator(TableViewer tableViewer, int n) {
            this.tableViewer = tableViewer;
            this.columnIndex = n;
        }

        @Override
        public int compare(Object object, Object object2) {
            ITableLabelProvider iTableLabelProvider = (ITableLabelProvider)this.tableViewer.getLabelProvider();
            String string = this.getLabel(iTableLabelProvider, object);
            String string2 = this.getLabel(iTableLabelProvider, object2);
            return string.compareToIgnoreCase(string2);
        }

        private String getLabel(ITableLabelProvider iTableLabelProvider, Object object) {
            return iTableLabelProvider.getColumnText(object, this.columnIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReversingComparator
    implements Comparator<Object> {
        private Comparator<Object> baseComparator;

        ReversingComparator(Comparator<Object> comparator) {
            this.baseComparator = comparator;
        }

        @Override
        public int compare(Object object, Object object2) {
            return 0 - this.baseComparator.compare(object, object2);
        }
    }

    private class TableColumnListener
    implements ControlListener,
    SelectionListener {
        private TableViewer viewer;
        private int columnIndex;

        TableColumnListener(TableViewer tableViewer, int n) {
            this.viewer = tableViewer;
            this.columnIndex = n;
        }

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            TableColumn tableColumn = (TableColumn)controlEvent.widget;
            TableViewerConfiguration.this.setColumnWidth(this.columnIndex, tableColumn.getWidth());
        }

        private void updateViewerSorter() {
            ViewerSorter viewerSorter = this.viewer.getSorter();
            if (viewerSorter instanceof TableViewerInfoSorter) {
                TableViewerInfoSorter tableViewerInfoSorter = (TableViewerInfoSorter)viewerSorter;
                tableViewerInfoSorter.setComparator(TableViewerConfiguration.this.getComparator(this.viewer));
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = TableViewerConfiguration.this.getSortColumn();
            if (n == this.columnIndex) {
                TableViewerConfiguration.this.setSortDirectionAscending(!TableViewerConfiguration.this.getSortDirectionAscending());
            } else {
                TableViewerConfiguration.this.setSortColumn(this.columnIndex);
                TableViewerConfiguration.this.setSortDirectionAscending(true);
            }
            TableViewerConfiguration.this.updateSortImages(this.viewer);
            this.updateViewerSorter();
            this.viewer.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableViewerInfoSorter
    extends ViewerSorter {
        private Comparator<Object> comparator;

        public int compare(Viewer viewer, Object object, Object object2) {
            return this.comparator.compare(object, object2);
        }

        public void setComparator(Comparator<Object> comparator) {
            this.comparator = comparator;
        }
    }
}

