/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mtj.internal.ui.editor.FormEntryAdapter;
import org.eclipse.mtj.internal.ui.editor.IContextPart;
import org.eclipse.mtj.ui.internal.editors.FormLayoutFactory;
import org.eclipse.mtj.ui.internal.forms.parts.FormEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormFilteredTree
extends FilteredTree {
    private FormToolkit toolkit;
    private FormEntry fEntryFilter;

    public FormFilteredTree(Composite composite, int n, PatternFilter patternFilter) {
        super(composite, n, patternFilter);
    }

    protected void createControl(Composite composite, int n) {
        GridLayout gridLayout;
        this.toolkit = new FormToolkit(composite.getDisplay());
        GridLayout gridLayout2 = FormLayoutFactory.createClearGridLayout(false, 1);
        gridLayout2.verticalSpacing = 3;
        this.setLayout((Layout)gridLayout2);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (this.showFilterControls) {
            this.filterComposite = new Composite((Composite)this, 0);
            gridLayout = FormLayoutFactory.createClearGridLayout(false, 2);
            gridLayout.horizontalSpacing = 5;
            this.filterComposite.setLayout((Layout)gridLayout);
            this.filterComposite.setFont(composite.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.treeComposite = new Composite((Composite)this, 0);
        this.treeComposite.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        gridLayout = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)gridLayout);
        this.createTreeControl(this.treeComposite, n);
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    protected Text doCreateFilterText(Composite composite) {
        int n = 4 | this.toolkit.getBorderStyle();
        this.fEntryFilter = new FormEntry(composite, this.toolkit, null, n);
        this.toolkit.paintBordersFor(composite);
        this.setBackground(this.toolkit.getColors().getBackground());
        return this.fEntryFilter.getText();
    }

    protected TreeViewer doCreateTreeViewer(Composite composite, int n) {
        TreeViewer treeViewer = super.doCreateTreeViewer(composite, this.toolkit.getBorderStyle() | n);
        this.toolkit.paintBordersFor(treeViewer.getTree().getParent());
        return treeViewer;
    }

    public void createUIListenerEntryFilter(IContextPart iContextPart) {
        this.fEntryFilter.setFormEntryListener(new FormEntryAdapter(iContextPart){

            public void browseButtonSelected(FormEntry formEntry) {
            }

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }

            public void selectionChanged(FormEntry formEntry) {
            }

            public void textDirty(FormEntry formEntry) {
            }

            public void textValueChanged(FormEntry formEntry) {
            }
        });
    }

    public boolean isFiltered() {
        String string = this.getFilterControl().getText();
        boolean bl = string != null && string.length() > 0 && !string.equals(this.getInitialText());
        return bl;
    }
}

