/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preprocess.contentAssistant;

import org.eclipse.mtj.ui.internal.preprocess.contentAssistant.PreprocessContentAssistMessages;
import org.eclipse.mtj.ui.internal.preprocess.contentAssistant.PreprocessDirective;
import org.eclipse.mtj.ui.internal.preprocess.contentAssistant.PreprocessSymbol;
import org.eclipse.mtj.ui.internal.preprocess.contentAssistant.PreprocessSymbolProviderInfo;

public class PreprocessJavaDocProvider {
    private static PreprocessJavaDocProvider fDefault;
    private static final String NEW_LINE_HTML = "<BR>";

    public static PreprocessJavaDocProvider getDefault() {
        if (fDefault == null) {
            fDefault = new PreprocessJavaDocProvider();
        }
        return fDefault;
    }

    private PreprocessJavaDocProvider() {
    }

    private String getDirectiveDocKey(PreprocessDirective preprocessDirective) {
        return String.valueOf(preprocessDirective.getName()) + "_javadoc";
    }

    public String getDirectiveJavaDoc(PreprocessDirective preprocessDirective) {
        String string = this.getDirectiveDocKey(preprocessDirective);
        return PreprocessContentAssistMessages.getString(string);
    }

    public String getSymbolJavaDoc(PreprocessSymbol preprocessSymbol) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Followings are the symbol provider's information:<BR><BR>");
        for (PreprocessSymbolProviderInfo preprocessSymbolProviderInfo : preprocessSymbol.getProviderInfos()) {
            this.showProviderInfo(preprocessSymbolProviderInfo, stringBuffer);
            stringBuffer.append(NEW_LINE_HTML);
        }
        return stringBuffer.toString();
    }

    private void showProviderInfo(PreprocessSymbolProviderInfo preprocessSymbolProviderInfo, StringBuffer stringBuffer) {
        if (preprocessSymbolProviderInfo.isActive) {
            stringBuffer.append("<B>");
        }
        stringBuffer.append("    ");
        stringBuffer.append(preprocessSymbolProviderInfo.getProviderName());
        stringBuffer.append(" - ");
        stringBuffer.append(preprocessSymbolProviderInfo.getProvidedSymbolValue());
        if (preprocessSymbolProviderInfo.isActive) {
            stringBuffer.append("</B>");
        }
    }
}

