/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preprocess.contentAssistant.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.mtj.ui.internal.preprocess.contentAssistant.template.ExclusivePositionUpdater;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class VariableTracker {
    private static final String CATEGORY = "__template_variables";
    private static final String COMMENT_START = "/*-";
    private static final String COMMENT_END = "*/";
    private Document fDocument;
    private final TemplateBuffer fBuffer;
    private List fPositions;

    public VariableTracker(TemplateBuffer templateBuffer) throws MalformedTreeException, BadLocationException {
        Assert.isLegal((templateBuffer != null ? 1 : 0) != 0);
        this.fBuffer = templateBuffer;
        this.fDocument = new Document(this.fBuffer.getString());
        this.fDocument.addPositionCategory(CATEGORY);
        this.fDocument.addPositionUpdater((IPositionUpdater)new ExclusivePositionUpdater(CATEGORY));
        this.fPositions = this.createRangeMarkers(this.fBuffer.getVariables(), (IDocument)this.fDocument);
    }

    private void checkState() {
        if (this.fDocument == null) {
            throw new IllegalStateException();
        }
    }

    private List createRangeMarkers(TemplateVariable[] templateVariableArray, IDocument iDocument) throws MalformedTreeException, BadLocationException {
        String string;
        Object object;
        Object object2;
        HashMap<ReplaceEdit, String> hashMap = new HashMap<ReplaceEdit, String>();
        MultiTextEdit multiTextEdit = new MultiTextEdit(0, iDocument.getLength());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        int n = 0;
        while (n != templateVariableArray.length) {
            object2 = templateVariableArray[n];
            object = object2.getOffsets();
            string = object2.getDefaultValue();
            if (this.isWhitespaceVariable(string)) {
                String string2 = COMMENT_START + string + COMMENT_END;
                int n2 = 0;
                while (n2 != ((int[])object).length) {
                    ReplaceEdit replaceEdit = new ReplaceEdit(object[n2], string.length(), string2);
                    multiTextEdit.addChild((TextEdit)replaceEdit);
                    bl = true;
                    hashMap.put(replaceEdit, string);
                    arrayList.add(replaceEdit);
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 != ((int[])object).length) {
                    RangeMarker rangeMarker = new RangeMarker(object[n3], string.length());
                    multiTextEdit.addChild((TextEdit)rangeMarker);
                    arrayList.add(rangeMarker);
                    ++n3;
                }
            }
            ++n;
        }
        if (bl) {
            multiTextEdit.apply(iDocument, 2);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (TextEdit)object2.next();
            try {
                string = new TypedPosition(object.getOffset(), object.getLength(), (String)hashMap.get(object));
                iDocument.addPosition(CATEGORY, (Position)string);
                arrayList2.add(string);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                Assert.isTrue((boolean)false);
            }
        }
        return arrayList2;
    }

    public IDocument getDocument() {
        this.checkState();
        return this.fDocument;
    }

    private boolean isWhitespaceVariable(String string) {
        int n = string.length();
        return n == 0 || Character.isWhitespace(string.charAt(0)) || Character.isWhitespace(string.charAt(n - 1));
    }

    private void removeRangeMarkers(List list, IDocument iDocument, TemplateVariable[] templateVariableArray) throws MalformedTreeException, BadLocationException, BadPositionCategoryException {
        String string;
        for (TypedPosition typedPosition : list) {
            iDocument.removePosition(CATEGORY, (Position)typedPosition);
            string = typedPosition.getType();
            if (string != null) {
                iDocument.replace(typedPosition.getOffset(), typedPosition.getLength(), string);
                typedPosition.setLength(string.length());
            }
            iDocument.addPosition((Position)typedPosition);
        }
        Iterator iterator = list.iterator();
        int n = 0;
        while (n != templateVariableArray.length) {
            string = templateVariableArray[n];
            int[] nArray = new int[string.getOffsets().length];
            int n2 = 0;
            while (n2 != nArray.length) {
                nArray[n2] = ((Position)iterator.next()).getOffset();
                ++n2;
            }
            string.setOffsets(nArray);
            ++n;
        }
    }

    public TemplateBuffer updateBuffer() throws MalformedTreeException, BadLocationException {
        this.checkState();
        TemplateVariable[] templateVariableArray = this.fBuffer.getVariables();
        try {
            this.removeRangeMarkers(this.fPositions, (IDocument)this.fDocument, templateVariableArray);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            Assert.isTrue((boolean)false);
        }
        this.fBuffer.setContent(this.fDocument.get(), templateVariableArray);
        this.fDocument = null;
        return this.fBuffer;
    }
}

