/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.mtj.core.model.IWritable;
import org.eclipse.mtj.internal.core.IWritableDelimiter;
import org.eclipse.mtj.internal.ui.editor.IMTJDragParticipant;
import org.eclipse.mtj.internal.ui.editor.IMTJSourceParticipant;
import org.eclipse.mtj.internal.ui.editor.ModelDataTransfer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class MTJDragAdapter
implements DragSourceListener,
IMTJSourceParticipant {
    private IMTJDragParticipant fParticipant;
    private static Object[] fSourceObjects;
    private static int fTransferType;
    public static final int F_TRANSFER_TYPE_NONE = 0;
    public static final int F_TRANSFER_TYPE_MODEL = 1;
    public static final int F_TRANSFER_TYPE_TEXT = 2;

    public MTJDragAdapter(IMTJDragParticipant iMTJDragParticipant) {
        this.fParticipant = iMTJDragParticipant;
        this.resetSourceObjects();
    }

    protected void setSourceObjects(Object[] objectArray) {
        fSourceObjects = objectArray;
    }

    public Object[] getSourceObjects() {
        return fSourceObjects;
    }

    protected void resetSourceObjects() {
        fSourceObjects = null;
        fTransferType = 0;
    }

    protected boolean isCopyOperationSupported() {
        return (this.fParticipant.getSupportedDNDOperations() & 1) == 1;
    }

    protected boolean isMoveOperationSupported() {
        return (this.fParticipant.getSupportedDNDOperations() & 2) == 2;
    }

    protected boolean isLinkOperationSupported() {
        return (this.fParticipant.getSupportedDNDOperations() & 4) == 4;
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (!dragSourceEvent.doit) {
            return;
        }
        if (dragSourceEvent.detail != 2) {
            return;
        }
        if ((fTransferType & 1) != 1) {
            return;
        }
        this.fParticipant.doDragRemove(this.getSourceObjects());
    }

    protected void validateDrag(DragSourceEvent dragSourceEvent) {
        if (!dragSourceEvent.doit) {
            return;
        }
        Object object = dragSourceEvent.getSource();
        if (!(object instanceof DragSource)) {
            dragSourceEvent.doit = false;
            return;
        }
        Control control = ((DragSource)object).getControl();
        Item[] itemArray = null;
        if (control instanceof Tree) {
            itemArray = ((Tree)control).getSelection();
        } else if (control instanceof Table) {
            itemArray = ((Table)control).getSelection();
        } else {
            dragSourceEvent.doit = false;
            return;
        }
        if (itemArray.length == 0) {
            dragSourceEvent.doit = false;
            return;
        }
        Object[] objectArray = new Object[itemArray.length];
        int n = 0;
        while (n < itemArray.length) {
            objectArray[n] = itemArray[n].getData();
            ++n;
        }
        this.setSourceObjects(objectArray);
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        if (!dragSourceEvent.doit) {
            return;
        }
        if (ModelDataTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            dragSourceEvent.data = this.getSourceObjects();
            fTransferType = 1;
        } else if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            dragSourceEvent.data = this.createTextualRepresentation();
            fTransferType = 2;
        }
    }

    protected Object createTextualRepresentation() {
        String string = null;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        boolean bl = true;
        Object[] objectArray = this.getSourceObjects();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof IWritable) {
                if (!bl && object instanceof IWritableDelimiter) {
                    ((IWritableDelimiter)object).writeDelimeter(printWriter);
                }
                ((IWritable)object).write("", printWriter);
            } else if (object instanceof String) {
                printWriter.println((String)object);
            }
            bl = false;
            ++n;
        }
        printWriter.flush();
        string = stringWriter.toString();
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        this.resetSourceObjects();
        this.validateDrag(dragSourceEvent);
        if (!dragSourceEvent.doit) {
            return;
        }
        if (this.isCopyOperationSupported() && !this.fParticipant.canDragCopy(this.getSourceObjects())) {
            dragSourceEvent.doit = false;
            return;
        }
        if (this.isMoveOperationSupported() && !this.fParticipant.canDragMove(this.getSourceObjects())) {
            dragSourceEvent.doit = false;
            return;
        }
        if (this.isLinkOperationSupported() && !this.fParticipant.canDragLink(this.getSourceObjects())) {
            dragSourceEvent.doit = false;
            return;
        }
    }
}

