/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mtj.core.model.IModelChangedEvent;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.FormFilteredTree;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editor.TreeSection;
import org.eclipse.mtj.internal.ui.editor.actions.CollapseAction;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nContentProvider;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalizationDataEditor;
import org.eclipse.mtj.internal.ui.editors.l10n.actions.L10nAddLocaleAction;
import org.eclipse.mtj.internal.ui.editors.l10n.actions.L10nAddLocaleEntryAction;
import org.eclipse.mtj.internal.ui.editors.l10n.actions.L10nAddObjectAction;
import org.eclipse.mtj.internal.ui.editors.l10n.actions.L10nRemoveObjectAction;
import org.eclipse.mtj.internal.ui.parts.TreePart;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.keys.IBindingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalesTreeSection
extends TreeSection {
    private static final int F_BUTTON_ADD_LOCALE = 0;
    private static final int F_BUTTON_ADD_ENTRY = 1;
    private static final int F_BUTTON_REMOVE = 2;
    private static final int F_BUTTON_UP = 4;
    private static final int F_BUTTON_DOWN = 5;
    private static final int F_DOWN_FLAG = 1;
    private static final int F_UP_FLAG = -1;
    private L10nAddLocaleAction addLocaleAction;
    private L10nAddLocaleEntryAction addLocaleEntryAction;
    private CollapseAction fCollapseAction;
    private boolean fDragFromHere;
    private FormFilteredTree filteredTree;
    private L10nModel model;
    private L10nRemoveObjectAction removeObjectAction;
    private TreeViewer localesTree;

    public LocalesTreeSection(MTJFormPage mTJFormPage, Composite composite) {
        String[] stringArray = new String[6];
        stringArray[0] = MTJUIMessages.LocalesTreeSection_addLocale_button_label;
        stringArray[1] = MTJUIMessages.LocalesTreeSection_addEntry_button_label;
        stringArray[2] = MTJUIMessages.LocalesTreeSection_remove_button_label;
        stringArray[4] = MTJUIMessages.LocalesTreeSection_up_button_label;
        stringArray[5] = MTJUIMessages.LocalesTreeSection_down_button_label;
        super(mTJFormPage, composite, 128, stringArray);
        this.addLocaleAction = new L10nAddLocaleAction();
        this.addLocaleEntryAction = new L10nAddLocaleEntryAction();
        this.removeObjectAction = new L10nRemoveObjectAction();
    }

    public void dispose() {
        MTJUIPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    @Override
    public boolean doGlobalAction(String string) {
        boolean bl = string.equals(ActionFactory.CUT.getId());
        if (bl || string.equals(ActionFactory.DELETE.getId())) {
            this.handleDeleteAction();
            return !bl;
        }
        if (string.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void fireSelection() {
        this.localesTree.setSelection(this.localesTree.getSelection());
    }

    public ISelection getSelection() {
        return this.localesTree.getSelection();
    }

    public void handleDrag(List<IStructuredSelection> list) {
        this.handleRemove(list);
        this.fDragFromHere = false;
    }

    public void handleRemove(List<IStructuredSelection> list) {
        if (!list.isEmpty()) {
            this.removeObjectAction.setToRemove(list.toArray(new L10nObject[list.size()]));
            this.removeObjectAction.run();
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent iModelChangedEvent) {
        if (iModelChangedEvent.getChangeType() == 99) {
            this.handleModelEventWorldChanged(iModelChangedEvent);
        } else if (iModelChangedEvent.getChangeType() == 1) {
            this.handleModelInsertType(iModelChangedEvent);
        } else if (iModelChangedEvent.getChangeType() == 2) {
            this.handleModelRemoveType(iModelChangedEvent);
        } else if (iModelChangedEvent.getChangeType() == 3 && iModelChangedEvent.getChangedProperty().equals("type_swap")) {
            this.handleModelChangeTypeSwap(iModelChangedEvent);
        } else if (iModelChangedEvent.getChangeType() == 3) {
            this.handleModelChangeType(iModelChangedEvent);
        }
    }

    public boolean performDrop(Object object, Object object2, int n) {
        return false;
    }

    public void refresh() {
        L10nModel l10nModel = (L10nModel)this.getPage().getModel();
        l10nModel.validate();
        this.localesTree.setInput((Object)l10nModel);
        this.localesTree.expandToLevel(2);
        this.localesTree.setSelection((ISelection)new StructuredSelection((Object)l10nModel.getLocales()), true);
        this.getManagedForm().fireSelectionChanged((IFormPart)this, this.localesTree.getSelection());
        super.refresh();
    }

    public boolean setFormInput(Object object) {
        if (object instanceof L10nObject) {
            ((L10nObject)object).validate();
            this.localesTree.setSelection((ISelection)new StructuredSelection(object), true);
            ISelection iSelection = this.localesTree.getSelection();
            if (iSelection != null && !iSelection.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public void setSelection(ISelection iSelection) {
        this.localesTree.setSelection(iSelection);
    }

    public void updateButtons() {
        if (!this.model.isEditable()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.localesTree.getSelection();
        boolean bl4 = iStructuredSelection.size() == 1;
        boolean bl5 = iStructuredSelection.size() == 1;
        for (L10nObject l10nObject : iStructuredSelection) {
            if (l10nObject != null) {
                if (l10nObject.canBeRemoved()) {
                    bl3 = true;
                }
                L10nObject l10nObject2 = l10nObject.getParent();
                if (iStructuredSelection.size() == 1) {
                    if (l10nObject.getType() == 0) {
                        bl = true;
                        bl2 = false;
                    } else if (l10nObject.getType() == 1) {
                        bl = false;
                        bl2 = true;
                    } else if (l10nObject.getType() == 2) {
                        bl = false;
                        bl2 = false;
                    }
                }
                if (l10nObject.getType() == 0) {
                    bl4 = false;
                    bl5 = false;
                    continue;
                }
                if (l10nObject2 == null) continue;
                L10nObject l10nObject3 = l10nObject2;
                if (l10nObject3.isFirstChildNode((IDocumentElementNode)l10nObject, L10nObject.class)) {
                    bl4 = false;
                }
                if (!l10nObject3.isLastChildNode((IDocumentElementNode)l10nObject, L10nObject.class)) continue;
                bl5 = false;
                continue;
            }
            bl = false;
            bl2 = false;
            bl3 = false;
            bl4 = false;
            bl5 = false;
            break;
        }
        this.getTreePart().setButtonEnabled(0, bl);
        this.getTreePart().setButtonEnabled(1, bl2);
        this.getTreePart().setButtonEnabled(2, bl3);
        this.getTreePart().setButtonEnabled(4, bl4);
        this.getTreePart().setButtonEnabled(5, bl5);
    }

    private void createSectionToolbar(Section section, FormToolkit formToolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl((Composite)section);
        final Cursor cursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (cursor != null && !cursor.isDisposed()) {
                    cursor.dispose();
                }
            }
        });
        this.fCollapseAction = new CollapseAction((AbstractTreeViewer)this.localesTree, MTJUIMessages.LocalesTreeSection_collapseAllAction_Text, 1, this.model.getLocales());
        toolBarManager.add((IAction)this.fCollapseAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolBar);
    }

    private void createTree(Composite composite, FormToolkit formToolkit) {
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(composite, 2, 2, formToolkit);
        this.localesTree = treePart.getTreeViewer();
        this.localesTree.setContentProvider((IContentProvider)new L10nContentProvider());
        this.localesTree.setLabelProvider((IBaseLabelProvider)MTJUIPlugin.getDefault().getLabelProvider());
        MTJUIPlugin.getDefault().getLabelProvider().connect(this);
        this.createTreeListeners();
    }

    private void createTreeListeners() {
        this.localesTree.addPostSelectionChangedListener((ISelectionChangedListener)this.getPage().getMTJEditor().new MTJFormEditor.MTJFormEditorChangeListener());
    }

    private void fillContextMenuAddActions(MenuManager menuManager, L10nObject l10nObject) {
        if (l10nObject != null && l10nObject.canBeParent()) {
            if (l10nObject instanceof L10nLocales) {
                this.addLocaleAction.setParentObject(l10nObject);
                this.addLocaleAction.setEnabled(this.model.isEditable());
                menuManager.add((IAction)this.addLocaleAction);
            } else if (l10nObject instanceof L10nLocale) {
                this.addLocaleEntryAction.setParentObject(l10nObject);
                this.addLocaleEntryAction.setEnabled(this.model.isEditable());
                menuManager.add((IAction)this.addLocaleEntryAction);
            }
        }
    }

    private void fillContextMenuRemoveAction(IMenuManager iMenuManager, L10nObject l10nObject) {
        this.removeObjectAction.setToRemove(l10nObject);
        iMenuManager.add((IAction)this.removeObjectAction);
        this.removeObjectAction.setEnabled(l10nObject.canBeRemoved() && this.model.isEditable());
    }

    private void fillContextMenuShowInAction(IMenuManager iMenuManager) {
        String string;
        String string2 = MTJUIMessages.LocalesTreeSection_showInLabel;
        IBindingService iBindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (iBindingService != null && (string = iBindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu")) != null) {
            string2 = String.valueOf(string2) + '\t' + string;
        }
        string = new MenuManager(string2);
        string.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getPage().getSite().getWorkbenchWindow()));
        iMenuManager.add((IContributionItem)string);
    }

    private void handleAddAction(L10nAddObjectAction l10nAddObjectAction) {
        ISelection iSelection = this.localesTree.getSelection();
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object == null) {
            return;
        }
        L10nObject l10nObject = (L10nObject)object;
        if (l10nObject.canBeParent()) {
            l10nAddObjectAction.setParentObject(l10nObject);
            l10nAddObjectAction.run();
        } else {
            l10nAddObjectAction.setParentObject(l10nObject.getParent());
            l10nAddObjectAction.setTargetObject(l10nObject);
            l10nAddObjectAction.run();
        }
    }

    private void handleDeleteAction() {
        ArrayList<IStructuredSelection> arrayList = new ArrayList<IStructuredSelection>(((IStructuredSelection)this.localesTree.getSelection()).toList());
        boolean bl = false;
        FormEditor formEditor = arrayList.iterator();
        while (formEditor.hasNext()) {
            L10nObject l10nObject;
            Object e = formEditor.next();
            if (!(e instanceof L10nObject) || (l10nObject = (L10nObject)e).canBeRemoved()) continue;
            formEditor.remove();
            bl = true;
        }
        if (bl) {
            Display.getCurrent().beep();
        }
        this.handleRemove(arrayList);
        this.model.getLocales().validate();
        formEditor = this.getPage().getEditor();
        if (formEditor instanceof LocalizationDataEditor) {
            ((LocalizationDataEditor)formEditor).displayLocaleKeysConflict(this.model.getLocales());
        }
        this.localesTree.refresh();
    }

    private void handleModelChangeType(final IModelChangedEvent iModelChangedEvent) {
        this.localesTree.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (LocalesTreeSection.this.localesTree.getControl().isDisposed()) {
                    return;
                }
                Object[] objectArray = iModelChangedEvent.getChangedObjects();
                L10nObject l10nObject = (L10nObject)objectArray[0];
                if (l10nObject != null) {
                    LocalesTreeSection.this.localesTree.update((Object)l10nObject, null);
                    LocalesTreeSection.this.localesTree.refresh();
                }
            }
        });
    }

    private void handleModelChangeTypeSwap(IModelChangedEvent iModelChangedEvent) {
        Object[] objectArray = iModelChangedEvent.getChangedObjects();
        L10nObject l10nObject = (L10nObject)objectArray[0];
        if (l10nObject != null) {
            l10nObject.validate();
            this.localesTree.refresh((Object)l10nObject);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent iModelChangedEvent) {
        this.markStale();
    }

    private void handleModelInsertType(IModelChangedEvent iModelChangedEvent) {
        Object[] objectArray = iModelChangedEvent.getChangedObjects();
        L10nObject l10nObject = (L10nObject)objectArray[0];
        if (l10nObject != null) {
            l10nObject.validate();
            this.localesTree.refresh((Object)l10nObject.getParent());
            this.localesTree.setSelection((ISelection)new StructuredSelection((Object)l10nObject), true);
        }
    }

    private void handleModelRemoveType(IModelChangedEvent iModelChangedEvent) {
        Object[] objectArray = iModelChangedEvent.getChangedObjects();
        L10nObject l10nObject = (L10nObject)objectArray[0];
        if (l10nObject != null && l10nObject.getType() != 0) {
            this.handleTaskObjectRemove(l10nObject);
        }
    }

    private void handleMoveAction(int n) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.localesTree.getSelection();
        for (Object e : iStructuredSelection) {
            L10nObject l10nObject;
            L10nObject l10nObject2;
            if (e == null) {
                return;
            }
            if (!(e instanceof L10nObject) || (l10nObject2 = (l10nObject = (L10nObject)e).getParent()) == null) continue;
            l10nObject2.moveChildNode((IDocumentElementNode)l10nObject, n, true);
        }
    }

    private void handleTaskObjectRemove(L10nObject l10nObject) {
        this.localesTree.remove((Object)l10nObject);
        L10nObject l10nObject2 = this.removeObjectAction.getNextSelection();
        if (l10nObject2 == null) {
            l10nObject2 = l10nObject.getParent();
        }
        if (l10nObject2.equals(l10nObject.getParent())) {
            this.localesTree.refresh((Object)l10nObject.getParent());
        }
        if (!this.fDragFromHere) {
            this.localesTree.setSelection((ISelection)new StructuredSelection((Object)l10nObject2), true);
        }
    }

    private void initializeTreeViewer() {
        if (this.model == null) {
            return;
        }
        this.localesTree.setInput((Object)this.model);
        L10nLocales l10nLocales = this.model.getLocales();
        this.getTreePart().setButtonEnabled(0, this.isEditable());
        this.getTreePart().setButtonEnabled(1, this.isEditable());
        this.getTreePart().setButtonEnabled(2, false);
        this.getTreePart().setButtonEnabled(4, false);
        this.getTreePart().setButtonEnabled(5, false);
        this.localesTree.setSelection((ISelection)new StructuredSelection((Object)l10nLocales), true);
        this.localesTree.expandToLevel(2);
    }

    @Override
    protected void buttonSelected(int n) {
        switch (n) {
            case 0: {
                this.handleAddAction(this.addLocaleAction);
                break;
            }
            case 1: {
                this.handleAddAction(this.addLocaleEntryAction);
                break;
            }
            case 2: {
                this.handleDeleteAction();
                break;
            }
            case 4: {
                this.handleMoveAction(-1);
                break;
            }
            case 5: {
                this.handleMoveAction(1);
            }
        }
    }

    @Override
    protected boolean canPaste(Object object, Object[] objectArray) {
        return true;
    }

    @Override
    protected void createClient(Section section, FormToolkit formToolkit) {
        this.model = (L10nModel)this.getPage().getModel();
        this.model.validate();
        Composite composite = this.createClientContainer((Composite)section, 2, formToolkit);
        this.createTree(composite, formToolkit);
        formToolkit.paintBordersFor(composite);
        section.setText(MTJUIMessages.LocalesTreeSection_title);
        section.setDescription(MTJUIMessages.LocalesTreeSection_description);
        section.setClient((Control)composite);
        this.initializeTreeViewer();
        this.createSectionToolbar(section, formToolkit);
        this.filteredTree.createUIListenerEntryFilter(this);
        L10nLocales l10nLocales = this.model.getLocales();
        l10nLocales.validate();
        FormEditor formEditor = this.getPage().getEditor();
        if (formEditor instanceof LocalizationDataEditor) {
            ((LocalizationDataEditor)formEditor).displayLocaleKeysConflict(l10nLocales);
        }
    }

    @Override
    protected TreeViewer createTreeViewer(Composite composite, int n) {
        this.filteredTree = new FormFilteredTree(composite, n, new PatternFilter());
        composite.setData("filtered", (Object)Boolean.TRUE);
        return this.filteredTree.getViewer();
    }

    @Override
    protected void doPaste(Object object, Object[] objectArray) {
    }

    @Override
    protected void fillContextMenu(IMenuManager iMenuManager) {
        ISelection iSelection = this.localesTree.getSelection();
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        L10nObject l10nObject = (L10nObject)object;
        if (l10nObject != null) {
            boolean bl = true;
            if (l10nObject.canBeParent()) {
                MenuManager menuManager = new MenuManager(MTJUIMessages.LocalesTreeSection_new_submenu_text);
                this.fillContextMenuAddActions(menuManager, l10nObject);
                iMenuManager.add((IContributionItem)menuManager);
                bl = false;
            }
            if (!bl) {
                iMenuManager.add((IContributionItem)new Separator());
            }
        }
        this.getPage().getMTJEditor().getContributor().contextMenuAboutToShow(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        if (l10nObject != null) {
            this.fillContextMenuRemoveAction(iMenuManager, l10nObject);
            iMenuManager.add((IContributionItem)new Separator());
            this.fillContextMenuShowInAction(iMenuManager);
            iMenuManager.add((IContributionItem)new Separator());
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection iStructuredSelection) {
    }

    @Override
    protected void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.getPage().getMTJEditor().setSelection((ISelection)iStructuredSelection);
        this.updateButtons();
    }
}

