/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editors.device.pages;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.importer.LibraryImporter;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.device.impl.AbstractDevice;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.library.api.API;
import org.eclipse.mtj.core.model.library.impl.Library;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.PersistableUtilities;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.editors.device.AbstractDeviceEditorPage;
import org.eclipse.mtj.ui.editors.device.LibraryApiEditorDialog;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.ui.viewers.TableViewerConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DeviceLibrariesEditorPage
extends AbstractDeviceEditorPage {
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.DeviceLibrariesEditorPage_file_columnInfo, 15.0f, null), new TableColumnInfo(MTJUIMessages.DeviceLibrariesEditorPage_path_columnInfo, 20.0f, null), new TableColumnInfo(MTJUIMessages.DeviceLibrariesEditorPage_apis_columnInfo, 15.0f, null), new TableColumnInfo(MTJUIMessages.DeviceLibrariesEditorPage_javadoc_columnInfo, 25.0f, null), new TableColumnInfo(MTJUIMessages.DeviceLibrariesEditorPage_source_columnInfo, 25.0f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 650;
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String PROP_APIS = "apis";
    private static final String PROP_FILE = "file";
    private static final String PROP_JAVADOC = "javadoc";
    private static final String PROP_PATH = "path";
    private static final String PROP_SOURCE = "source";
    private static final String[] PROPERTIES = new String[]{"file", "path", "apis", "javadoc", "source"};
    private TableViewer viewer;

    public DeviceLibrariesEditorPage(Composite composite, int n) {
        super(composite, n);
    }

    public void commitDeviceChanges() {
        Object object = this.viewer.getInput();
        if (object instanceof Classpath) {
            this.editDevice.setClasspath((Classpath)object);
        }
    }

    public String getDescription() {
        return MTJUIMessages.DeviceLibrariesEditorPage_description;
    }

    public String getTitle() {
        return MTJUIMessages.DeviceLibrariesEditorPage_title;
    }

    public void setDevice(IDevice iDevice) {
        super.setDevice(iDevice);
        if (iDevice instanceof AbstractDevice) {
            Classpath classpath = ((AbstractDevice)iDevice).getClasspath();
            try {
                Classpath classpath2 = (Classpath)PersistableUtilities.clonePersistable((IPersistable)classpath);
                this.viewer.setInput((Object)classpath2);
            }
            catch (PersistenceException persistenceException) {
                MTJCorePlugin.log((int)2, (String)MTJUIMessages.DeviceLibrariesEditorPage_error_cloning_device_classpath, (Throwable)persistenceException);
            }
        }
    }

    private TableViewer createTableViewer(Composite composite) {
        int n = 68100;
        Table table = new Table(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new DeviceClasspathContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings("deviceLibrariesViewerSettings");
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, 650, COLUMN_INFO, 0);
        tableViewerConfiguration.configure(tableViewer);
        tableViewer.setCellModifier((ICellModifier)new CellModifier());
        tableViewer.setColumnProperties(PROPERTIES);
        tableViewer.setCellEditors(new CellEditor[]{new ArchiveFileSelectionDialogCellEditor((Composite)table, false), new ArchiveFileSelectionDialogCellEditor((Composite)table, true), new APIFileSelectionDialogCellEditor((Composite)table), new JavadocAttachDialogCellEditor((Composite)table), new SourceAttachDialogCellEditor((Composite)table)});
        return tableViewer;
    }

    private String getApisLabel(API[] aPIArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < aPIArray.length) {
            API aPI = aPIArray[n];
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(aPI);
            ++n;
        }
        return stringBuffer.toString();
    }

    private Classpath getClasspath() {
        return (Classpath)this.viewer.getInput();
    }

    private ILibrary getSelectedLibrary() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        return iStructuredSelection.size() > 0 ? (ILibrary)iStructuredSelection.getFirstElement() : null;
    }

    private void handleAddButton() {
        File file = this.promptForArchiveFile(this.getShell(), null);
        if (file != null) {
            LibraryImporter libraryImporter = new LibraryImporter();
            ILibrary iLibrary = libraryImporter.createLibraryFor(file);
            this.getClasspath().addEntry(iLibrary);
            this.viewer.refresh();
        }
    }

    private void handleRemoveButton() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)MTJUIMessages.DeviceLibrariesEditorPage_handleRemoveButton_dialog_title, (String)MTJUIMessages.DeviceLibrariesEditorPage_handleRemoveButton_dialog_message)) {
            ILibrary iLibrary = this.getSelectedLibrary();
            this.getClasspath().removeEntry(iLibrary);
            this.viewer.refresh();
        }
    }

    private File promptForArchiveFile(Shell shell, File file) {
        String string;
        FileDialog fileDialog = new FileDialog(shell);
        fileDialog.setFilterNames(new String[]{"*.jar;*.zip"});
        if (file != null && file.exists()) {
            fileDialog.setFileName(file.toString());
        }
        return (string = fileDialog.open()) == null ? null : new File(string);
    }

    protected void addPageControls(Composite composite) {
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 650;
        gridData.heightHint = 400;
        this.viewer = this.createTableViewer(composite);
        this.viewer.getTable().setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(1040));
        Button button = new Button(composite2, 8);
        button.setLayoutData((Object)new GridData(768));
        button.setText(MTJUIMessages.DeviceLibrariesEditorPage_addButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceLibrariesEditorPage.this.handleAddButton();
            }
        });
        final Button button2 = new Button(composite2, 8);
        button2.setEnabled(false);
        button2.setLayoutData((Object)new GridData(768));
        button2.setText(MTJUIMessages.DeviceLibrariesEditorPage_removeButton);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceLibrariesEditorPage.this.handleRemoveButton();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ILibrary iLibrary = DeviceLibrariesEditorPage.this.getSelectedLibrary();
                button2.setEnabled(iLibrary != null);
            }
        });
    }

    protected URL getJavadocURL(IClasspathEntry iClasspathEntry) {
        URL uRL = null;
        if (iClasspathEntry != null && iClasspathEntry.getExtraAttributes() != null) {
            IClasspathAttribute[] iClasspathAttributeArray;
            IClasspathAttribute[] iClasspathAttributeArray2 = iClasspathAttributeArray = iClasspathEntry.getExtraAttributes();
            int n = iClasspathAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute iClasspathAttribute = iClasspathAttributeArray2[n2];
                if (iClasspathAttribute.getName().equals("javadoc_location")) {
                    try {
                        uRL = new URL(iClasspathAttribute.getValue());
                    }
                    catch (MalformedURLException malformedURLException) {
                        MTJCorePlugin.log((int)2, (String)MTJUIMessages.DeviceLibrariesEditorPage_error_getting_new_Javadoc, (Throwable)malformedURLException);
                    }
                }
                ++n2;
            }
        }
        return uRL;
    }

    private class APIFileSelectionDialogCellEditor
    extends DialogCellEditor {
        public APIFileSelectionDialogCellEditor(Composite composite) {
            super(composite);
        }

        protected Object openDialogBox(Control control) {
            LibraryApiEditorDialog libraryApiEditorDialog = new LibraryApiEditorDialog(control.getShell());
            API[] aPIArray = (API[])this.doGetValue();
            libraryApiEditorDialog.setAPIs(aPIArray);
            return libraryApiEditorDialog.open() == 0 ? libraryApiEditorDialog.getAPIs() : aPIArray;
        }

        protected void updateContents(Object object) {
            Label label = this.getDefaultLabel();
            if (label == null) {
                return;
            }
            String string = "";
            if (object != null) {
                API[] aPIArray = (API[])object;
                string = DeviceLibrariesEditorPage.this.getApisLabel(aPIArray);
            }
            label.setText(string);
        }
    }

    private class ArchiveFileSelectionDialogCellEditor
    extends DialogCellEditor {
        private boolean filepath;

        public ArchiveFileSelectionDialogCellEditor(Composite composite, boolean bl) {
            super(composite);
            this.filepath = bl;
        }

        protected Object openDialogBox(Control control) {
            File file = (File)this.doGetValue();
            return DeviceLibrariesEditorPage.this.promptForArchiveFile(control.getShell(), file);
        }

        protected void updateContents(Object object) {
            Label label = this.getDefaultLabel();
            if (label == null) {
                return;
            }
            String string = "";
            if (object != null) {
                File file = (File)object;
                string = this.filepath ? file.getParent() : file.getName();
            }
            label.setText(string);
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            IClasspathEntry iClasspathEntry = null;
            Library library = (Library)object;
            switch (this.getColumnIndex(string)) {
                case 0: 
                case 1: {
                    iClasspathEntry = library.getLibraryFile();
                    break;
                }
                case 2: {
                    iClasspathEntry = library.getAPIs();
                    break;
                }
                case 3: 
                case 4: {
                    iClasspathEntry = library.toClasspathEntry();
                }
            }
            return iClasspathEntry;
        }

        public void modify(Object object, String string, Object object2) {
            TableItem tableItem = (TableItem)object;
            Library library = (Library)tableItem.getData();
            switch (this.getColumnIndex(string)) {
                case 0: 
                case 1: {
                    library.setLibraryFile((File)object2);
                    break;
                }
                case 2: {
                    library.setApis((API[])object2);
                    break;
                }
                case 3: {
                    URL uRL = DeviceLibrariesEditorPage.this.getJavadocURL((IClasspathEntry)object2);
                    library.setJavadocURL(uRL);
                    break;
                }
                case 4: {
                    IClasspathEntry iClasspathEntry = (IClasspathEntry)object2;
                    library.setSourceAttachmentPath(iClasspathEntry.getSourceAttachmentPath());
                    library.setSourceAttachmentRootPath(iClasspathEntry.getSourceAttachmentRootPath());
                }
            }
            DeviceLibrariesEditorPage.this.viewer.refresh((Object)library, true);
        }

        private int getColumnIndex(String string) {
            int n = -1;
            int n2 = 0;
            while (n2 < PROPERTIES.length) {
                if (PROPERTIES[n2].equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            return n;
        }
    }

    private static class DeviceClasspathContentProvider
    implements IStructuredContentProvider {
        private DeviceClasspathContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = NO_ELEMENTS;
            if (object instanceof Classpath) {
                Classpath classpath = (Classpath)object;
                objectArray = classpath.getEntries();
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class JavadocAttachDialogCellEditor
    extends DialogCellEditor {
        public JavadocAttachDialogCellEditor(Composite composite) {
            super(composite);
        }

        protected Object openDialogBox(Control control) {
            Shell shell = control.getShell();
            IClasspathEntry iClasspathEntry = null;
            IClasspathEntry iClasspathEntry2 = (IClasspathEntry)this.doGetValue();
            if (iClasspathEntry2 != null) {
                iClasspathEntry = BuildPathDialogAccess.configureJavadocLocation((Shell)shell, (IClasspathEntry)iClasspathEntry2);
            }
            return iClasspathEntry;
        }

        protected void updateContents(Object object) {
            IClasspathEntry iClasspathEntry;
            URL uRL;
            Label label = this.getDefaultLabel();
            if (label == null) {
                return;
            }
            String string = "";
            if (object != null && (uRL = DeviceLibrariesEditorPage.this.getJavadocURL(iClasspathEntry = (IClasspathEntry)object)) != null) {
                string = uRL.toString();
            }
            label.setText(string);
        }
    }

    private class LibraryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private LibraryLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            Library library = (Library)object;
            String string = "";
            if (library != null) {
                switch (n) {
                    case 0: {
                        string = library.getLibraryFile().getName();
                        break;
                    }
                    case 1: {
                        string = library.getLibraryFile().getParent();
                        break;
                    }
                    case 2: {
                        string = DeviceLibrariesEditorPage.this.getApisLabel(library.getAPIs());
                        break;
                    }
                    case 3: {
                        URL uRL = library.getJavadocURL();
                        if (uRL == null) break;
                        string = uRL.toString();
                        break;
                    }
                    case 4: {
                        IPath iPath = library.getSourceAttachmentPath();
                        if (iPath == null) break;
                        string = iPath.toString();
                    }
                }
            }
            return string;
        }
    }

    private static class SourceAttachDialogCellEditor
    extends DialogCellEditor {
        public SourceAttachDialogCellEditor(Composite composite) {
            super(composite);
        }

        protected Object openDialogBox(Control control) {
            Shell shell = control.getShell();
            IClasspathEntry iClasspathEntry = null;
            IClasspathEntry iClasspathEntry2 = (IClasspathEntry)this.doGetValue();
            if (iClasspathEntry2 != null) {
                iClasspathEntry = BuildPathDialogAccess.configureSourceAttachment((Shell)shell, (IClasspathEntry)iClasspathEntry2);
            }
            return iClasspathEntry;
        }

        protected void updateContents(Object object) {
            IClasspathEntry iClasspathEntry;
            IPath iPath;
            Label label = this.getDefaultLabel();
            if (label == null) {
                return;
            }
            String string = "";
            if (object != null && (iPath = (iClasspathEntry = (IClasspathEntry)object).getSourceAttachmentPath()) != null) {
                string = iPath.toString();
            }
            label.setText(string);
        }
    }
}

