/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.Hashtable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mtj.core.model.IBaseModel;
import org.eclipse.mtj.core.model.IEditable;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.IUpdate;

public class MTJFormEditorContributor
extends MultiPageEditorActionBarContributor {
    private ClipboardAction copyAction;
    private ClipboardAction cutAction;
    private Hashtable<String, Action> globalActions = new Hashtable();
    private ClipboardAction pasteAction;
    private SaveAction saveAction;
    private ISharedImages sharedImages;
    protected IFormPage formPage;
    protected MTJFormEditor mtjFormEditor;
    protected RevertAction revertAction;

    public MTJFormEditorContributor(String string) {
    }

    public void addClipboardActions(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.cutAction);
        iMenuManager.add((IAction)this.copyAction);
        iMenuManager.add((IAction)this.pasteAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.revertAction);
    }

    public void contextMenuAboutToShow(IMenuManager iMenuManager) {
        this.contextMenuAboutToShow(iMenuManager, true);
    }

    public void contextMenuAboutToShow(IMenuManager iMenuManager, boolean bl) {
        if (this.mtjFormEditor != null) {
            this.updateSelectableActions(this.mtjFormEditor.getSelection());
        }
        if (bl) {
            this.addClipboardActions(iMenuManager);
        }
        iMenuManager.add((IAction)this.saveAction);
    }

    public void contributeToCoolBar(ICoolBarManager iCoolBarManager) {
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
    }

    public void contributeToStatusLine(IStatusLineManager iStatusLineManager) {
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
    }

    public MTJFormEditor getEditor() {
        return this.mtjFormEditor;
    }

    public IAction getGlobalAction(String string) {
        return (IAction)this.globalActions.get(string);
    }

    public IAction getRevertAction() {
        return this.revertAction;
    }

    public IAction getSaveAction() {
        return this.saveAction;
    }

    public IEditorActionBarContributor getSourceContributor() {
        return null;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.getActionBars().getStatusLineManager();
    }

    public void init(IActionBars iActionBars) {
        super.init(iActionBars);
        this.makeActions();
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        if (iEditorPart instanceof MTJSourcePage) {
            MTJSourcePage mTJSourcePage = (MTJSourcePage)iEditorPart;
            MTJUIPlugin.getActivePage().activate((IWorkbenchPart)mTJSourcePage.getEditor());
            return;
        }
        if (!(iEditorPart instanceof MTJFormEditor)) {
            return;
        }
        this.mtjFormEditor = (MTJFormEditor)iEditorPart;
        this.mtjFormEditor.updateUndo(this.getGlobalAction(ActionFactory.UNDO.getId()), this.getGlobalAction(ActionFactory.REDO.getId()));
        this.setActivePage(this.mtjFormEditor.getActiveEditor());
        this.updateSelectableActions(this.mtjFormEditor.getSelection());
    }

    public void setActivePage(IEditorPart iEditorPart) {
        if (this.mtjFormEditor == null) {
            return;
        }
        IFormPage iFormPage = this.formPage;
        this.formPage = this.mtjFormEditor.getActivePageInstance();
        if (this.formPage != null) {
            this.updateActions();
            if (iFormPage != null && !iFormPage.isEditor() && !this.formPage.isEditor()) {
                this.getActionBars().updateActionBars();
            }
        }
    }

    public void updateActions() {
        this.saveAction.update();
        this.revertAction.update();
    }

    public void updateSelectableActions(ISelection iSelection) {
        if (this.mtjFormEditor != null) {
            this.cutAction.selectionChanged(iSelection);
            this.copyAction.selectionChanged(iSelection);
            this.pasteAction.selectionChanged(iSelection);
        }
    }

    private void addGlobalAction(String string) {
        GlobalAction globalAction = new GlobalAction(string);
        this.addGlobalAction(string, globalAction);
    }

    private void addGlobalAction(String string, Action action) {
        this.globalActions.put(string, action);
        this.getActionBars().setGlobalActionHandler(string, (IAction)action);
    }

    protected ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = this.getPage().getWorkbenchWindow().getWorkbench().getSharedImages();
        }
        return this.sharedImages;
    }

    protected void makeActions() {
        this.cutAction = new CutAction();
        this.copyAction = new CopyAction();
        this.pasteAction = new PasteAction();
        this.addGlobalAction(ActionFactory.CUT.getId(), this.cutAction);
        this.addGlobalAction(ActionFactory.COPY.getId(), this.copyAction);
        this.addGlobalAction(ActionFactory.PASTE.getId(), this.pasteAction);
        this.addGlobalAction(ActionFactory.DELETE.getId());
        this.addGlobalAction(ActionFactory.UNDO.getId());
        this.addGlobalAction(ActionFactory.REDO.getId());
        this.addGlobalAction(ActionFactory.SELECT_ALL.getId());
        this.addGlobalAction(ActionFactory.FIND.getId());
        this.addGlobalAction(IDEActionFactory.BOOKMARK.getId());
        this.saveAction = new SaveAction();
        this.saveAction.setText(MTJUIMessages.MTJFormEditorContributor_saveAction_text);
        this.revertAction = new RevertAction();
        this.revertAction.setText(MTJUIMessages.MTJFormEditorContributor_revertAction_text);
        this.addGlobalAction(ActionFactory.REVERT.getId(), this.revertAction);
    }

    class ClipboardAction
    extends GlobalAction {
        public ClipboardAction(String string) {
            super(string);
            this.setEnabled(false);
        }

        public boolean isEditable() {
            if (MTJFormEditorContributor.this.mtjFormEditor == null) {
                return false;
            }
            IBaseModel iBaseModel = MTJFormEditorContributor.this.mtjFormEditor.getAggregateModel();
            return iBaseModel instanceof IEditable ? ((IEditable)iBaseModel).isEditable() : false;
        }

        public void selectionChanged(ISelection iSelection) {
        }
    }

    class CopyAction
    extends ClipboardAction {
        public CopyAction() {
            super(ActionFactory.COPY.getId());
            this.setText(MTJUIMessages.MTJFormEditorContributor_copyAction_text);
            this.setImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        }

        public void selectionChanged(ISelection iSelection) {
            this.setEnabled(MTJFormEditorContributor.this.mtjFormEditor.canCopy(iSelection));
        }
    }

    class CutAction
    extends ClipboardAction {
        public CutAction() {
            super(ActionFactory.CUT.getId());
            this.setText(MTJUIMessages.MTJFormEditorContributor_cutAction_text);
            this.setImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
            this.setDisabledImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
            this.setActionDefinitionId("org.eclipse.ui.edit.cut");
        }

        public void selectionChanged(ISelection iSelection) {
            this.setEnabled(this.isEditable() && MTJFormEditorContributor.this.mtjFormEditor.canCut(iSelection));
        }
    }

    class GlobalAction
    extends Action
    implements IUpdate {
        private String id;

        public GlobalAction(String string) {
            this.id = string;
        }

        public void run() {
            MTJFormEditorContributor.this.mtjFormEditor.performGlobalAction(this.id);
            MTJFormEditorContributor.this.updateSelectableActions(MTJFormEditorContributor.this.mtjFormEditor.getSelection());
        }

        public void update() {
            MTJFormEditorContributor.this.getActionBars().updateActionBars();
        }
    }

    class PasteAction
    extends ClipboardAction {
        public PasteAction() {
            super(ActionFactory.PASTE.getId());
            this.setText(MTJUIMessages.MTJFormEditorContributor_pasteAction_text);
            this.setImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
            this.setDisabledImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        }

        public void selectionChanged(ISelection iSelection) {
            this.setEnabled(this.isEditable() && MTJFormEditorContributor.this.mtjFormEditor.canPasteFromClipboard());
        }
    }

    class RevertAction
    extends Action
    implements IUpdate {
        public void run() {
            if (MTJFormEditorContributor.this.mtjFormEditor != null) {
                MTJFormEditorContributor.this.mtjFormEditor.doRevert();
            }
        }

        public void update() {
            this.setEnabled(MTJFormEditorContributor.this.mtjFormEditor != null ? MTJFormEditorContributor.this.mtjFormEditor.isDirty() : false);
        }
    }

    class SaveAction
    extends Action
    implements IUpdate {
        public void run() {
            if (MTJFormEditorContributor.this.mtjFormEditor != null) {
                MTJUIPlugin.getActivePage().saveEditor((IEditorPart)MTJFormEditorContributor.this.mtjFormEditor, false);
            }
        }

        public void update() {
            this.setEnabled(MTJFormEditorContributor.this.mtjFormEditor != null ? MTJFormEditorContributor.this.mtjFormEditor.isDirty() : false);
        }
    }
}

