/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preferences;

import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.core.IMTJCoreConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.internal.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.preferences.MultiValuedTableFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ObfuscationPreferencePage
extends FieldEditorPreferencePage
implements IEmbeddableWorkbenchPreferencePage,
IMTJCoreConstants {
    public static final String ID = "org.eclipse.mtj.ui.preferences.ObfuscationPreferencePage";
    private boolean embeddedInProperties;
    private Button specifiedArgumentsButton;
    private Text specifiedArgumentsText;

    public ObfuscationPreferencePage() {
        this(false, MTJUIPlugin.getDefault().getCorePreferenceStore());
    }

    public ObfuscationPreferencePage(boolean bl, IPreferenceStore iPreferenceStore) {
        super(1);
        this.embeddedInProperties = bl;
        this.setPreferenceStore(iPreferenceStore);
        if (!bl) {
            this.setDescription(MTJUIMessages.ObfuscationPreferencePage_description);
        }
    }

    public void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        if (!this.embeddedInProperties) {
            this.addField((FieldEditor)new DirectoryFieldEditor("proguard_dir", MTJUIMessages.ObfuscationPreferencePage_proguard_root_directory, composite));
        }
        Font font = composite.getFont();
        this.specifiedArgumentsButton = new Button(composite, 32);
        this.specifiedArgumentsButton.setText(MTJUIMessages.ObfuscationPreferencePage_specified_arguments);
        this.specifiedArgumentsButton.setFont(font);
        this.specifiedArgumentsText = new Text(composite, 2052);
        this.specifiedArgumentsText.setFont(font);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.specifiedArgumentsText.setLayoutData((Object)gridData);
        this.specifiedArgumentsText.setEnabled(false);
        this.specifiedArgumentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ObfuscationPreferencePage.this.specifiedArgumentsText.setEnabled(ObfuscationPreferencePage.this.specifiedArgumentsButton.getSelection());
            }
        });
        this.addField(new MultiValuedTableFieldEditor("proguard_keep", MTJUIMessages.ObfuscationPreferencePage_proguard_keep_expressions, composite));
        this.addProguardNotes(composite, font);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void performApply() {
        super.performApply();
    }

    public void performDefaults() {
        super.performDefaults();
        this.setState(false, "-dontusemixedcaseclassnames -dontnote -defaultpackage ''");
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl = this.specifiedArgumentsButton.getSelection();
        iPreferenceStore.setValue("proguard_use_specified", bl);
        iPreferenceStore.setValue("proguard_options", this.specifiedArgumentsText.getText());
        return super.performOk();
    }

    private void addProguardNotes(Composite composite, Font font) {
        Label label = new Label(composite, 0);
        label.setFont(font);
        label.setText(MTJUIMessages.ObfuscationPreferencePage_proguard_note);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
    }

    private void setState(boolean bl, String string) {
        this.specifiedArgumentsButton.setSelection(bl);
        this.specifiedArgumentsText.setText(string);
        this.specifiedArgumentsText.setEnabled(bl);
    }

    protected Control createContents(Composite composite) {
        if (this.embeddedInProperties) {
            this.noDefaultAndApplyButton();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_ObfuscationPreferencePage");
        return super.createContents(composite);
    }

    protected void initialize() {
        super.initialize();
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.setState(iPreferenceStore.getBoolean("proguard_use_specified"), iPreferenceStore.getString("proguard_options"));
    }
}

