/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.projects;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.configuration.AddConfigEvent;
import org.eclipse.mtj.core.model.configuration.Configuration;
import org.eclipse.mtj.core.model.configuration.Configurations;
import org.eclipse.mtj.core.model.configuration.IConfigurationsChangeListener;
import org.eclipse.mtj.core.model.configuration.RemoveConfigEvent;
import org.eclipse.mtj.core.model.configuration.SwitchActiveConfigEvent;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.preprocessor.symbol.SymbolSetFactory;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.configurations.ConfigManageComponent;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.mtj.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;

public class NewMidletProjectWizardPageOne
extends WizardPage {
    private static final String PAGE_NAME = "NewJavaProjectWizardPageOne";
    private final ConfigurationGroup configurationGroup;
    private final JadNameGroup jadNameGroup;
    private Button preprocessedButton;
    private boolean preprocessingEnabled;
    private final LocationGroup projectLocationGroup;
    private final ProjectNameGroup projectNameGroup;
    private final Validator wizardPageValidator;

    public NewMidletProjectWizardPageOne() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(MTJUIMessages.NewMidletProjectWizardPageOne_title);
        this.setDescription(MTJUIMessages.NewMidletProjectWizardPageOne_description);
        this.projectNameGroup = new ProjectNameGroup();
        this.jadNameGroup = new JadNameGroup();
        this.projectLocationGroup = new LocationGroup();
        this.configurationGroup = new ConfigurationGroup();
        this.projectNameGroup.addObserver(this.projectLocationGroup);
        this.projectNameGroup.addObserver(this.jadNameGroup);
        this.projectNameGroup.notifyObservers();
        this.wizardPageValidator = new Validator();
        this.projectNameGroup.addObserver(this.wizardPageValidator);
        this.configurationGroup.addObserver(this.wizardPageValidator);
        this.projectLocationGroup.addObserver(this.wizardPageValidator);
        this.jadNameGroup.addObserver(this.wizardPageValidator);
        this.setProjectName("");
        this.setProjectLocationURI(null);
        JavaRuntime.getDefaultVMInstall();
    }

    protected Control createConfigGroupControl(Composite composite) {
        return this.configurationGroup.createControl(composite);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite2.setLayoutData((Object)new GridData(256));
        Control control = this.createNameControl(composite2);
        control.setLayoutData((Object)new GridData(768));
        Control control2 = this.createJadNameControl(composite2);
        control2.setLayoutData((Object)new GridData(768));
        Control control3 = this.createLocationControl(composite2);
        control3.setLayoutData((Object)new GridData(768));
        Control control4 = this.createConfigGroupControl(composite2);
        control4.setLayoutData((Object)new GridData(768));
        Control control5 = this.createPreprocessorGroupSelectionControl(composite2);
        control5.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite2);
    }

    protected Control createJadNameControl(Composite composite) {
        return this.jadNameGroup.createControl(composite);
    }

    protected Control createLocationControl(Composite composite) {
        return this.projectLocationGroup.createControl(composite);
    }

    protected Control createNameControl(Composite composite) {
        return this.projectNameGroup.createControl(composite);
    }

    protected Control createPreprocessorGroupSelectionControl(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(1808));
        group.setText(MTJUIMessages.NewMidletProjectWizardPageOne_preprocessorGroup);
        this.preprocessedButton = new Button((Composite)group, 32);
        this.preprocessedButton.setText(MTJUIMessages.NewMidletProjectWizardPageOne_preprocessor);
        this.preprocessedButton.setLayoutData((Object)new GridData(768));
        this.preprocessedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewMidletProjectWizardPageOne.this.preprocessingEnabled = NewMidletProjectWizardPageOne.this.preprocessedButton.getSelection();
            }
        });
        return group;
    }

    public void dispose() {
        super.dispose();
        this.configurationGroup.dispose();
    }

    public Configurations getConfigurations() {
        return this.configurationGroup.getConfigurations();
    }

    public IClasspathEntry[] getDefaultClasspathEntries() {
        Path path = new Path("org.elipse.mtj.JavaMEContainer/" + this.getSelectedDevice());
        return new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)path)};
    }

    public String getJadFileName() {
        return this.jadNameGroup.getJadFileName();
    }

    public IPath getOutputLocation() {
        IPath iPath = new Path(this.getProjectName()).makeAbsolute();
        Path path = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
        if (path.segmentCount() > 0) {
            iPath = iPath.append((IPath)path);
        }
        return iPath;
    }

    public URI getProjectLocationURI() {
        if (this.projectLocationGroup.isLocationInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.projectLocationGroup.getLocation());
    }

    public String getProjectName() {
        return this.projectNameGroup.getName();
    }

    public IDevice getSelectedDevice() {
        return this.configurationGroup.getSelectedDevice();
    }

    public IClasspathEntry[] getSourceClasspathEntries() {
        IPath iPath = new Path(this.getProjectName()).makeAbsolute();
        Path path = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
        if (path.segmentCount() > 0) {
            iPath = iPath.append((IPath)path);
        }
        return new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)iPath)};
    }

    public void init(IStructuredSelection iStructuredSelection, IWorkbenchPart iWorkbenchPart) {
    }

    private GridLayout initGridLayout(GridLayout gridLayout, boolean bl) {
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (bl) {
            gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
        }
        return gridLayout;
    }

    public boolean isPreprocessingEnabled() {
        return this.preprocessingEnabled;
    }

    protected void setControl(Control control) {
        Dialog.applyDialogFont((Control)control);
        super.setControl(control);
    }

    public void setProjectLocationURI(URI uRI) {
        IPath iPath = uRI != null ? URIUtil.toPath((URI)uRI) : null;
        this.projectLocationGroup.setLocation(iPath);
    }

    public void setProjectName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.projectNameGroup.setName(string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.projectNameGroup.postSetFocus();
        }
    }

    private final class ConfigurationGroup
    extends Observable {
        private ConfigManageComponent configManager;
        private IConfigurationsChangeListener configurationsChangeListener;

        private ConfigurationGroup() {
        }

        public Control createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            composite2.setLayout((Layout)NewMidletProjectWizardPageOne.this.initGridLayout(new GridLayout(1, false), false));
            this.configManager = new ConfigManageComponent();
            this.initConfigManager(composite2);
            this.configurationsChangeListener = new IConfigurationsChangeListener(){

                public void activeConfigSwitched(SwitchActiveConfigEvent switchActiveConfigEvent) {
                }

                public void configurationAdded(AddConfigEvent addConfigEvent) {
                    Configurations configurations = (Configurations)addConfigEvent.getSource();
                    if (configurations.size() == 1) {
                        ConfigurationGroup.this.fireEvent();
                    }
                }

                public void configurationRemoved(RemoveConfigEvent removeConfigEvent) {
                    Configurations configurations = (Configurations)removeConfigEvent.getSource();
                    if (configurations.isEmpty()) {
                        ConfigurationGroup.this.fireEvent();
                    }
                }
            };
            this.configManager.setConfigurationsChangeListener(this.configurationsChangeListener);
            return composite2;
        }

        private void initConfigManager(Composite composite) {
            this.configManager.setDescription(MTJUIMessages.ConfigurationSection_Description);
            this.configManager.createContents(composite);
            IDevice iDevice = DeviceRegistry.singleton.getDefaultDevice();
            if (iDevice == null) {
                return;
            }
            Configuration configuration = new Configuration(iDevice.getName());
            configuration.setDevice(iDevice);
            configuration.setSymbolSet(SymbolSetFactory.createSymbolSet((IDevice)iDevice));
            this.configManager.getConfigurations().add(configuration);
            this.configManager.getConfigurations().switchActiveConfiguration(configuration);
        }

        public void dispose() {
            this.configManager.dispose();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public Configurations getConfigurations() {
            return this.configManager.getConfigurations();
        }

        public IDevice getSelectedDevice() {
            return this.configManager.getActiveConfiguration().getDevice();
        }
    }

    private final class JadNameGroup
    extends Observable
    implements Observer,
    IDialogFieldListener {
        private String previousJadName;
        protected final StringDialogField jadFileNameField;
        protected final SelectionButtonDialogField projectBasedRadio = new SelectionButtonDialogField(16);
        protected final SelectionButtonDialogField userDefinedRadio;

        public JadNameGroup() {
            this.projectBasedRadio.setDialogFieldListener(this);
            this.projectBasedRadio.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_jadNameGroup_projectBasedRadio);
            this.userDefinedRadio = new SelectionButtonDialogField(16);
            this.userDefinedRadio.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_jadNameGroup_userDefinedRadio);
            this.jadFileNameField = new StringDialogField();
            this.jadFileNameField.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_jadFileNameField);
            this.jadFileNameField.setDialogFieldListener(this);
            this.userDefinedRadio.attachDialogField(this.jadFileNameField);
            this.projectBasedRadio.setSelection(true);
            this.userDefinedRadio.setSelection(false);
        }

        public Control createControl(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayout((Layout)NewMidletProjectWizardPageOne.this.initGridLayout(new GridLayout(2, false), true));
            group.setText(MTJUIMessages.NewMidletProjectWizardPageOne_jad_groupname);
            new Label((Composite)group, 0).setText(MTJUIMessages.NewMidletProjectWizardPageOne_jad_label);
            this.projectBasedRadio.doFillIntoGrid((Composite)group, 2);
            this.userDefinedRadio.doFillIntoGrid((Composite)group, 2);
            this.jadFileNameField.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.jadFileNameField.getTextControl(null));
            return group;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            if (dialogField == this.projectBasedRadio) {
                boolean bl = this.projectBasedRadio.isSelected();
                if (bl) {
                    this.previousJadName = this.jadFileNameField.getText();
                    this.jadFileNameField.setText(String.valueOf(NewMidletProjectWizardPageOne.this.projectNameGroup.getName()) + ".jad");
                } else {
                    this.jadFileNameField.setText(this.previousJadName);
                }
            }
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getJadFileName() {
            return this.jadFileNameField.getText();
        }

        public boolean isProjectBasedRadioSelected() {
            return this.projectBasedRadio.isSelected();
        }

        public void postSetFocus() {
            this.jadFileNameField.postSetFocusOnDialogField(NewMidletProjectWizardPageOne.this.getShell().getDisplay());
        }

        public void setJadFileName(String string) {
            this.jadFileNameField.setText(string);
        }

        public void update(Observable observable, Object object) {
            if (this.isProjectBasedRadioSelected()) {
                this.setJadFileName(String.valueOf(NewMidletProjectWizardPageOne.this.projectNameGroup.getName()) + ".jad");
            }
            this.fireEvent();
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.mtj.ui.last.external.project";
        private String fPreviousExternalLocation;
        protected final SelectionButtonDialogField externalLocationRadio;
        protected final StringButtonDialogField projectLocation;
        protected final SelectionButtonDialogField workspaceLocationRadio = new SelectionButtonDialogField(16);

        public LocationGroup() {
            this.workspaceLocationRadio.setDialogFieldListener(this);
            this.workspaceLocationRadio.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_workspaceLocationRadio);
            this.externalLocationRadio = new SelectionButtonDialogField(16);
            this.externalLocationRadio.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_externalLocationRadio);
            this.projectLocation = new StringButtonDialogField(this);
            this.projectLocation.setDialogFieldListener(this);
            this.projectLocation.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_projectLocation);
            this.projectLocation.setButtonLabel(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_browse_button);
            this.externalLocationRadio.attachDialogField(this.projectLocation);
            this.workspaceLocationRadio.setSelection(true);
            this.externalLocationRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
        }

        public void changeControlPressed(DialogField dialogField) {
            Object object;
            DirectoryDialog directoryDialog = new DirectoryDialog(NewMidletProjectWizardPageOne.this.getShell());
            directoryDialog.setMessage(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_changeControlPressed_dialogMessage);
            String string = this.projectLocation.getText().trim();
            if (string.length() == 0 && (object = MTJUIPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                string = object;
            }
            if (string.length() > 0 && ((File)(object = new File(string))).exists()) {
                directoryDialog.setFilterPath(string);
            }
            if ((object = directoryDialog.open()) != null) {
                this.projectLocation.setText((String)object);
                MTJUIPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, (String)object);
            }
        }

        public Control createControl(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayout((Layout)NewMidletProjectWizardPageOne.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(MTJUIMessages.NewMidletProjectWizardPageOne_locationGroup_contents);
            this.workspaceLocationRadio.doFillIntoGrid((Composite)group, 3);
            this.externalLocationRadio.doFillIntoGrid((Composite)group, 3);
            this.projectLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.projectLocation.getTextControl(null));
            return group;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            if (dialogField == this.workspaceLocationRadio) {
                boolean bl = this.workspaceLocationRadio.isSelected();
                if (bl) {
                    this.fPreviousExternalLocation = this.projectLocation.getText();
                    this.projectLocation.setText(this.getDefaultPath(NewMidletProjectWizardPageOne.this.projectNameGroup.getName()));
                } else {
                    this.projectLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String string) {
            IPath iPath = Platform.getLocation().append(string);
            return iPath.toOSString();
        }

        public IPath getLocation() {
            if (this.isWorkspaceRadioSelected()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.projectLocation.getText().trim());
        }

        public boolean isLocationInWorkspace() {
            String string = NewMidletProjectWizardPageOne.this.projectLocationGroup.getLocation().toOSString();
            IPath iPath = Path.fromOSString((String)string);
            return Platform.getLocation().isPrefixOf(iPath);
        }

        public boolean isWorkspaceRadioSelected() {
            return this.workspaceLocationRadio.isSelected();
        }

        public void setLocation(IPath iPath) {
            this.workspaceLocationRadio.setSelection(iPath == null);
            if (iPath != null) {
                this.projectLocation.setText(iPath.toOSString());
            } else {
                this.projectLocation.setText(this.getDefaultPath(NewMidletProjectWizardPageOne.this.projectNameGroup.getName()));
            }
            this.fireEvent();
        }

        public void update(Observable observable, Object object) {
            if (this.isWorkspaceRadioSelected()) {
                this.projectLocation.setText(this.getDefaultPath(NewMidletProjectWizardPageOne.this.projectNameGroup.getName()));
            }
            this.fireEvent();
        }
    }

    private final class ProjectNameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField projNameField = new StringDialogField();

        public ProjectNameGroup() {
            this.projNameField.setLabelText(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup);
            this.projNameField.setDialogFieldListener(this);
        }

        public Control createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            composite2.setLayout((Layout)NewMidletProjectWizardPageOne.this.initGridLayout(new GridLayout(2, false), false));
            this.projNameField.doFillIntoGrid(composite2, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.projNameField.getTextControl(null));
            return composite2;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.projNameField.getText().trim();
        }

        public void postSetFocus() {
            this.projNameField.postSetFocusOnDialogField(NewMidletProjectWizardPageOne.this.getShell().getDisplay());
        }

        public void setName(String string) {
            this.projNameField.setText(string);
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        private boolean canCreate(File file) {
            while (!file.exists()) {
                if ((file = file.getParentFile()) != null) continue;
                return false;
            }
            return file.canWrite();
        }

        private IStatus isValidConfigurations() {
            Status status = null;
            status = NewMidletProjectWizardPageOne.this.configurationGroup.getConfigurations().isEmpty() ? new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletProjectWizardPageOne_validate_devicecount_error) : new Status(0, "org.eclipse.mtj.ui", "");
            return status;
        }

        private IStatus isValidJadName(String string) {
            String string2 = string;
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            Status status = new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletProjectWizardPageOne_validate_jadname_error_emptyname);
            if (string2 != null && string2 != "" && (status = iWorkspace.validateName(string2, 1)).isOK()) {
                if (!string2.endsWith(".jad")) {
                    status = new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletProjectWizardPageOne_validate_jadname_error_extension);
                } else if (string2.equals(".jad")) {
                    status = new Status(4, "org.eclipse.mtj.ui", MTJUIMessages.NewMidletProjectWizardPageOne_validate_jadname_error_emptyname);
                }
            }
            return status;
        }

        public void update(Observable observable, Object object) {
            IStatus iStatus;
            String string;
            IWorkspace iWorkspace = MTJUIPlugin.getWorkspace();
            String string2 = NewMidletProjectWizardPageOne.this.projectNameGroup.getName();
            if (string2.length() == 0) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(null);
                NewMidletProjectWizardPageOne.this.setMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_emptyName);
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IStatus iStatus2 = iWorkspace.validateName(string2, 4);
            if (!iStatus2.isOK()) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(iStatus2.getMessage());
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IProject iProject = iWorkspace.getRoot().getProject(string2);
            if (iProject.exists()) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_alreadyExists);
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(string2);
            if (iPath.toFile().exists()) {
                try {
                    string = iPath.toFile().getCanonicalPath();
                    iPath = new Path(string);
                }
                catch (IOException iOException) {
                    MTJCorePlugin.log((int)4, (Throwable)iOException);
                }
                string = iPath.lastSegment();
                if (!string.equals(NewMidletProjectWizardPageOne.this.projectNameGroup.getName())) {
                    NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_alreadyExists);
                    NewMidletProjectWizardPageOne.this.setPageComplete(false);
                    return;
                }
            }
            if ((string = NewMidletProjectWizardPageOne.this.projectLocationGroup.getLocation().toOSString()).length() == 0) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(null);
                NewMidletProjectWizardPageOne.this.setMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_missingLocation);
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(string)) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_invalidDirectory);
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            IPath iPath2 = Path.fromOSString((String)string);
            if (NewMidletProjectWizardPageOne.this.projectLocationGroup.isWorkspaceRadioSelected()) {
                iPath2 = iPath2.append(NewMidletProjectWizardPageOne.this.projectNameGroup.getName());
            }
            if (iPath2.toFile().exists()) {
                if (Platform.getLocation().isPrefixOf(iPath2)) {
                    if (!Platform.getLocation().equals((Object)iPath2.removeLastSegments(1))) {
                        NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_workspace1);
                        NewMidletProjectWizardPageOne.this.setPageComplete(false);
                        return;
                    }
                    if (!iPath2.toFile().exists()) {
                        NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_workspace2);
                        NewMidletProjectWizardPageOne.this.setPageComplete(false);
                        return;
                    }
                }
            } else if (!NewMidletProjectWizardPageOne.this.projectLocationGroup.isWorkspaceRadioSelected()) {
                if (!this.canCreate(iPath2.toFile())) {
                    NewMidletProjectWizardPageOne.this.setErrorMessage(MTJUIMessages.NewMidletProjectWizardPageOne_projectNameGroup_update_error_failedCreateContents);
                    NewMidletProjectWizardPageOne.this.setPageComplete(false);
                    return;
                }
                iStatus = iWorkspace.validateProjectLocation(iProject, iPath2);
                if (!iStatus.isOK()) {
                    NewMidletProjectWizardPageOne.this.setErrorMessage(iStatus.getMessage());
                    NewMidletProjectWizardPageOne.this.setPageComplete(false);
                    return;
                }
            }
            if (!(iStatus = this.isValidJadName(NewMidletProjectWizardPageOne.this.jadNameGroup.getJadFileName())).isOK()) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(iStatus.getMessage());
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            iStatus = this.isValidConfigurations();
            if (!iStatus.isOK()) {
                NewMidletProjectWizardPageOne.this.setErrorMessage(iStatus.getMessage());
                NewMidletProjectWizardPageOne.this.setPageComplete(false);
                return;
            }
            NewMidletProjectWizardPageOne.this.setPageComplete(true);
            NewMidletProjectWizardPageOne.this.setErrorMessage(null);
            NewMidletProjectWizardPageOne.this.setMessage(null);
        }
    }
}

