/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.osgi.service.datalocation.Location;

public class Utils {
    private static final String PRIVATE_CONFIGURATION = "org.eclipse.debug.ui.private";
    private static final FileFilter DEFAULT_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return true;
        }
    };
    private static final byte[] buffer = new byte[1024];
    private static boolean caseSensitivityChecked;
    private static boolean caseSensitiveFileSystem;

    public static boolean arePathTargetsEqual(IPath iPath, IPath iPath2) throws CoreException {
        boolean bl = false;
        File file = Utils.getPathTargetFile(iPath);
        File file2 = Utils.getPathTargetFile(iPath2);
        if (file != null && file2 != null) {
            bl = file.equals(file2);
        }
        return bl;
    }

    public static void clearContainer(IContainer iContainer, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iContainer.exists()) {
            IResource[] iResourceArray = iContainer.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IResource iResource = iResourceArray[n];
                if (iResource instanceof IContainer) {
                    Utils.clearContainer((IContainer)iResource, iProgressMonitor);
                    iResource.delete(true, iProgressMonitor);
                } else {
                    iResource.delete(true, iProgressMonitor);
                }
                ++n;
            }
        }
    }

    public static void copy(File file, File file2) throws IOException {
        Utils.copy(file, file2, null);
    }

    public static void copy(File file, File file2, FileFilter fileFilter) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                Utils.copyDirectory(file, file2, fileFilter);
            } else {
                Utils.copyFile(file, file2, fileFilter);
            }
        }
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) throws IOException {
        if (fileFilter == null) {
            fileFilter = DEFAULT_FILTER;
        }
        if (file.exists() && file.isDirectory() && fileFilter.accept(file)) {
            file2.mkdirs();
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file3 = fileArray[n];
                File file4 = new File(file2, file3.getName());
                if (file3.isDirectory()) {
                    Utils.copyDirectory(file3, file4, fileFilter);
                } else {
                    Utils.copyFile(file3, file4, fileFilter);
                }
                ++n;
            }
        }
    }

    public static void copyFile(IFile iFile, IFile iFile2) throws IOException, CoreException {
        Utils.copyFile(iFile.getLocation().toFile(), iFile2.getLocation().toFile(), null);
    }

    public static void copyFile(File file, File file2, FileFilter fileFilter) throws IOException {
        if (fileFilter == null) {
            fileFilter = DEFAULT_FILTER;
        }
        if (fileFilter.accept(file)) {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            Utils.copyInputToOutput(fileInputStream, fileOutputStream);
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    public static void copyInputToOutput(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        do {
            if ((n = inputStream.read(buffer, 0, buffer.length)) <= 0) continue;
            outputStream.write(buffer, 0, n);
        } while (n != -1);
        outputStream.flush();
    }

    public static void createArchive(File file, File file2) throws IOException {
        if (file2.exists() && file2.isDirectory()) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            try {
                Utils.addFolderToArchive(zipOutputStream, file2.getAbsolutePath().length() + 1, file2);
            }
            catch (Throwable throwable) {
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    Utils.delete(fileArray[n]);
                    ++n;
                }
            }
            file.delete();
        }
    }

    public static void dumpCommandLine(ILaunch iLaunch) {
        IProcess iProcess;
        IProcess[] iProcessArray = iLaunch.getProcesses();
        if (iProcessArray != null && iProcessArray.length > 0 && (iProcess = iProcessArray[0]) != null) {
            String string = iProcess.getAttribute(IProcess.ATTR_CMDLINE);
            Utils.dumpCommandLine(string);
        }
    }

    public static void dumpCommandLine(String string) {
        String string2 = System.getProperty("mtj.dump.launch", "false");
        boolean bl = string2.equalsIgnoreCase("TRUE");
        if (bl) {
            String string3 = string == null ? "Command line not found" : "Command line: " + string;
            MTJCorePlugin.log(1, string3);
        }
    }

    public static void dumpCommandLine(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (n != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            ++n;
        }
        Utils.dumpCommandLine(stringBuffer.toString());
    }

    public static Process exec(String[] stringArray, File file, String[] stringArray2) throws CoreException {
        return DebugPlugin.exec((String[])stringArray, (File)file, (String[])stringArray2);
    }

    public static boolean executableExists(File file) {
        File file2 = new File(file.getParentFile(), String.valueOf(file.getName()) + ".exe");
        return file.exists() || file2.exists();
    }

    public static void extractArchive(File file, File file2) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        try {
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file3;
                if (zipEntry.isDirectory()) {
                    file3 = new File(file2, zipEntry.getName());
                    file3.mkdirs();
                    continue;
                }
                file3 = new File(file2, zipEntry.getName());
                file3.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                try {
                    Utils.copyInputToOutput(zipInputStream, fileOutputStream);
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fileOutputStream == null) continue;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipInputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static String extractClassName(IJavaProject iJavaProject, IResource iResource) throws JavaModelException {
        IPath iPath = Utils.extractsSourceFolderRelativePath(iJavaProject, iResource);
        return iPath == null ? null : iPath.removeFileExtension().toString().replace('/', '.');
    }

    public static IPath extractsSourceFolderRelativePath(IJavaProject iJavaProject, IResource iResource) throws JavaModelException {
        IPath iPath = null;
        IPath iPath2 = iJavaProject.getOutputLocation().makeAbsolute();
        IPath iPath3 = iResource.getFullPath();
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            if (iClasspathEntry.getEntryKind() == 3) {
                IPath iPath4 = iClasspathEntry.getOutputLocation();
                IPath iPath5 = iPath4 = iPath4 == null ? iPath2 : iPath4.makeAbsolute();
                if (iPath4.isPrefixOf(iPath3)) {
                    iPath = iPath3.removeFirstSegments(iPath4.segmentCount());
                }
            }
            ++n;
        }
        return iPath;
    }

    public static IClasspathAttribute getJavadocAttribute(IClasspathEntry iClasspathEntry) {
        int n = Utils.getJavadocAttributeIndex(iClasspathEntry);
        return n == -1 ? null : iClasspathEntry.getExtraAttributes()[n];
    }

    public static int getJavadocAttributeIndex(IClasspathEntry iClasspathEntry) {
        int n = -1;
        IClasspathAttribute[] iClasspathAttributeArray = iClasspathEntry.getExtraAttributes();
        int n2 = 0;
        while (n2 < iClasspathAttributeArray.length) {
            IClasspathAttribute iClasspathAttribute = iClasspathAttributeArray[n2];
            if (iClasspathAttribute.getName().equals("javadoc_location")) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public static ILaunch getNewLaunch(String string) throws CoreException {
        return new Launch(Utils.getNewLaunchConfiguration(string), "run", null);
    }

    public static ILaunchConfiguration getNewLaunchConfiguration(String string) throws CoreException {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
        iLaunchConfigurationWorkingCopy.setAttribute(PRIVATE_CONFIGURATION, true);
        return iLaunchConfigurationWorkingCopy;
    }

    public static Object getPathTarget(IPath iPath) {
        Object object = null;
        IWorkspaceRoot iWorkspaceRoot = MTJCorePlugin.getWorkspace().getRoot();
        object = iWorkspaceRoot.findMember(iPath);
        if (object == null) {
            File file = new File(iPath.toOSString());
            object = file != null && file.isFile() ? file : null;
        }
        return object;
    }

    public static File getPathTargetFile(IPath iPath) throws CoreException {
        File file = null;
        Object object = Utils.getPathTarget(iPath);
        if (object instanceof IResource) {
            file = ((IResource)object).getLocation().toFile();
        } else if (object instanceof File) {
            file = (File)object;
        }
        return file;
    }

    public static String getQualifiedClassName(IType iType) {
        String string = null;
        string = iType instanceof BinaryType ? Utils.getQualifiedClassName((BinaryType)iType) : iType.getFullyQualifiedName();
        return string;
    }

    public static Object getResolvedClasspathEntry(IClasspathEntry iClasspathEntry) {
        IClasspathEntry iClasspathEntry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
        return Utils.getPathTarget(iClasspathEntry2.getPath());
    }

    public static final File getResolvedClasspathEntryFile(IClasspathEntry iClasspathEntry) throws CoreException {
        IClasspathEntry iClasspathEntry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
        return Utils.getPathTargetFile(iClasspathEntry2.getPath());
    }

    public static String getStandardOutput(String string, String[] stringArray) throws CoreException {
        return Utils.getStandardOutput(string, stringArray, null);
    }

    public static String getStandardOutput(String string, String[] stringArray, File file) throws CoreException {
        IProcess iProcess = Utils.launchApplication(stringArray, file, null, string, string);
        IStreamsProxy iStreamsProxy = iProcess.getStreamsProxy();
        while (!iProcess.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return iStreamsProxy.getOutputStreamMonitor().getContents();
    }

    public static int getProcessOutput(String string, String[] stringArray, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws CoreException {
        IProcess iProcess = Utils.launchApplication(stringArray, null, null, string, string);
        IStreamsProxy iStreamsProxy = iProcess.getStreamsProxy();
        iStreamsProxy.getOutputStreamMonitor().addListener((IStreamListener)new StreamListener(stringBuffer));
        iStreamsProxy.getErrorStreamMonitor().addListener((IStreamListener)new StreamListener(stringBuffer2));
        while (!iProcess.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return iProcess.getExitValue();
    }

    public static boolean isFileSystemCaseSensitive() {
        if (!caseSensitivityChecked) {
            String string;
            URL uRL;
            caseSensitivityChecked = true;
            Location location = Platform.getInstallLocation();
            if (location != null && (uRL = location.getURL()) != null && (string = uRL.toString()).startsWith("file:/")) {
                caseSensitiveFileSystem = !new File(string = string.substring("file:/".length()).toUpperCase()).exists();
            }
        }
        return caseSensitiveFileSystem;
    }

    public static boolean isMidlet(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        boolean bl = false;
        if (iType != null) {
            IJavaProject iJavaProject = iType.getJavaProject();
            if (!iType.exists() && iType.isBinary()) {
                String string = Utils.getQualifiedClassName(iType);
                if (string != null) {
                    IType iType2 = iJavaProject.findType(string);
                    bl = Utils.isMidlet(iType2, iProgressMonitor);
                }
            } else {
                ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(iProgressMonitor);
                IType iType3 = iJavaProject.findType("javax.microedition.midlet.MIDlet");
                bl = iType3 != null && iTypeHierarchy.contains(iType3);
            }
        }
        return bl;
    }

    public static IProcess launchApplication(String[] stringArray, File file, String[] stringArray2, String string, String string2) throws CoreException {
        Process process = Utils.exec(stringArray, file, stringArray2);
        Launch launch = new Launch(Utils.getNewLaunchConfiguration(string), "run", null);
        IProcess iProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)string2);
        Utils.dumpCommandLine(stringArray);
        return iProcess;
    }

    private static void addFolderToArchive(ZipOutputStream zipOutputStream, int n, File file) throws IOException {
        File[] fileArray = file.listFiles();
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                Utils.addFolderToArchive(zipOutputStream, n, file2);
            } else {
                Utils.addFileEntryToArchive(zipOutputStream, n, file2);
            }
            ++n2;
        }
    }

    private static void addFileEntryToArchive(ZipOutputStream zipOutputStream, int n, File file) throws IOException {
        ZipEntry zipEntry = Utils.getEntryForFile(file, n);
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Utils.copyInputToOutput(fileInputStream, zipOutputStream);
        }
        catch (Throwable throwable) {
            zipOutputStream.closeEntry();
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        zipOutputStream.closeEntry();
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static ZipEntry getEntryForFile(File file, int n) {
        String string = file.getAbsolutePath();
        String string2 = string.substring(n).replace('\\', '/');
        ZipEntry zipEntry = new ZipEntry(string2);
        zipEntry.setSize(file.length());
        zipEntry.setTime(file.lastModified());
        return zipEntry;
    }

    private Utils() {
    }

    private static String getQualifiedClassName(BinaryType binaryType) {
        IPackageFragment iPackageFragment = binaryType.getPackageFragment();
        StringBuffer stringBuffer = new StringBuffer(binaryType.getElementName());
        while (iPackageFragment.getElementType() != 2) {
            String string = iPackageFragment.getElementName();
            if (string != null && string.length() > 0) {
                stringBuffer.insert(0, '.').insert(0, string);
            }
            iPackageFragment = iPackageFragment.getParent();
        }
        return stringBuffer.toString();
    }

    private static class StreamListener
    implements IStreamListener {
        private StringBuffer buf;

        public StreamListener(StringBuffer stringBuffer) {
            this.buf = stringBuffer;
        }

        public void streamAppended(String string, IStreamMonitor iStreamMonitor) {
            if (this.buf != null) {
                this.buf.append(string);
            }
        }
    }
}

