/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.preverifier;

import org.eclipse.mtj.preverifier.results.IClassErrorInformation;
import org.eclipse.mtj.preverifier.results.IFieldErrorInformation;
import org.eclipse.mtj.preverifier.results.IMethodErrorInformation;
import org.eclipse.mtj.preverifier.results.PreverificationError;
import org.eclipse.mtj.preverifier.results.PreverificationErrorType;

public class PreverificationUtils {
    public static String getErrorText(PreverificationError preverificationError) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = preverificationError.getDetail();
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        } else {
            PreverificationUtils.appendErrorInformation(stringBuffer, preverificationError);
        }
        return stringBuffer.toString();
    }

    private static void appendErrorInformation(StringBuffer stringBuffer, PreverificationError preverificationError) {
        PreverificationUtils.appendErrorTypeInformation(stringBuffer, preverificationError);
        if (preverificationError.getType() != PreverificationErrorType.FINALIZERS) {
            PreverificationUtils.appendErrorLocationInformation(stringBuffer, preverificationError);
        }
    }

    private static void appendErrorLocationInformation(StringBuffer stringBuffer, PreverificationError preverificationError) {
        IClassErrorInformation iClassErrorInformation = preverificationError.getLocation().getClassInformation();
        IMethodErrorInformation iMethodErrorInformation = preverificationError.getLocation().getMethodInformation();
        IFieldErrorInformation iFieldErrorInformation = preverificationError.getLocation().getFieldInformation();
        switch (preverificationError.getLocation().getLocationType().getTypeCode()) {
            case 0: {
                stringBuffer.append(" in class ").append(iClassErrorInformation.getName()).append(" or superclass");
                break;
            }
            case 1: {
                stringBuffer.append(" for class field ").append(iFieldErrorInformation.getName());
                break;
            }
            case 2: {
                stringBuffer.append(" in method declaration for ").append(iMethodErrorInformation.getName());
                break;
            }
            case 3: {
                stringBuffer.append(" in method ").append(iMethodErrorInformation.getName()).append(" of class ").append(iClassErrorInformation.getName());
                break;
            }
            case 4: {
                stringBuffer.append(" in method definition for ").append(iMethodErrorInformation.getName());
            }
        }
    }

    private static void appendErrorTypeInformation(StringBuffer stringBuffer, PreverificationError preverificationError) {
        switch (preverificationError.getType().getErrorCode()) {
            case 3: {
                stringBuffer.append("Finalizers not allowed");
                break;
            }
            case 2: {
                stringBuffer.append("Floating point not allowed");
                break;
            }
            case 4: {
                stringBuffer.append("Missing type");
                break;
            }
            case 1: {
                stringBuffer.append("Native method implementations not allowed");
                break;
            }
            case 5: {
                stringBuffer.append("Unknown error during preverification");
            }
        }
    }

    private PreverificationUtils() {
    }
}

