/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.device.preprocess;

import java.util.Map;
import java.util.Properties;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;

public class DeviceSymbolDefinitionSetFactory {
    public static SymbolDefinitionSet createSymbolDefinitionSet(IDevice iDevice) {
        String string;
        String string2;
        ILibrary[] iLibraryArray;
        SymbolDefinitionSet symbolDefinitionSet = new SymbolDefinitionSet(iDevice.getName());
        symbolDefinitionSet.define(iDevice.getName().toUpperCase().replace(' ', '_'));
        Properties properties = iDevice.getDeviceProperties();
        if (properties != null) {
            iLibraryArray = properties.entrySet().iterator();
            while (iLibraryArray.hasNext()) {
                Map.Entry entry = (Map.Entry)iLibraryArray.next();
                try {
                    string2 = entry.getKey().toString().toUpperCase().replace(' ', '_');
                    string = entry.getValue().toString();
                    symbolDefinitionSet.define(string2, string);
                }
                catch (RuntimeException runtimeException) {
                    MTJCorePlugin.log(4, runtimeException);
                }
            }
        }
        if ((iLibraryArray = iDevice.getClasspath().getEntries()) != null) {
            int n = 0;
            while (n < iLibraryArray.length) {
                try {
                    string2 = iLibraryArray[n].getAPIs()[0].getIdentifier().replace(' ', '_');
                    string = iLibraryArray[n].getAPIs()[0].getVersion().toString();
                    symbolDefinitionSet.define(string2, string);
                }
                catch (RuntimeException runtimeException) {
                    MTJCorePlugin.log(4, runtimeException);
                }
                ++n;
            }
        }
        return symbolDefinitionSet;
    }
}

