/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.preprocessor.ISymbolDefinitionSetChangeListener;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSetRegistry;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.ui.viewers.TableViewerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SymbolDefinitionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo("Symbol", 50.0f, null), new TableColumnInfo("Value", 50.0f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 650;
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String PROP_SYMBOL = "symbol";
    private static final String PROP_VALUE = "value";
    private static final String[] PROPERTIES = new String[]{"symbol", "value"};
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile(".*\\s+.*");
    private Button addSetButton;
    private Button addSymbolButton;
    private ArrayList<SymbolDefinition> currentDefinitions;
    private ComboViewer definitionsComboViewer;
    private Button removeSetButton;
    private Button removeSymbolButton;
    private Group symbolsGroup;
    private TableViewer tableViewer;
    private IWorkbench workbench;
    private SymbolDefinitionSet[] definitionSetsinput = null;

    public void commitSymbolDefinitions() {
        this.commitSymbolDefinitions(this.getSelectedSymbolDefinitionSet());
    }

    public void init(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
        this.noDefaultAndApplyButton();
    }

    public boolean performCancel() {
        return this.reloadSymbolDefinitionsRegistry() && super.performCancel();
    }

    public boolean performOk() {
        boolean bl = false;
        this.commitSymbolDefinitions();
        try {
            SymbolDefinitionSetRegistry.singleton.store();
            bl = true;
        }
        catch (PersistenceException persistenceException) {
            this.handleException("Error storing symbol definitions", persistenceException);
        }
        catch (TransformerException transformerException) {
            this.handleException("Error storing symbol definitions", transformerException);
        }
        catch (IOException iOException) {
            this.handleException("Error storing symbol definitions", iOException);
        }
        return bl && super.performOk();
    }

    private void commitSymbolDefinitions(SymbolDefinitionSet symbolDefinitionSet) {
        if (symbolDefinitionSet != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.currentDefinitions.size());
            for (SymbolDefinition symbolDefinition : this.currentDefinitions) {
                hashMap.put(symbolDefinition.name, symbolDefinition.value);
            }
            symbolDefinitionSet.setDefinitions(hashMap);
        }
    }

    private TableViewer createTableViewer(Composite composite) {
        int n = 68100;
        Table table = new Table(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new SymbolDefinitionLabelProvider());
        tableViewer.setSorter(new ViewerSorter());
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SymbolDefinitionsPreferencePage.this.updateButtonEnablement();
            }
        });
        IDialogSettings iDialogSettings = MTJUIPlugin.getDialogSettings("symbolDefsViewerSettings");
        TableViewerConfiguration tableViewerConfiguration = new TableViewerConfiguration(iDialogSettings, 650, COLUMN_INFO, 0);
        tableViewerConfiguration.configure(tableViewer);
        tableViewer.setCellModifier((ICellModifier)new CellModifier());
        tableViewer.setColumnProperties(PROPERTIES);
        tableViewer.setCellEditors(new CellEditor[]{new SymbolNameCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        return tableViewer;
    }

    private SymbolDefinition getSelectedSymbolDefinition() {
        SymbolDefinition symbolDefinition = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
        if (iStructuredSelection != null) {
            symbolDefinition = (SymbolDefinition)iStructuredSelection.getFirstElement();
        }
        return symbolDefinition;
    }

    private SymbolDefinitionSet getSelectedSymbolDefinitionSet() {
        SymbolDefinitionSet symbolDefinitionSet = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.definitionsComboViewer.getSelection();
        symbolDefinitionSet = iStructuredSelection.size() == 0 ? null : (SymbolDefinitionSet)iStructuredSelection.getFirstElement();
        return symbolDefinitionSet;
    }

    private void handleAddSetButton() {
        try {
            String string = this.definitionsComboViewer.getCombo().getText();
            SymbolDefinitionSet symbolDefinitionSet = SymbolDefinitionSetRegistry.singleton.addNewDefinitionSet(string);
            this.definitionsComboViewer.refresh();
            this.definitionsComboViewer.setSelection((ISelection)new StructuredSelection((Object)symbolDefinitionSet));
            this.tableViewer.setInput((Object)symbolDefinitionSet);
        }
        catch (PersistenceException persistenceException) {
            this.handleException("Error adding new definition set", persistenceException);
        }
    }

    private void handleAddSymbolButton() {
        String string = "NewSymbol";
        SymbolDefinition symbolDefinition = null;
        int n = 1;
        while (n < 100) {
            string = "NewSymbol" + n;
            symbolDefinition = new SymbolDefinition(string, "true");
            if (!this.currentDefinitions.contains(symbolDefinition)) {
                this.currentDefinitions.add(symbolDefinition);
                break;
            }
            ++n;
        }
        this.tableViewer.refresh();
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            if (symbolDefinition.equals(tableItemArray[n2].getData())) break;
            ++n2;
        }
        this.tableViewer.getTable().select(n2);
        this.tableViewer.getTable().forceFocus();
    }

    private void handleException(String string, Throwable throwable) {
        MTJCorePlugin.log((int)2, (String)string, (Throwable)throwable);
        MessageDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)"Error Occured", (String)string);
    }

    private void handleRemoveSetButton() {
        SymbolDefinitionSet symbolDefinitionSet = this.getSelectedSymbolDefinitionSet();
        if (symbolDefinitionSet != null) {
            SymbolDefinitionSetRegistry symbolDefinitionSetRegistry = SymbolDefinitionSetRegistry.singleton;
            symbolDefinitionSetRegistry.removeDefinitionSet(symbolDefinitionSet);
            this.definitionsComboViewer.refresh();
            this.tableViewer.refresh();
        }
    }

    private void handleRemoveSymbolButton() {
        TableItem[] tableItemArray;
        Table table = this.tableViewer.getTable();
        TableItem[] tableItemArray2 = tableItemArray = table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray2[n2];
            this.currentDefinitions.remove(tableItem.getData());
            ++n2;
        }
        this.tableViewer.refresh();
    }

    private void initializeDefinitionsCombo() {
        Object object = new Object();
        this.definitionsComboViewer.setInput(object);
        IStructuredContentProvider iStructuredContentProvider = (IStructuredContentProvider)this.definitionsComboViewer.getContentProvider();
        Object[] objectArray = iStructuredContentProvider.getElements(object);
        if (objectArray != null && objectArray.length > 0) {
            this.definitionsComboViewer.setSelection((ISelection)new StructuredSelection(objectArray[0]), true);
        }
    }

    private boolean isValidSetName(String string) {
        boolean bl = string != null && string.trim().length() > 0;
        int n = 0;
        while (bl && n < string.length()) {
            char c = string.charAt(n);
            bl = c == ' ' || Character.isLetterOrDigit(c);
            ++n;
        }
        return bl;
    }

    private boolean isValidSymbol(String string) {
        boolean bl = false;
        if (string != null) {
            Matcher matcher = WHITESPACE_PATTERN.matcher(string);
            bl = !matcher.matches();
        }
        return bl;
    }

    private boolean reloadSymbolDefinitionsRegistry() {
        boolean bl = true;
        try {
            SymbolDefinitionSetRegistry.singleton.load();
        }
        catch (PersistenceException persistenceException) {
            bl = false;
            this.handleException("Error reloading symbol definitions", persistenceException);
        }
        return bl;
    }

    private void updateButtonEnablement() {
        String string = this.definitionsComboViewer.getCombo().getText();
        SymbolDefinitionSet symbolDefinitionSet = null;
        try {
            symbolDefinitionSet = SymbolDefinitionSetRegistry.singleton.getSymbolDefinitionSet(string);
        }
        catch (PersistenceException persistenceException) {}
        SymbolDefinitionSet symbolDefinitionSet2 = this.getSelectedSymbolDefinitionSet();
        this.addSetButton.setEnabled(this.isValidSetName(string) && symbolDefinitionSet2 == null && symbolDefinitionSet == null);
        this.removeSetButton.setEnabled(symbolDefinitionSet2 != null);
        SymbolDefinition symbolDefinition = this.getSelectedSymbolDefinition();
        this.addSymbolButton.setEnabled(symbolDefinitionSet2 != null);
        this.removeSymbolButton.setEnabled(symbolDefinition != null);
    }

    protected Control createContents(Composite composite) {
        try {
            this.definitionSetsinput = SymbolDefinitionSetRegistry.singleton.getAllSetDefinitions();
        }
        catch (PersistenceException persistenceException) {
            this.handleException("Error retrieving symbol definitions", persistenceException);
        }
        SymbolDefinitionSetRegistry.singleton.addSymbolDefinitionSetChangeListener(new ISymbolDefinitionSetChangeListener(){

            public void symbolDefinitionSetChanged() {
                try {
                    SymbolDefinitionsPreferencePage.this.definitionSetsinput = SymbolDefinitionSetRegistry.singleton.getAllSetDefinitions();
                    if (SymbolDefinitionsPreferencePage.this.definitionsComboViewer != null && !SymbolDefinitionsPreferencePage.this.definitionsComboViewer.getControl().isDisposed()) {
                        SymbolDefinitionsPreferencePage.this.definitionsComboViewer.refresh();
                    }
                }
                catch (PersistenceException persistenceException) {
                    SymbolDefinitionsPreferencePage.this.handleException("Error retrieving symbol definitions", persistenceException);
                }
            }
        });
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(3, false));
        composite3.setLayoutData((Object)new GridData(768));
        new Label(composite3, 0).setText("Definition Set: ");
        this.definitionsComboViewer = new ComboViewer(composite3, 4);
        this.definitionsComboViewer.setContentProvider((IContentProvider)new DefinitionSetsContentProvider());
        this.definitionsComboViewer.setInput((Object)this.definitionSetsinput);
        this.definitionsComboViewer.setLabelProvider((IBaseLabelProvider)new DefinitionSetLabelProvider());
        this.definitionsComboViewer.setSorter(new ViewerSorter());
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 0x1000000;
        this.definitionsComboViewer.getCombo().setLayoutData((Object)gridData);
        this.definitionsComboViewer.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SymbolDefinitionsPreferencePage.this.updateButtonEnablement();
            }
        });
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayout((Layout)new GridLayout(1, true));
        this.addSetButton = new Button(composite4, 8);
        this.addSetButton.setText("Add");
        this.addSetButton.setLayoutData((Object)new GridData(768));
        this.addSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SymbolDefinitionsPreferencePage.this.handleAddSetButton();
            }
        });
        this.removeSetButton = new Button(composite4, 8);
        this.removeSetButton.setText("Remove");
        this.removeSetButton.setLayoutData((Object)new GridData(768));
        this.removeSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SymbolDefinitionsPreferencePage.this.handleRemoveSetButton();
            }
        });
        this.symbolsGroup = new Group(composite2, 4);
        this.symbolsGroup.setLayout((Layout)new GridLayout(2, false));
        this.symbolsGroup.setLayoutData((Object)new GridData(1808));
        GridData gridData2 = new GridData(1808);
        gridData2.minimumWidth = 400;
        gridData2.heightHint = 300;
        this.tableViewer = this.createTableViewer((Composite)this.symbolsGroup);
        this.tableViewer.getTable().setLayoutData((Object)gridData2);
        Composite composite5 = new Composite((Composite)this.symbolsGroup, 0);
        composite5.setLayout((Layout)new GridLayout(1, true));
        this.addSymbolButton = new Button(composite5, 8);
        this.addSymbolButton.setText("Add");
        this.addSymbolButton.setLayoutData((Object)new GridData(768));
        this.addSymbolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SymbolDefinitionsPreferencePage.this.handleAddSymbolButton();
            }
        });
        this.removeSymbolButton = new Button(composite5, 8);
        this.removeSymbolButton.setText("Remove");
        this.removeSymbolButton.setLayoutData((Object)new GridData(768));
        this.removeSymbolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SymbolDefinitionsPreferencePage.this.handleRemoveSymbolButton();
            }
        });
        this.definitionsComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SymbolDefinitionsPreferencePage.this.updateButtonEnablement();
                SymbolDefinitionSet symbolDefinitionSet = SymbolDefinitionsPreferencePage.this.getSelectedSymbolDefinitionSet();
                SymbolDefinitionsPreferencePage.this.tableViewer.setInput((Object)symbolDefinitionSet);
            }
        });
        this.initializeDefinitionsCombo();
        return composite2;
    }

    protected void performDefaults() {
        this.reloadSymbolDefinitionsRegistry();
        this.initializeDefinitionsCombo();
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            String string2 = null;
            SymbolDefinition symbolDefinition = (SymbolDefinition)object;
            string2 = string.equals(SymbolDefinitionsPreferencePage.PROP_SYMBOL) ? symbolDefinition.name : symbolDefinition.value;
            return string2;
        }

        public void modify(Object object, String string, Object object2) {
            TableItem tableItem = (TableItem)object;
            String string2 = tableItem.getText(0);
            String string3 = tableItem.getText(1);
            int n = this.findSymbolDefinition(string2);
            if (n != -1) {
                if (string.equals(SymbolDefinitionsPreferencePage.PROP_SYMBOL)) {
                    String string4 = (String)object2;
                    if (SymbolDefinitionsPreferencePage.this.isValidSymbol(string4)) {
                        SymbolDefinitionsPreferencePage.this.currentDefinitions.set(n, new SymbolDefinition(string4, string3));
                    }
                } else {
                    SymbolDefinition symbolDefinition = (SymbolDefinition)SymbolDefinitionsPreferencePage.this.currentDefinitions.get(n);
                    symbolDefinition.value = (String)object2;
                }
                SymbolDefinitionsPreferencePage.this.tableViewer.refresh();
            }
            SymbolDefinitionsPreferencePage.this.setErrorMessage(null);
        }

        private int findSymbolDefinition(String string) {
            int n = -1;
            int n2 = 0;
            while (n2 < SymbolDefinitionsPreferencePage.this.currentDefinitions.size()) {
                SymbolDefinition symbolDefinition = (SymbolDefinition)SymbolDefinitionsPreferencePage.this.currentDefinitions.get(n2);
                if (symbolDefinition.name.equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            return n;
        }
    }

    private static class DefinitionSetLabelProvider
    extends LabelProvider {
        private DefinitionSetLabelProvider() {
        }

        public String getText(Object object) {
            return ((SymbolDefinitionSet)object).getName();
        }
    }

    private class DefinitionSetsContentProvider
    implements IStructuredContentProvider {
        private DefinitionSetsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = NO_ELEMENTS;
            if (SymbolDefinitionsPreferencePage.this.definitionSetsinput != null) {
                objectArray = SymbolDefinitionsPreferencePage.this.definitionSetsinput;
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SymbolDefinition {
        String name;
        String value;

        public SymbolDefinition(Map.Entry<String, String> entry) {
            this(entry.getKey(), entry.getValue());
        }

        public SymbolDefinition(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof SymbolDefinition) {
                SymbolDefinition symbolDefinition = (SymbolDefinition)object;
                return symbolDefinition.name.equals(this.name);
            }
            return false;
        }
    }

    private static class SymbolDefinitionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SymbolDefinitionLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            String string = "";
            SymbolDefinition symbolDefinition = (SymbolDefinition)object;
            switch (n) {
                case 0: {
                    string = symbolDefinition.name;
                    break;
                }
                case 1: {
                    string = symbolDefinition.value;
                }
            }
            return string;
        }
    }

    private class SymbolNameCellEditor
    extends TextCellEditor {
        public SymbolNameCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new SymbolNameCellEditorValidator());
            this.addListener(new ICellEditorListener(){

                public void applyEditorValue() {
                }

                public void cancelEditor() {
                }

                public void editorValueChanged(boolean bl, boolean bl2) {
                    if (!bl2) {
                        SymbolNameCellEditor.this.setErrorMessage(SymbolNameCellEditor.this.getErrorMessage());
                    } else {
                        SymbolNameCellEditor.this.setErrorMessage(null);
                    }
                }
            });
        }
    }

    private class SymbolNameCellEditorValidator
    implements ICellEditorValidator {
        private SymbolNameCellEditorValidator() {
        }

        public String isValid(Object object) {
            String string = (String)object;
            return SymbolDefinitionsPreferencePage.this.isValidSymbol(string) ? null : "Whitespace not allowed in symbol names.";
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return SymbolDefinitionsPreferencePage.this.currentDefinitions.toArray(new Object[SymbolDefinitionsPreferencePage.this.currentDefinitions.size()]);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            SymbolDefinitionSet symbolDefinitionSet;
            Map map;
            if (object != null) {
                SymbolDefinitionsPreferencePage.this.commitSymbolDefinitions((SymbolDefinitionSet)object);
            }
            if (SymbolDefinitionsPreferencePage.this.currentDefinitions == null) {
                SymbolDefinitionsPreferencePage.this.currentDefinitions = new ArrayList();
            } else {
                SymbolDefinitionsPreferencePage.this.currentDefinitions.clear();
            }
            if (object2 instanceof SymbolDefinitionSet && (map = (symbolDefinitionSet = (SymbolDefinitionSet)object2).getDefinedSymbols()) != null) {
                SymbolDefinitionsPreferencePage.this.symbolsGroup.setText("Symbols in set \"" + symbolDefinitionSet.getName() + "\"");
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    SymbolDefinitionsPreferencePage.this.currentDefinitions.add(new SymbolDefinition(entry));
                }
            }
        }
    }
}

