/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.editors.jad;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.editors.FormLayoutFactory;
import org.eclipse.mtj.ui.internal.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.ui.internal.utils.ManifestPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class AbstractJADEditorPage
extends FormPage
implements IHyperlinkListener {
    private boolean dirty;
    private JADFormEditor editor;
    private IJavaProject javaProject;
    IMessageManager errorMessageManager;

    public AbstractJADEditorPage(JADFormEditor jADFormEditor, String string, String string2) {
        super((FormEditor)jADFormEditor, string, string2);
        this.editor = jADFormEditor;
        this.javaProject = JavaCore.create((IProject)jADFormEditor.getJadFile().getProject());
    }

    public AbstractJADEditorPage(String string) {
        this(string, string);
    }

    public AbstractJADEditorPage(String string, String string2) {
        super(string, string2);
    }

    public void dispose() {
        super.dispose();
    }

    public void doSaveAs() {
    }

    public void editorDirtyStateChanged() {
        this.editor.editorDirtyStateChanged();
    }

    public abstract void editorInputChanged();

    public IMessageManager getErrorMessageManager() {
        return this.errorMessageManager;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public abstract String getTitle();

    public void initialize(FormEditor formEditor) {
        super.initialize(formEditor);
        this.editor = (JADFormEditor)formEditor;
        this.javaProject = JavaCore.create((IProject)this.editor.getJadFile().getProject());
    }

    public boolean isDirty() {
        return this.dirty || this.getPreferenceStore().needsSaving() || super.isDirty();
    }

    public abstract boolean isManagingProperty(String var1);

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void linkActivated(HyperlinkEvent hyperlinkEvent) {
    }

    public void linkEntered(HyperlinkEvent hyperlinkEvent) {
        IStatusLineManager iStatusLineManager = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        iStatusLineManager.setMessage(hyperlinkEvent.getLabel());
    }

    public void linkExited(HyperlinkEvent hyperlinkEvent) {
        IStatusLineManager iStatusLineManager = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        iStatusLineManager.setMessage(null);
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.editorDirtyStateChanged();
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        super.setInitializationData(iConfigurationElement, string, object);
    }

    private String createFormTextContent(IMessage[] iMessageArray) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<form>");
        int n = 0;
        while (n < iMessageArray.length) {
            IMessage iMessage = iMessageArray[n];
            printWriter.print("<li vspace=\"false\" style=\"image\" indent=\"16\" value=\"");
            switch (iMessage.getMessageType()) {
                case 3: {
                    printWriter.print("error");
                    break;
                }
                case 2: {
                    printWriter.print("warning");
                    break;
                }
                case 1: {
                    printWriter.print("info");
                }
            }
            printWriter.print("\"> <a href=\"");
            printWriter.print(String.valueOf(n));
            printWriter.print("\">");
            if (iMessage.getPrefix() != null) {
                printWriter.print(iMessage.getPrefix());
            }
            printWriter.print(iMessage.getMessage());
            printWriter.println("</a></li>");
            ++n;
        }
        printWriter.println("</form>");
        printWriter.flush();
        return stringWriter.toString();
    }

    private Image getImage(int n) {
        switch (n) {
            case 3: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            case 2: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            case 1: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }

    protected void configureFormText(final Form form, FormText formText) {
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                String string = (String)hyperlinkEvent.getHref();
                try {
                    int n = Integer.parseInt(string);
                    IMessage[] iMessageArray = form.getChildrenMessages();
                    IMessage iMessage = iMessageArray[n];
                    Control control = iMessage.getControl();
                    ((FormText)hyperlinkEvent.widget).getShell().dispose();
                    if (control != null) {
                        control.setFocus();
                    }
                }
                catch (Throwable throwable) {
                    ((FormText)hyperlinkEvent.widget).getShell().dispose();
                }
            }
        });
        formText.setImage("error", this.getImage(3));
        formText.setImage("warning", this.getImage(2));
        formText.setImage("info", this.getImage(1));
    }

    protected final FormText createClient(Composite composite, String string, FormToolkit formToolkit, IHyperlinkListener iHyperlinkListener) {
        FormText formText = formToolkit.createFormText(composite, true);
        try {
            formText.setText(string, true, false);
        }
        catch (SWTException sWTException) {
            formText.setText(sWTException.getMessage(), false, false);
        }
        formText.addHyperlinkListener(iHyperlinkListener);
        return formText;
    }

    protected void createErrorMessageHandler(IManagedForm iManagedForm) {
        final ScrolledForm scrolledForm = iManagedForm.getForm();
        final FormToolkit formToolkit = iManagedForm.getToolkit();
        formToolkit.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        scrolledForm.getForm().addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                String string = hyperlinkEvent.getLabel();
                Object object = hyperlinkEvent.getHref();
                Point point = ((Control)hyperlinkEvent.widget).toDisplay(0, 0);
                point.x += 10;
                point.y += 10;
                Shell shell = new Shell(scrolledForm.getShell(), 16388);
                shell.setImage(AbstractJADEditorPage.this.getImage(scrolledForm.getMessageType()));
                shell.setText(string);
                shell.setLayout((Layout)new FillLayout());
                FormText formText = formToolkit.createFormText((Composite)shell, true);
                AbstractJADEditorPage.this.configureFormText(scrolledForm.getForm(), formText);
                if (object instanceof IMessage[]) {
                    formText.setText(AbstractJADEditorPage.this.createFormTextContent((IMessage[])object), true, false);
                }
                shell.setLocation(point);
                shell.pack();
                shell.open();
            }
        });
        this.errorMessageManager = iManagedForm.getMessageManager();
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        scrolledForm.setText(this.getTitle());
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        this.createErrorMessageHandler(iManagedForm);
        final String string = this.getHelpResource();
        if (string != null) {
            IToolBarManager iToolBarManager = scrolledForm.getToolBarManager();
            Action action = new Action("help"){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
                }
            };
            action.setImageDescriptor(MTJUIPlugin.getIconImageDescriptor("linkto_help.gif"));
            iToolBarManager.add((IAction)action);
        }
        scrolledForm.updateToolBar();
    }

    protected final Section createStaticBasicSection(FormToolkit formToolkit, Composite composite, String string, String string2) {
        Section section = formToolkit.createSection(composite, 384);
        section.setText(string);
        section.setDescription(string2);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData tableWrapData = new TableWrapData(256);
        section.setLayoutData((Object)tableWrapData);
        return section;
    }

    protected final Section createStaticSection(FormToolkit formToolkit, Composite composite, String string) {
        Section section = formToolkit.createSection(composite, 256);
        section.clientVerticalSpacing = 6;
        section.setText(string);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData tableWrapData = new TableWrapData(256);
        section.setLayoutData((Object)tableWrapData);
        return section;
    }

    protected Composite createStaticSectionClient(FormToolkit formToolkit, Composite composite) {
        Composite composite2 = formToolkit.createComposite(composite, 0);
        composite2.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        TableWrapData tableWrapData = new TableWrapData(256);
        composite2.setLayoutData((Object)tableWrapData);
        return composite2;
    }

    protected abstract String getHelpResource();

    protected ManifestPreferenceStore getPreferenceStore() {
        return this.editor.getPreferenceStore();
    }
}

