/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.actions.packaging;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.LoggingSafeRunnable;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.ui.internal.actions.AbstractJavaProjectAction;
import org.eclipse.mtj.ui.internal.actions.ConfigurationErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractCreatePackageAction
extends AbstractJavaProjectAction {
    public void run(IAction iAction) {
        if (this.selection != null && !this.selection.isEmpty()) {
            boolean bl = true;
            if (this.shouldObfuscate() && !this.selection.isEmpty()) {
                bl = this.isProguardConfigurationValid();
            }
            if (!bl) {
                this.warnAboutProguardConfiguration();
            } else {
                try {
                    this.doPackageCreation();
                }
                catch (CoreException coreException) {
                    MTJCorePlugin.log((int)4, (String)"Creating package", (Throwable)coreException);
                }
            }
        }
    }

    public void run(IJavaProject iJavaProject, IWorkbenchPart iWorkbenchPart) {
        boolean bl = true;
        if (this.shouldObfuscate()) {
            bl = this.isProguardConfigurationValid();
        }
        if (!bl) {
            this.warnAboutProguardConfiguration();
        } else {
            try {
                this.doPackageCreation(iJavaProject, iWorkbenchPart);
            }
            catch (Throwable throwable) {
                MTJCorePlugin.log((int)4, (String)"Creating package", (Throwable)throwable);
            }
        }
    }

    private void createPackageForProject(IProgressMonitor iProgressMonitor, IJavaProject iJavaProject) {
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        try {
            iMidletSuiteProject.createPackage(iProgressMonitor, this.shouldObfuscate());
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)4, (String)"createPackageForProject", (Throwable)coreException);
            ErrorDialog.openError((Shell)this.getShell(), (String)("Error packaging " + iJavaProject.getElementName()), (String)coreException.getMessage(), (IStatus)coreException.getStatus());
        }
    }

    private boolean doesProjectHaveValidDevice(IJavaProject iJavaProject) {
        boolean bl = false;
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        if (iMidletSuiteProject != null) {
            IDevice iDevice = iMidletSuiteProject.getDevice();
            bl = iDevice != null;
        }
        return bl;
    }

    private void doPackageCreation() throws CoreException {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.workbenchPart.getSite().getShell());
        progressMonitorDialog.open();
        final IProgressMonitor iProgressMonitor = progressMonitorDialog.getProgressMonitor();
        iProgressMonitor.beginTask("Create Packages", 3);
        Iterator iterator = this.selection.iterator();
        while (iterator.hasNext()) {
            final IJavaProject iJavaProject = this.getJavaProject(iterator.next());
            if (iJavaProject == null) continue;
            if (this.doesProjectHaveValidDevice(iJavaProject)) {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        AbstractCreatePackageAction.this.createPackageForProject(iProgressMonitor, iJavaProject);
                    }
                });
                continue;
            }
            this.warnAboutInvalidDevice(iJavaProject);
        }
        iProgressMonitor.done();
        progressMonitorDialog.close();
    }

    private void doPackageCreation(final IJavaProject iJavaProject, IWorkbenchPart iWorkbenchPart) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(iWorkbenchPart.getSite().getShell());
        progressMonitorDialog.open();
        final IProgressMonitor iProgressMonitor = progressMonitorDialog.getProgressMonitor();
        iProgressMonitor.beginTask("Create Packages", 3);
        if (iJavaProject != null) {
            if (this.doesProjectHaveValidDevice(iJavaProject)) {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        AbstractCreatePackageAction.this.createPackageForProject(iProgressMonitor, iJavaProject);
                    }
                });
            } else {
                this.warnAboutInvalidDevice(iJavaProject);
            }
        }
        iProgressMonitor.done();
        progressMonitorDialog.close();
    }

    private boolean isProguardConfigurationValid() {
        return MTJCorePlugin.getProguardJarFile().exists();
    }

    private void warnAboutInvalidDevice(IJavaProject iJavaProject) {
        String string = String.valueOf(iJavaProject.getElementName()) + " does not have a valid device.\n" + iJavaProject.getElementName() + " will not be packaged.";
        MessageDialog.openWarning((Shell)this.getShell(), (String)"Invalid Device", (String)string);
    }

    private void warnAboutProguardConfiguration() {
        String string = "Proguard is not correctly configured.\nPlease configure Proguard preferences.";
        ConfigurationErrorDialog configurationErrorDialog = new ConfigurationErrorDialog(this.getShell(), "org.eclipse.mtj.ui.preferences.ObfuscationPreferencePage", "Obfuscation Error", string, "Configure Proguard...");
        configurationErrorDialog.open();
    }

    protected abstract boolean shouldObfuscate();
}

