/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.actions.preprocessing;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.preprocessor.PreprocessingNature;
import org.eclipse.mtj.ui.internal.actions.AbstractJavaProjectAction;

public class DisablePreprocessingAction
extends AbstractJavaProjectAction {
    public void run(IAction iAction) {
        IJavaProject iJavaProject;
        if (this.selection != null && !this.selection.isEmpty() && (iJavaProject = this.getJavaProject(this.selection.getFirstElement())) != null) {
            try {
                this.disablePreprocessing(iJavaProject);
            }
            catch (CoreException coreException) {
                MTJCorePlugin.log((int)4, (Throwable)coreException);
            }
        }
    }

    private void disablePreprocessing(IJavaProject iJavaProject) throws CoreException {
        IProject iProject = iJavaProject.getProject();
        PreprocessingNature.deconfigureBuilders((IProject)iProject, (IProgressMonitor)new NullProgressMonitor());
        IProjectDescription iProjectDescription = iProject.getDescription();
        this.updateNatures(iProjectDescription);
        iProject.setDescription(iProjectDescription, (IProgressMonitor)new NullProgressMonitor());
    }

    private void updateNatures(IProjectDescription iProjectDescription) {
        ArrayList arrayList = new ArrayList(Arrays.asList(iProjectDescription.getNatureIds()));
        arrayList.remove("org.eclipse.mtj.core.preprocessingNature");
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        iProjectDescription.setNatureIds(stringArray);
    }
}

