/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.devices;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.devices.DeviceEditorConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceEditorRegistry {
    public static final String ID_EXTENSION = "deviceEditor";
    private static DeviceEditorConfigElement[] editors;

    public static DeviceEditorConfigElement findEditorElement(IDevice iDevice) {
        DeviceEditorConfigElement deviceEditorConfigElement = null;
        DeviceEditorConfigElement[] deviceEditorConfigElementArray = DeviceEditorRegistry.getEditors();
        Class<?> clazz = iDevice.getClass();
        DeviceEditorConfigElement[] deviceEditorConfigElementArray2 = deviceEditorConfigElementArray;
        int n = deviceEditorConfigElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceEditorConfigElement deviceEditorConfigElement2 = deviceEditorConfigElementArray2[n2];
            String string = deviceEditorConfigElement2.getDeviceClass();
            if (DeviceEditorRegistry.isMatchingType(clazz, string)) {
                deviceEditorConfigElement = deviceEditorConfigElement2;
                break;
            }
            ++n2;
        }
        return deviceEditorConfigElement;
    }

    private static DeviceEditorConfigElement[] getEditors() {
        if (editors == null) {
            editors = DeviceEditorRegistry.readEditors();
        }
        return editors;
    }

    private static boolean isMatchingType(Class<?> clazz, String string) {
        boolean bl = false;
        if (clazz != null) {
            bl = clazz.getName().equals(string);
            if (!bl) {
                bl = DeviceEditorRegistry.isMatchingType(clazz.getSuperclass(), string);
            }
            if (!bl) {
                Class<?>[] classArray = clazz.getInterfaces();
                int n = 0;
                while (!bl && n < classArray.length) {
                    bl = DeviceEditorRegistry.isMatchingType(classArray[n], string);
                    ++n;
                }
            }
        }
        return bl;
    }

    private static DeviceEditorConfigElement[] readEditors() {
        String string = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string, ID_EXTENSION);
        DeviceEditorConfigElement[] deviceEditorConfigElementArray = new DeviceEditorConfigElement[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            deviceEditorConfigElementArray[n] = new DeviceEditorConfigElement(iConfigurationElementArray[n]);
            ++n;
        }
        return deviceEditorConfigElementArray;
    }

    private DeviceEditorRegistry() {
    }
}

