/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.devices;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.library.api.API;
import org.eclipse.swt.graphics.Image;

public class DeviceTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String TEXT_UNKNOWN = "";
    private static final int COL_CHECKBOX = 0;
    private static final int COL_GROUP_NAME = 1;
    private static final int COL_NAME = 2;
    private static final int COL_CONFIGURATION = 3;
    private static final int COL_PROFILE = 4;

    public Image getColumnImage(Object object, int n) {
        return null;
    }

    public String getColumnText(Object object, int n) {
        String string = TEXT_UNKNOWN;
        IDevice iDevice = (IDevice)object;
        switch (n) {
            case 0: {
                string = TEXT_UNKNOWN;
                break;
            }
            case 2: {
                string = iDevice.getName();
                break;
            }
            case 1: {
                string = iDevice.getGroupName();
                break;
            }
            case 3: {
                string = this.getConfigurationText(iDevice);
                break;
            }
            case 4: {
                string = this.getProfileText(iDevice);
            }
        }
        return string;
    }

    private String getConfigurationText(IDevice iDevice) {
        API aPI;
        String string = TEXT_UNKNOWN;
        ILibrary iLibrary = iDevice.getConfigurationLibrary();
        if (iLibrary != null && (aPI = iLibrary.getConfiguration()) != null) {
            string = aPI.toString();
        }
        return string;
    }

    private String getProfileText(IDevice iDevice) {
        API aPI;
        String string = TEXT_UNKNOWN;
        ILibrary iLibrary = iDevice.getProfileLibrary();
        if (iLibrary != null && (aPI = iLibrary.getProfile()) != null) {
            string = aPI.toString();
        }
        return string;
    }
}

