/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.forms.blocks;

import java.util.ArrayList;
import org.eclipse.mtj.ui.internal.editors.EditorsUIContent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ButtonBarBlock {
    public static final int BUTTON_NONE = 0;
    public static final int BUTTON_ADD = 2;
    public static final int BUTTON_ADD_INDEX = 0;
    public static final int BUTTON_REMOVE = 4;
    public static final int BUTTON_REMOVE_INDEX = 1;
    public static final int BUTTON_UP = 8;
    public static final int BUTTON_UP_INDEX = 2;
    public static final int BUTTON_DOWN = 16;
    public static final int BUTTON_DOWN_INDEX = 3;
    private ArrayList<Button> buttons;

    public ButtonBarBlock(Composite composite, FormToolkit formToolkit, int n) {
        this.initialize(composite, formToolkit);
        if ((n & 2) != 0) {
            this.setEnabled(0, true);
        }
        if ((n & 4) != 0) {
            this.setEnabled(1, true);
        }
        if ((n & 8) != 0) {
            this.setEnabled(2, true);
        }
        if ((n & 0x10) != 0) {
            this.setEnabled(3, true);
        }
    }

    public void addButtonListener(int n, int n2, Listener listener) {
        this.buttons.get(n).addListener(n2, listener);
    }

    public Button getButton(int n) {
        return this.buttons.get(n);
    }

    public boolean isButtonEnabled(int n) {
        return this.buttons.get(n).isEnabled();
    }

    public void setButtonMouseListener(int n, MouseListener mouseListener) {
        this.buttons.get(n).addMouseListener(mouseListener);
    }

    public void setEnabled(int n, boolean bl) {
        this.buttons.get(n).setEnabled(bl);
    }

    private void initialize(Composite composite, FormToolkit formToolkit) {
        this.buttons = new ArrayList(4);
        Button button = formToolkit.createButton(composite, EditorsUIContent.buttonBarBlock_button_add, 8);
        button.setEnabled(false);
        this.buttons.add(button);
        Button button2 = formToolkit.createButton(composite, EditorsUIContent.buttonBarBlock_button_remove, 8);
        button2.setEnabled(false);
        this.buttons.add(button2);
        Button button3 = formToolkit.createButton(composite, EditorsUIContent.buttonBarBlock_button_up, 8);
        button3.setEnabled(false);
        this.buttons.add(button3);
        Button button4 = formToolkit.createButton(composite, EditorsUIContent.buttonBarBlock_button_down, 8);
        button4.setEnabled(false);
        this.buttons.add(button4);
    }
}

