/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.importer.common;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ArchiveUtils;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ProjectRecord;
import org.eclipse.mtj.ui.internal.wizards.importer.common.StatusUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectImporter {
    protected Set<String> skipFolders = new HashSet<String>();

    public ProjectRecord[] searchProjectsFromProvider(ILeveledImportStructureProvider iLeveledImportStructureProvider, IProgressMonitor iProgressMonitor) {
        ArrayList<ProjectRecord> arrayList = new ArrayList<ProjectRecord>();
        Object object = iLeveledImportStructureProvider.getRoot();
        this.collectProjectsFromProvider(arrayList, object, iLeveledImportStructureProvider, iProgressMonitor);
        return arrayList.toArray(new ProjectRecord[0]);
    }

    public ProjectRecord[] searchProjectsFromDirectory(File file, IProgressMonitor iProgressMonitor) {
        ArrayList<ProjectRecord> arrayList = new ArrayList<ProjectRecord>();
        this.collectProjectsFromDirectory(arrayList, file, new HashSet<String>(), iProgressMonitor);
        return arrayList.toArray(new ProjectRecord[0]);
    }

    private void collectProjectsFromDirectory(Collection<ProjectRecord> collection, File file, Set<String> set, IProgressMonitor iProgressMonitor) {
        File[] fileArray;
        if (iProgressMonitor == null || iProgressMonitor.isCanceled() || !file.isDirectory()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        subMonitor.setTaskName(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CheckingMessage, (Object)file.getPath()));
        try {
            set.add(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, iOException.getLocalizedMessage(), iOException));
        }
        File file2 = new File(file, this.getProjectDescriptorFile());
        if (file2.exists() && (fileArray = this.createProjectRecord(file.getAbsolutePath(), null)) != null) {
            collection.add((ProjectRecord)fileArray);
            subMonitor.done();
            return;
        }
        fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        subMonitor.setWorkRemaining(fileArray.length);
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                File file3 = fileArray2[n2];
                if (!this.skipFolders.contains(file3.getName())) {
                    block8: {
                        try {
                            String string = file3.getCanonicalPath();
                            if (set.add(string)) break block8;
                            break block9;
                        }
                        catch (IOException iOException) {
                            StatusManager.getManager().handle(StatusUtil.newStatus(4, iOException.getLocalizedMessage(), iOException));
                        }
                    }
                    this.collectProjectsFromDirectory(collection, file3, set, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            ++n2;
        }
        subMonitor.done();
    }

    protected abstract ProjectRecord createProjectRecord(String var1, ILeveledImportStructureProvider var2);

    public abstract String getProjectDescriptorFile();

    private void collectProjectsFromProvider(Collection<ProjectRecord> collection, Object object, ILeveledImportStructureProvider iLeveledImportStructureProvider, IProgressMonitor iProgressMonitor) {
        Object object2;
        if (iProgressMonitor == null || iProgressMonitor.isCanceled()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        subMonitor.setTaskName(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CheckingMessage, (Object)iLeveledImportStructureProvider.getLabel(object)));
        Object object3 = ArchiveUtils.getChild(iLeveledImportStructureProvider, object, this.getProjectDescriptorFile());
        if (object3 != null && (object2 = this.createProjectRecord(iLeveledImportStructureProvider.getFullPath(object), iLeveledImportStructureProvider)) != null) {
            collection.add((ProjectRecord)object2);
            subMonitor.done();
            return;
        }
        object2 = ArchiveUtils.listSubfolders(iLeveledImportStructureProvider, object);
        subMonitor.setWorkRemaining(((Object[])object2).length);
        Object object4 = object2;
        int n = ((Object[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            Object object5 = object4[n2];
            if (!this.skipFolders.contains(iLeveledImportStructureProvider.getLabel(object5))) {
                this.collectProjectsFromProvider(collection, object5, iLeveledImportStructureProvider, (IProgressMonitor)subMonitor.newChild(1));
            }
            ++n2;
        }
        subMonitor.done();
    }

    public abstract void projectCreated(ProjectRecord var1, IProject var2, IProgressMonitor var3) throws CoreException;

    public abstract IDevice getProjectDevice(ProjectRecord var1) throws CoreException;
}

