/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.importer.netbeans;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.internal.utils.XMLUtils;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ProjectImporter;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ProjectRecord;
import org.eclipse.mtj.ui.internal.wizards.importer.common.StatusUtil;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NetBeansProjectImporter
extends ProjectImporter {
    private static final String NB_PROJECT_PROPERTIES = "project.properties";
    private static final String NB_DEVICE_NAME = "platform.device";
    private static final String NB_DEVICE_GROUP = "platform.active.description";
    private static final String MTJ_APPLICATION_DESCRIPTOR = "Application Descriptor";
    private static final String JAD_EXTENSION = ".jad";
    private static final String NB_BUILD_XML = "build.xml";
    private static final String NB_DIST_FOLDER = "dist";
    private static final String NB_METADATA_FOLDER = "nbproject";
    private static final String NB_BUILD_FOLDER = "build";
    private static final String NB_PROJECT_NAME_KEY = "name";
    private static final String NB_PROJECT_TYPE_MOBILITY = "org.netbeans.modules.kjava.j2meproject";
    private static final String NB_PROJECT_TYPE_KEY = "type";
    private static final String NB_PROJECT_DESCRIPTOR_FILE = "nbproject/project.xml";
    private static final HashMap<String, String> JAD_MAPPING = new HashMap();

    static {
        JAD_MAPPING.put("manifest.others", null);
        JAD_MAPPING.put("platform.configuration", "MicroEdition-Configuration");
        JAD_MAPPING.put("platform.profile", "MicroEdition-Profile");
        JAD_MAPPING.put("dist.jar", "MIDlet-Jar-URL");
        JAD_MAPPING.put("manifest.midlets", null);
        JAD_MAPPING.put("manifest.pushregistry", null);
        JAD_MAPPING.put("manifest.apipermissions", null);
        JAD_MAPPING.put("manifest.jad", null);
    }

    public String getProjectDescriptorFile() {
        return NB_PROJECT_DESCRIPTOR_FILE;
    }

    public ProjectRecord createProjectRecord(String string, ILeveledImportStructureProvider iLeveledImportStructureProvider) {
        try {
            ProjectRecord projectRecord = new ProjectRecord();
            projectRecord.setProjectRoot(string);
            projectRecord.setProvider(iLeveledImportStructureProvider);
            InputStream inputStream = projectRecord.getResourceContents(this.getProjectDescriptorFile());
            if (this.parseDescriptor(inputStream, projectRecord)) {
                return projectRecord;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean parseDescriptor(InputStream inputStream, ProjectRecord projectRecord) throws Exception {
        Document document = XMLUtils.readDocument((InputStream)inputStream);
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagName(NB_PROJECT_TYPE_KEY).item(0);
        String string = element2.getTextContent();
        if (!string.equals(NB_PROJECT_TYPE_MOBILITY)) {
            return false;
        }
        Element element3 = (Element)element.getElementsByTagName(NB_PROJECT_NAME_KEY).item(0);
        projectRecord.setProjectName(element3.getTextContent());
        return true;
    }

    public void projectCreated(ProjectRecord projectRecord, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        this.removeFolder(iProject.getFolder(NB_BUILD_FOLDER), iProgressMonitor);
        this.removeFolder(iProject.getFolder(NB_METADATA_FOLDER), iProgressMonitor);
        this.setApplicationDescriptor(projectRecord, iProject, iProgressMonitor);
        this.removeFolder(iProject.getFolder(NB_DIST_FOLDER), iProgressMonitor);
        this.removeFile(iProject.getFile(NB_BUILD_XML), iProgressMonitor);
    }

    private byte[] loadApplicationDescriptorContents(ProjectRecord projectRecord) {
        try {
            Properties properties = this.loadProjectProperties(projectRecord);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            for (String string : JAD_MAPPING.keySet()) {
                String string2 = properties.getProperty(string);
                if (string2 == null || "".equals(string2)) continue;
                if (JAD_MAPPING.get(string) == null) {
                    outputStreamWriter.write(string2);
                    continue;
                }
                outputStreamWriter.write(String.valueOf(JAD_MAPPING.get(string)) + ": " + string2 + "\n");
            }
            outputStreamWriter.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setApplicationDescriptor(ProjectRecord projectRecord, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile = iProject.getFile("dist/" + iProject.getName() + JAD_EXTENSION);
        IFile iFile2 = iProject.getFile(MTJ_APPLICATION_DESCRIPTOR);
        if (iFile.exists()) {
            if (iFile2.exists()) {
                iFile2.delete(true, iProgressMonitor);
            }
            iFile.move(iFile2.getFullPath(), true, iProgressMonitor);
        } else {
            byte[] byArray = this.loadApplicationDescriptorContents(projectRecord);
            if (byArray != null && byArray.length > 0) {
                if (iFile2.exists()) {
                    iFile2.delete(true, iProgressMonitor);
                }
                iFile2.create((InputStream)new ByteArrayInputStream(byArray), true, iProgressMonitor);
            }
        }
    }

    private void removeFile(IFile iFile, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iFile.exists()) {
            iFile.delete(true, iProgressMonitor);
        }
    }

    private void removeFolder(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iFolder.exists()) {
            iFolder.delete(true, iProgressMonitor);
        }
    }

    public IDevice getProjectDevice(ProjectRecord projectRecord) throws CoreException {
        IDevice iDevice = null;
        try {
            Properties properties = this.loadProjectProperties(projectRecord);
            String string = properties.getProperty(NB_DEVICE_GROUP);
            String string2 = properties.getProperty(NB_DEVICE_NAME);
            iDevice = DeviceRegistry.singleton.getDevice(string, string2);
            if (iDevice != null) {
                return iDevice;
            }
        }
        catch (Exception exception) {}
        iDevice = DeviceRegistry.singleton.getDefaultDevice();
        if (iDevice == null) {
            throw new CoreException(StatusUtil.newStatus(4, NLS.bind((String)ProjectImporterMessage.ProjectImporter_DeviceNotFound, (Object)projectRecord.getProjectName()), null));
        }
        return iDevice;
    }

    private Properties loadProjectProperties(ProjectRecord projectRecord) throws FileNotFoundException, IOException {
        InputStream inputStream = projectRecord.getResourceContents("nbproject/project.properties");
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }
}

