/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.library.model.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.library.LibraryPlugin;
import org.eclipse.mtj.core.library.classpath.ClasspathAccessRule;
import org.eclipse.mtj.core.library.classpath.JavadocClasspathAttribute;
import org.eclipse.mtj.core.library.model.ILibrary;
import org.eclipse.mtj.core.library.model.Visibility;
import org.eclipse.mtj.core.library.model.licence.LicenceInfo;
import org.eclipse.mtj.core.library.model.security.PermissionList;
import org.eclipse.mtj.core.library.model.security.ProtectionDomain;
import org.eclipse.mtj.core.library.model.security.SecurityInfo;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MidletLibrary
implements ILibrary {
    private static final String EP_ATTRIB_ACCESSRULE_KIND = "kind";
    private static final String EP_ATTRIB_ACCESSRULE_PATTERN = "pattern";
    private static final String EP_ATTRIB_CLASSPATHENTRY_JARFILE = "jarFile";
    private static final String EP_ATTRIB_CLASSPATHENTRY_JAVADOCPATH = "javadocPath";
    private static final String EP_ATTRIB_CLASSPATHENTRY_SRCPATH = "srcPath";
    private static final String EP_ATTRIB_LIBRARY_DESCRIPTION = "description";
    private static final String EP_ATTRIB_LIBRARY_NAME = "name";
    private static final String EP_ATTRIB_LIBRARY_VERSION = "version";
    private static final String EP_ATTRIB_LIBRARY_VISIBILITY = "visibility";
    private static final String EP_ATTRIB_LICENSE_NAME = "name";
    private static final String EP_ATTRIB_LICENSE_URL = "url";
    private static final String EP_ATTRIB_SECURITY_PD = "ProtectionDomain";
    private static final String EP_ATTRIB_SECURITY_PERMISSIONS = "Premissions";
    private static final String EP_ELEMENT_ACCESSRULE = "AccessRule";
    private static final String EP_ELEMENT_CLASSPATHENTRY = "ClasspathEntry";
    private static final String EP_ELEMENT_LICENSE = "License";
    private static final String EP_ELEMENT_SECURITY = "Security";
    private static final String FILE_PROTOCOL = "file:/";
    private List<IClasspathEntry> classpathEntryList;
    private String description;
    private String identifier;
    private LicenceInfo licence;
    private String name;
    private SecurityInfo security;
    private Version version;
    private Visibility visibility;

    public MidletLibrary(IConfigurationElement iConfigurationElement) throws IllegalArgumentException {
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement iConfigurationElement2;
        IConfigurationElement[] iConfigurationElementArray2;
        String string = this.getBundleAbsolutePath(iConfigurationElement.getNamespaceIdentifier());
        this.classpathEntryList = new ArrayList<IClasspathEntry>();
        this.name = iConfigurationElement.getAttribute("name");
        if (this.name == null) {
            throw new IllegalArgumentException("No library name defined.");
        }
        this.visibility = Visibility.getFromString(iConfigurationElement.getAttribute(EP_ATTRIB_LIBRARY_VISIBILITY));
        if (this.visibility == Visibility.INVALID) {
            this.visibility = Visibility.PUBLIC;
        }
        String string2 = iConfigurationElement.getAttribute(EP_ATTRIB_LIBRARY_VERSION);
        try {
            this.version = new Version(string2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("The version for " + this.name + " is improperly formatted.", exception);
        }
        this.description = iConfigurationElement.getAttribute(EP_ATTRIB_LIBRARY_DESCRIPTION);
        this.identifier = String.valueOf(this.name.replace(" ", "_")) + "_" + this.version.toString();
        Object object = iConfigurationElementArray2 = iConfigurationElement.getChildren(EP_ELEMENT_CLASSPATHENTRY);
        int n = iConfigurationElementArray2.length;
        int n2 = 0;
        while (n2 < n) {
            Path path;
            Path path2;
            iConfigurationElement2 = object[n2];
            Path path3 = new Path(String.valueOf(string) + File.separator + iConfigurationElement2.getAttribute(EP_ATTRIB_CLASSPATHENTRY_JARFILE));
            String string3 = iConfigurationElement2.getAttribute(EP_ATTRIB_CLASSPATHENTRY_SRCPATH);
            Path path4 = null;
            if (string3 != null) {
                path4 = new Path(String.valueOf(string) + File.separator + string3);
            }
            String string4 = iConfigurationElement2.getAttribute(EP_ATTRIB_CLASSPATHENTRY_JAVADOCPATH);
            IClasspathAttribute[] iClasspathAttributeArray = null;
            if (string4 != null) {
                path2 = new Path(String.valueOf(string) + File.separator + string4);
                iClasspathAttributeArray = new IClasspathAttribute[]{new JavadocClasspathAttribute(path2.toOSString())};
            } else {
                iClasspathAttributeArray = new IClasspathAttribute[]{};
            }
            path2 = iConfigurationElement2.getChildren(EP_ELEMENT_ACCESSRULE);
            ArrayList<IAccessRule> arrayList = new ArrayList<IAccessRule>();
            Path path5 = path2;
            int n3 = ((Path)path5).length;
            int n4 = 0;
            while (n4 < n3) {
                path = path5[n4];
                ClasspathAccessRule classpathAccessRule = new ClasspathAccessRule((IPath)new Path(path.getAttribute(EP_ATTRIB_ACCESSRULE_PATTERN)), path.getAttribute(EP_ATTRIB_ACCESSRULE_KIND));
                arrayList.add(JavaCore.newAccessRule((IPath)classpathAccessRule.getPattern(), (int)classpathAccessRule.getKind()));
                ++n4;
            }
            path = JavaCore.newLibraryEntry((IPath)path3, (IPath)path4, null, (IAccessRule[])arrayList.toArray(new IAccessRule[0]), (IClasspathAttribute[])iClasspathAttributeArray, (boolean)true);
            this.classpathEntryList.add((IClasspathEntry)path);
            ++n2;
        }
        iConfigurationElement2 = iConfigurationElement.getChildren(EP_ELEMENT_LICENSE);
        try {
            iConfigurationElementArray = null;
            try {
                iConfigurationElementArray = URI.create(iConfigurationElement2[0].getAttribute(EP_ATTRIB_LICENSE_URL));
            }
            catch (Throwable throwable) {}
            this.licence = new LicenceInfo(iConfigurationElement2[0].getAttribute("name"), (URI)iConfigurationElementArray);
        }
        catch (Throwable throwable) {
            LibraryPlugin.log(2, "No Lincense information available for " + this.name, throwable);
        }
        iConfigurationElementArray = iConfigurationElement.getChildren(EP_ELEMENT_SECURITY);
        ProtectionDomain protectionDomain = null;
        try {
            protectionDomain = new ProtectionDomain(iConfigurationElementArray[0].getAttribute(EP_ATTRIB_SECURITY_PD));
        }
        catch (Throwable throwable) {
            protectionDomain = new ProtectionDomain(ProtectionDomain.ProtectionDomainType.UNTRUSTED);
            LibraryPlugin.log(2, "No Protection Domain information available for " + this.name + ". the Untrusted domain will be used.", throwable);
        }
        object = null;
        try {
            object = new PermissionList(iConfigurationElementArray[0].getAttribute(EP_ATTRIB_SECURITY_PERMISSIONS));
        }
        catch (Throwable throwable) {
            object = PermissionList.EMPTY;
            LibraryPlugin.log(2, "No permission information available for " + this.name, throwable);
        }
        this.security = new SecurityInfo(protectionDomain, (PermissionList)object);
    }

    public MidletLibrary(String string, String string2, String string3, Visibility visibility, Version version, LicenceInfo licenceInfo, SecurityInfo securityInfo) throws IllegalArgumentException {
        if (string2 == null) {
            throw new IllegalArgumentException("No library name defined.");
        }
        if (version == null) {
            throw new IllegalArgumentException("No version was provided for " + string2);
        }
        if (visibility == null) {
            throw new IllegalArgumentException("No visibility was provided for " + string2);
        }
        this.name = string2;
        this.visibility = visibility;
        this.version = version;
        this.identifier = string;
        this.description = string3;
        this.licence = licenceInfo;
        this.classpathEntryList = new ArrayList<IClasspathEntry>();
        this.security = securityInfo;
    }

    @Override
    public void addClasspathEntry(IClasspathEntry iClasspathEntry) {
        this.classpathEntryList.add(iClasspathEntry);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MidletLibrary midletLibrary = (MidletLibrary)object;
        if (this.classpathEntryList == null ? midletLibrary.classpathEntryList != null : !this.classpathEntryList.equals(midletLibrary.classpathEntryList)) {
            return false;
        }
        if (this.description == null ? midletLibrary.description != null : !this.description.equals(midletLibrary.description)) {
            return false;
        }
        if (this.identifier == null ? midletLibrary.identifier != null : !this.identifier.equals(midletLibrary.identifier)) {
            return false;
        }
        if (this.licence == null ? midletLibrary.licence != null : !this.licence.equals(midletLibrary.licence)) {
            return false;
        }
        if (this.name == null ? midletLibrary.name != null : !this.name.equals(midletLibrary.name)) {
            return false;
        }
        if (this.security == null ? midletLibrary.security != null : !this.security.equals(midletLibrary.security)) {
            return false;
        }
        if (this.version == null ? midletLibrary.version != null : !this.version.equals((Object)midletLibrary.version)) {
            return false;
        }
        return !(this.visibility == null ? midletLibrary.visibility != null : !this.visibility.equals((Object)midletLibrary.visibility));
    }

    @Override
    public List<IClasspathEntry> getClasspathEntryList() {
        return Collections.unmodifiableList(this.classpathEntryList);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public LicenceInfo getLicence() {
        return this.licence;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SecurityInfo getSecurity() {
        return this.security;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.classpathEntryList == null ? 0 : this.classpathEntryList.hashCode());
        n = 31 * n + (this.description == null ? 0 : this.description.hashCode());
        n = 31 * n + (this.identifier == null ? 0 : this.identifier.hashCode());
        n = 31 * n + (this.licence == null ? 0 : this.licence.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.security == null ? 0 : this.security.hashCode());
        n = 31 * n + (this.version == null ? 0 : this.version.hashCode());
        n = 31 * n + (this.visibility == null ? 0 : this.visibility.hashCode());
        return n;
    }

    @Override
    public void removeClasspathEntry(IClasspathEntry iClasspathEntry) {
        this.classpathEntryList.remove(iClasspathEntry);
    }

    @Override
    public void setClasspathEntryList(List<IClasspathEntry> list) {
        this.classpathEntryList = list;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public void setIdentifier(String string) {
        this.identifier = string;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    private String getBundleAbsolutePath(String string) {
        String string2 = new String();
        URL uRL = Platform.getBundle((String)string).getEntry("/");
        String string3 = "";
        try {
            string3 = FileLocator.toFileURL((URL)uRL).getPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        URL uRL2 = null;
        try {
            uRL2 = new File(string3).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        if (uRL2 != null && (string2 = uRL2.getFile()).startsWith(FILE_PROTOCOL)) {
            string2 = string2.substring(FILE_PROTOCOL.length() + 1);
        }
        return string2;
    }
}

