/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.library.manager;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.library.LibraryPlugin;
import org.eclipse.mtj.core.library.model.ILibrary;
import org.eclipse.mtj.core.library.model.impl.MidletLibrary;
import org.eclipse.osgi.util.NLS;

public class LibraryManager {
    private static final String EXT_MIDLETLIBRARY = "MIDletLibrary";
    private static LibraryManager LibraryManagerInstance;
    private Map<String, MidletLibrary> midletLibraries;

    public static synchronized LibraryManager getInstance() {
        if (LibraryManagerInstance == null) {
            LibraryManagerInstance = new LibraryManager();
        }
        return LibraryManagerInstance;
    }

    private LibraryManager() {
        this.initialize();
    }

    public void addLibraryToMidletProject(IProject iProject, String string) throws CoreException {
        Object object;
        Object object2;
        if (!iProject.hasNature("org.eclipse.mtj.core.nature")) {
            object2 = NLS.bind((String)"Project {0} must have a {1} nature.", (Object[])new String[]{iProject.getName(), "org.eclipse.mtj.core.nature"});
            MTJCorePlugin.throwCoreException((int)4, (int)-999, (String)object2);
        }
        if ((object2 = this.getMidletLibrary(string)) == null) {
            object = NLS.bind((String)"LibraryManager does not contain a {0} library.", (Object)string);
            MTJCorePlugin.throwCoreException((int)4, (int)-999, (String)object);
        }
        object = JavaCore.create((IProject)iProject);
        LinkedList<IClasspathEntry> linkedList = new LinkedList<IClasspathEntry>();
        linkedList.addAll((Collection)Arrays.asList(object.getRawClasspath()));
        try {
            Path path = new Path("org.eclipse.mtj.core.library.MIDLET_LIBRARY" + File.separator + object2.getName());
            linkedList.add(JavaCore.newContainerEntry((IPath)path, (boolean)true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object.setRawClasspath(null, (IProgressMonitor)new NullProgressMonitor());
        object.setRawClasspath(linkedList.toArray(new IClasspathEntry[linkedList.size()]), (IProgressMonitor)new NullProgressMonitor());
        Utils.addNatureToProject((IProject)object.getProject(), (String)"org.eclipse.mtj.jmunit.jmunitNature", (IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized ILibrary getMidletLibrary(String string) {
        return this.midletLibraries.get(string);
    }

    public synchronized String[] getMidletLibraryNames() {
        Set<String> set = this.midletLibraries.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void removeLibraryFromMidletProject(IProject iProject, String string) throws CoreException {
        Object object;
        Object object2;
        if (!iProject.hasNature("org.eclipse.mtj.core.nature")) {
            object2 = NLS.bind((String)"Project {0} must have a {1} nature.", (Object[])new String[]{iProject.getName(), "org.eclipse.mtj.core.nature"});
            MTJCorePlugin.throwCoreException((int)4, (int)-999, (String)object2);
        }
        if ((object2 = this.getMidletLibrary(string)) == null) {
            object = NLS.bind((String)"LibraryManager does not contain a {0} library.", (Object)string);
            MTJCorePlugin.throwCoreException((int)4, (int)-999, (String)object);
        }
        object = JavaCore.create((IProject)iProject);
        Path path = new Path("org.eclipse.mtj.core.library.MIDLET_LIBRARY" + File.separator + object2.getName());
        List<IClasspathEntry> list = Arrays.asList(new IClasspathEntry[0]);
        for (IClasspathEntry iClasspathEntry : list) {
            if (!iClasspathEntry.getPath().toString().equals(path.toString())) continue;
            list.remove(iClasspathEntry);
        }
        object.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), (IProgressMonitor)new NullProgressMonitor());
    }

    private void initialize() {
        IConfigurationElement[] iConfigurationElementArray;
        this.midletLibraries = new HashMap<String, MidletLibrary>();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.mtj.core.library", EXT_MIDLETLIBRARY);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            MidletLibrary midletLibrary = null;
            try {
                midletLibrary = new MidletLibrary(iConfigurationElement);
            }
            catch (Throwable throwable) {
                LibraryPlugin.log(4, "Failed to load MidletLibrary", throwable);
            }
            if (midletLibrary != null) {
                this.midletLibraries.put(midletLibrary.getName(), midletLibrary);
            }
            ++n2;
        }
    }
}

