/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.utils.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.mtj.core.internal.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTool {
    public static final String JAVA_APP_LAUNCH_ID = "org.eclipse.jdt.launching.localJavaApplication";

    protected abstract String[] getArguments();

    protected abstract String getClassName();

    protected abstract String[] getClasspath();

    protected abstract String getName();

    protected abstract String[] getVMArguments();

    public ILaunch launch(IProgressMonitor iProgressMonitor) throws CoreException {
        Launch launch = null;
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        ILaunchManager iLaunchManager = debugPlugin.getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType(JAVA_APP_LAUNCH_ID);
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getName());
        this.fillLaunchConfig(iLaunchConfigurationWorkingCopy);
        launch = new Launch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, "run", null);
        ILaunchConfigurationDelegate iLaunchConfigurationDelegate = iLaunchConfigurationType.getDelegate("run");
        iLaunchConfigurationDelegate.launch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, "run", (ILaunch)launch, iProgressMonitor);
        Utils.dumpCommandLine((ILaunch)launch);
        return launch;
    }

    private void fillLaunchConfig(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) throws CoreException {
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.getClassName());
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, this.getClasspathMementos());
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getProgramArgumentsString());
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getVMArgumentsString());
    }

    private String getArgumentsString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void addStandardLibraries(List<String> list) throws CoreException {
        LibraryLocation[] libraryLocationArray;
        IVMInstall iVMInstall = JavaRuntime.getDefaultVMInstall();
        if (iVMInstall != null && (libraryLocationArray = JavaRuntime.getLibraryLocations((IVMInstall)iVMInstall)) != null) {
            int n = 0;
            while (n < libraryLocationArray.length) {
                IPath iPath = libraryLocationArray[n].getSystemLibraryPath();
                IRuntimeClasspathEntry iRuntimeClasspathEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)iPath);
                iRuntimeClasspathEntry.setClasspathProperty(1);
                list.add(iRuntimeClasspathEntry.getMemento());
                ++n;
            }
        }
    }

    private List<String> getClasspathMementos() throws CoreException {
        String[] stringArray = this.getClasspath();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            IClasspathEntry iClasspathEntry = JavaCore.newLibraryEntry((IPath)new Path(string), null, null);
            RuntimeClasspathEntry runtimeClasspathEntry = new RuntimeClasspathEntry(iClasspathEntry);
            arrayList.add(runtimeClasspathEntry.getMemento());
            ++n;
        }
        this.addStandardLibraries(arrayList);
        return arrayList;
    }

    private String getProgramArgumentsString() {
        return this.getArgumentsString(this.getArguments());
    }

    private String getVMArgumentsString() {
        return this.getArgumentsString(this.getVMArguments());
    }
}

