/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.library.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.Version;
import org.eclipse.mtj.core.model.library.api.API;
import org.eclipse.mtj.core.model.library.api.APIType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIRegistry {
    private static final String ATTR_VERSION = "API-Specification-Version";
    private static final String ATTR_IDENTIFIER = "API";
    private static final String ATTR_NAME = "API-Name";
    private static final String ATTR_TYPE = "API-Type";
    private static final String ATTR_TYPE_PROFILE = "Profile";
    private static final String ATTR_TYPE_CONFIGURATION = "Configuration";
    private static final String ATTR_TYPE_OPTIONAL = "Optional";
    private static final String EXT_API = "api";
    private static List<API> orderedApis;
    private static Map<String, List<API>> apisByIdentifier;

    public static List<API> getAPIDefinitions() throws IOException {
        if (orderedApis == null) {
            orderedApis = APIRegistry.readAPIDefinitions();
        }
        return orderedApis;
    }

    public static API getAPI(String string, Version version) {
        API aPI = null;
        try {
            Map<String, List<API>> map = APIRegistry.getAPIsByIdentifier();
            List<API> list = map.get(string);
            for (API aPI2 : list) {
                if (!version.equals(aPI2.getVersion())) continue;
                aPI = aPI2;
                break;
            }
        }
        catch (IOException iOException) {
            MTJCorePlugin.log(2, iOException);
        }
        return aPI;
    }

    public static API[] getAPIs(File file) {
        Object object;
        HashMap<String, API> hashMap;
        block17: {
            hashMap = new HashMap<String, API>();
            JarFile jarFile = null;
            try {
                try {
                    jarFile = new JarFile(file);
                    if (jarFile != null) {
                        APIRegistry.addRegisteredAPIs(hashMap, jarFile);
                        if (hashMap.size() == 0 && (object = APIRegistry.createAPIFromManifest(jarFile)) != null) {
                            hashMap.put(((API)object).getIdentifier(), (API)object);
                        }
                    }
                }
                catch (IOException iOException) {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (hashMap.size() == 0) {
            object = APIRegistry.createUnknownAPI(file);
            hashMap.put(((API)object).getIdentifier(), (API)object);
        }
        object = hashMap.values();
        return object.toArray(new API[object.size()]);
    }

    private static void addRegisteredAPIs(Map<String, API> map, JarFile jarFile) throws IOException {
        String string = "";
        Manifest manifest = jarFile.getManifest();
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            string = attributes.getValue(ATTR_IDENTIFIER);
        }
        if (string != null) {
            for (API aPI : APIRegistry.getAPIDefinitions()) {
                String string2 = aPI.getPrimaryMatchableClass();
                if (string2 != null && jarFile.getEntry(string2 = String.valueOf(string2.replace('.', '/')) + ".class") != null) {
                    APIRegistry.addVersionFilteredAPI(map, aPI);
                }
                if (!string.equals(aPI.getIdentifier())) continue;
                APIRegistry.addVersionFilteredAPI(map, aPI);
            }
        }
    }

    private static void addVersionFilteredAPI(Map<String, API> map, API aPI) {
        API aPI2 = map.get(aPI.getIdentifier());
        if (aPI2 != null) {
            if (aPI.getVersion().compareTo(aPI2.getVersion()) > 0) {
                map.put(aPI.getIdentifier(), aPI);
            }
        } else if (aPI.getIdentifier().equals("IMP")) {
            if (map.get("MIDP") == null) {
                map.put(aPI.getIdentifier(), aPI);
            }
        } else if (aPI.getIdentifier().equals("MIDP")) {
            if (map.get("IMP") != null) {
                map.remove("IMP");
            }
            map.put(aPI.getIdentifier(), aPI);
        } else {
            map.put(aPI.getIdentifier(), aPI);
        }
    }

    private static API createAPIFromManifest(JarFile jarFile) throws IOException {
        Attributes attributes;
        String string;
        API aPI = null;
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (string = (attributes = manifest.getMainAttributes()).getValue(ATTR_IDENTIFIER)) != null) {
            aPI = new API();
            aPI.setIdentifier(string);
            aPI.setName(attributes.getValue(ATTR_NAME));
            aPI.setType(APIRegistry.getTypeFromManifest(attributes));
            aPI.setVersion(APIRegistry.getVersionFromManifest(attributes));
        }
        return aPI;
    }

    private static API createUnknownAPI(File file) {
        API aPI = new API();
        aPI.setIdentifier(file.getName());
        aPI.setName("Unknown Library");
        aPI.setType(APIType.UNKNOWN);
        aPI.setVersion(new Version("1.0"));
        return aPI;
    }

    private static Map<String, List<API>> getAPIsByIdentifier() throws IOException {
        if (apisByIdentifier == null) {
            apisByIdentifier = new HashMap<String, List<API>>();
            for (API aPI : APIRegistry.getAPIDefinitions()) {
                List<API> list = apisByIdentifier.get(aPI.getIdentifier());
                if (list == null) {
                    list = new ArrayList<API>();
                    apisByIdentifier.put(aPI.getIdentifier(), list);
                }
                list.add(aPI);
            }
        }
        return apisByIdentifier;
    }

    private static APIType getTypeFromManifest(Attributes attributes) {
        APIType aPIType = APIType.UNKNOWN;
        String string = attributes.getValue(ATTR_TYPE);
        if (string.equalsIgnoreCase(ATTR_TYPE_OPTIONAL)) {
            aPIType = APIType.OPTIONAL;
        } else if (string.equalsIgnoreCase(ATTR_TYPE_PROFILE)) {
            aPIType = APIType.PROFILE;
        } else if (string.equalsIgnoreCase(ATTR_TYPE_CONFIGURATION)) {
            aPIType = APIType.CONFIGURATION;
        }
        return aPIType;
    }

    private static Version getVersionFromManifest(Attributes attributes) {
        Version version = null;
        String string = attributes.getValue(ATTR_VERSION);
        version = string != null ? new Version(string) : new Version("0.0.0");
        return version;
    }

    private static List<API> readAPIDefinitions() throws IOException {
        ArrayList<API> arrayList = new ArrayList<API>();
        String string = MTJCorePlugin.getDefault().getBundle().getSymbolicName();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string, EXT_API);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            arrayList.add(new API(iConfigurationElementArray[n]));
            ++n;
        }
        return Collections.unmodifiableList(arrayList);
    }

    private APIRegistry() {
    }
}

