/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.signing;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.model.sign.ISignatureProperties;

public class SignatureProperties
implements ISignatureProperties {
    private boolean m_bSignProject;
    private String m_strKeyStoreDisplayPath;
    private String m_strKeyAlias;
    private int m_nPasswordStorageMethod;
    private String m_strKeyStorePassword;
    private String m_strKeyPassword;
    private String m_strKeyStoreType;
    private String m_strKeyStoreProvider;

    public void copy(ISignatureProperties iSignatureProperties) {
        this.m_bSignProject = iSignatureProperties.getSignProject();
        this.m_strKeyStoreDisplayPath = iSignatureProperties.getKeyStoreDisplayPath();
        this.m_strKeyAlias = iSignatureProperties.getKeyAlias();
        this.m_nPasswordStorageMethod = iSignatureProperties.getPasswordStorageMethod();
        this.m_strKeyStorePassword = iSignatureProperties.getKeyStorePassword();
        this.m_strKeyPassword = iSignatureProperties.getKeyPassword();
        this.m_strKeyStoreType = iSignatureProperties.getKeyStoreType();
        this.m_strKeyStoreProvider = iSignatureProperties.getKeyStoreProvider();
    }

    public void clear() {
        this.m_bSignProject = false;
        this.m_strKeyStoreDisplayPath = null;
        this.m_strKeyAlias = null;
        this.m_nPasswordStorageMethod = 0;
        this.m_strKeyStorePassword = null;
        this.m_strKeyPassword = null;
        this.m_strKeyStoreType = null;
        this.m_strKeyStoreProvider = null;
    }

    public boolean getSignProject() {
        return this.m_bSignProject;
    }

    public void setSignProject(boolean bl) {
        this.m_bSignProject = bl;
    }

    public int getPasswordStorageMethod() {
        return this.m_nPasswordStorageMethod;
    }

    public void setPasswordStorageMethod(int n) {
        this.m_nPasswordStorageMethod = n;
    }

    public String getKeyStoreType() {
        return this.m_strKeyStoreType;
    }

    public void setKeyStoreType(String string) {
        this.m_strKeyStoreType = string;
    }

    public String getKeyStoreProvider() {
        return this.m_strKeyStoreProvider;
    }

    public void setKeyStoreProvider(String string) {
        this.m_strKeyStoreProvider = string;
    }

    public String getKeyStorePassword() {
        return this.m_strKeyStorePassword;
    }

    public void setKeyStorePassword(String string) {
        this.m_strKeyStorePassword = string;
    }

    public String getKeyAlias() {
        return this.m_strKeyAlias;
    }

    public void setKeyAlias(String string) {
        this.m_strKeyAlias = string;
    }

    public String getKeyPassword() {
        return this.m_strKeyPassword;
    }

    public void setKeyPassword(String string) {
        this.m_strKeyPassword = string;
    }

    public String getKeyStoreDisplayPath() {
        return this.m_strKeyStoreDisplayPath;
    }

    public void setKeyStoreDisplayPath(String string) {
        this.m_strKeyStoreDisplayPath = string;
    }

    public String getAbsoluteKeyStorePath(IProject iProject) throws CoreException {
        if (this.isKeyStorePathExternal()) {
            return this.m_strKeyStoreDisplayPath;
        }
        return SignatureProperties.toAbsolute(this.m_strKeyStoreDisplayPath, iProject);
    }

    public boolean isKeyStorePathExternal() {
        if (this.m_strKeyStoreDisplayPath == null) {
            return true;
        }
        if (this.m_strKeyStoreDisplayPath.length() < "$/".length()) {
            return true;
        }
        return !"$/".equals(this.m_strKeyStoreDisplayPath.substring(0, "$/".length()));
    }

    public static String toAbsolute(String string, IProject iProject) throws CoreException {
        String string2 = string.substring("$/".length());
        IPath iPath = iProject.getLocation();
        IPath iPath2 = iPath.append(string2);
        return iPath2.toString();
    }

    public static String toRelative(String string) {
        string = string.charAt(0) == '/' ? "$/" + string.substring(1) : "$/" + string;
        return string;
    }
}

